<?php
namespace BitFire\Data;

const HEADER_KEYS =  [
    'Host' => 1,
    'Accept' => 2,
    'Accept-Language' => 3,
    'Accept-Encoding' => 4,
    'Upgrade-Insecure-Requests' => 5,
    'Cache-Control' => 6,
    'Connection' => 7,
    'Sec-Fetch-Mode' => 8,
    'Sec-Fetch-Site' => 9,
    'Sec-Ch-Ua' => 10,
    'Sec-Ch-Ua-Mobile' => 11,
    'Sec-Fetch-User' => 12,
    'User-Agent' => 13,
    'Pragma' => 14,
];


const FAST_BOTS = [
    'googlebot' => ['googlebot.com', 'google.com'],
    'yandexbot' => ['yandex.com', 'yandex.ru', 'yandex.net'],
    'bingbot' => ['microsoft.com', 'msn.com', 'live.com'],
    'baiduspider' => ['baidu.com'],
    'bingpreview' => ['microsoft.com', 'msn.com', 'live.com'],
    'duckduckbot' => ['duckduckgo.com'],
    'uptimebot' => ['uptimerobot.com', 'lstn.net'],
    'uptimerobot' => ['uptimerobot.com', 'lstn.net'],
    'archivebot' => ['archive.org'],
    'facebookexternalhit' => ['facebook.com', 'fb.com', 'fbsv.net'],
    'slurp' => ['yahoo.com'],
    'applebot' => ['apple.com']
];


const HOST = 1;
const COOKIE = 2;
const AGENT = 4;
const ACCEPT = 8;
const LANGUAGE = 16;
const INSECURE = 32;
const CACHE = 64;
const CONTENT = 128;

const FINGERPRINT_MAP2 = [
    'firefox' => [305428630],
    'chrome' => [396507524, 6285309080]
];

const FINGERPRINT_MAP = [
    'safari' => [0x8c1b435a9, 0x8c145b93, 0x8c19345, 0x8c194e5d3a, 0x8c194e5d3a2, 0x8c14b235a9, 0x1892b43ac5, 0x8c142359b, 0x8c13549, 0x8c194ed35, 0x8c194ed352, 0x8c194ead35, 0x1c984e57d3a2, 0x1c984e5d3a, 0x1c984e57d3a2, 0x1c984e5d3a2,  0x1c984e5d3a2, 0x8c194ed53a2, 0x1c94853a2, 0x1c98457a32],
    'instagram' => [0x8c1b435a9, 0x8c145b93, 0x8c194e5d3a, 0x8c194e5d3a2, 0x8c14b235a9, 0x1892b43ac5, 0x8c142359b, 0x8c13549, 0x8c194ed35, 0x8c194ed352, 0x8c194ead35, 0x1c984e57d3a2, 0x1c984e5d3a, 0x1c984e57d3a2, 0x1c984e5d3a2,  0x1c984e5d3a2, 0x8c194ed53a2, 0x81c1b34ed95, 0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b345eda9, 0x8c1b634ed95, 0x8c1b6345eda92, 0x1bc76834ed95, 0x1bc768345eda92, 0x13459a8cb2de, 0x1bc483eda952, 0x8c1b7634ed952, 0x1c9384eda5, 0x8c19634ed5, 0x8c19634ed52, 0x8c19634eda52, 0x8c19634eda5, 0x1c9384eda52, 0x1c976834eda52, 0x1c9768354eda2 ],
    'fbsn' => [0x8c1b435a9, 0x8c145b93, 0x8c194e5d3a, 0x8c194e5d3a2, 0x8c14b235a9, 0x1892b43ac5, 0x8c142359b, 0x8c13549, 0x8c194ed35, 0x8c194ed352, 0x8c194ead35, 0x1c984e57d3a2, 0x1c984e5d3a, 0x1c984e57d3a2, 0x1c984e5d3a2,  0x1c984e5d3a2, 0x8c194ed53a2, 0x81c1b34ed95, 0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b345eda9, 0x8c1b634ed95, 0x8c1b6345eda92, 0x1bc76834ed95, 0x1bc768345eda92, 0x13459a8cb2de, 0x1bc483eda952, 0x8c1b7634ed952, 0x1c9384eda5, 0x8c19634ed5, 0x8c19634ed52, 0x8c19634eda52, 0x8c19634eda5, 0x1c9384eda52, 0x1c976834eda52, 0x1c9768354eda2, 26657794385, 426524710177, 1314732689, 12927905 ],
    'fbav' => [0x8c1b435a9, 0x8c145b93, 0x8c194e5d3a, 0x8c194e5d3a2, 0x8c14b235a9, 0x1892b43ac5, 0x8c142359b, 0x8c13549, 0x8c194ed35, 0x8c194ed352, 0x8c194ead35, 0x1c984e57d3a2, 0x1c984e5d3a, 0x1c984e57d3a2, 0x1c984e5d3a2,  0x1c984e5d3a2, 0x8c194ed53a2, 0x81c1b34ed95, 0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b345eda9, 0x8c1b634ed95, 0x8c1b6345eda92, 0x1bc76834ed95, 0x1bc768345eda92, 0x13459a8cb2de, 0x1bc483eda952, 0x8c1b7634ed952, 0x1c9384eda5, 0x8c19634ed5, 0x8c19634ed52, 0x8c19634eda52, 0x8c19634eda5, 0x1c9384eda52, 0x1c976834eda52, 0x1c9768354eda2, 26657794385, 426524710177, 1314732689, 12927905 ],
    'gsa' => [0x8c1b435a9, 0x8c145b93, 0x8c194e5d3a, 0x8c194e5d3a2, 0x8c14b235a9, 0x1892b43ac5, 0x8c142359b, 0x8c13549, 0x8c194ed35, 0x8c194ed352, 0x8c194ead35, 0x1c984e57d3a2, 0x1c984e5d3a, 0x1c984e57d3a2, 0x1c984e5d3a2,  0x1c984e5d3a2, 0x8c194ed53a2],
    'chrome' => [0x81c1b34ed95, 0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b345eda9, 0x8c1b634ed95, 0x8c1b6345eda92, 0x1bc76834ed95, 0x1bc768345eda92, 0x13459a8cb2de, 0x1bc483eda952, 0x8c1b7634ed952, 0x1c9384eda5, 0x8c19634ed5, 0x8c19634ed52, 0x8c19634eda5, 0x8c19634eda52, 0x8c19634eda5, 0x1c9384eda52, 0x1c976834eda52, 0x1c9768354eda2, 0x1c384eda95, 0x8c1634ed952, 0x1c384eda95, 0x8c195634eda2,0x8c19634eda5, 0x8C19634ED5, 0xCB59ADE4361, 154048479996242, 1907910171285, 154014400033502, 0xCB59ADE4361, 13974126871393, 23140948625, 13960151450465, 223362372485985],
    'crios' => [0x8c14b235a9, 0x8c194e6d352, 0x1c984e5d3a2, 0x8c197634ed52],
    'firefox' => [0x8c13459bde,  0x1c3459a8de2, 0x8c134596de2, 0x8c13459bade, 0x13459a8cb26de, 0x8c13459b26de, 0x8c13459ba26de, 0x8c13459abde, 0x8c13459b6de, 0x1c9345a86de2, 0x1c9345a8de2, 0x8c193456de2, 0x8c19345a6de2, 0x8c19345ade2, 0x1c9345a8de, 0x1c9345a86de7, 0x8c19345a6de7, 0x8c13459b26de,  0x8c19345a6de72, 0x8c13459a6de2],
    'samsungbrowser' => [0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x1c976834eda52, 0x8c195634ed, 0x1c9384eda5, 0x8c19634eda52, 0x8c19634eda5, 0x1c9384eda52, 0x8c19634ed52, 0x1c9384a5, 0x1c976834a52, 0x1c9384a52, 0x1c97384a52, 0x8c19634ed5, 9627561578197],
    'edge' => [0x8c1b34eda952, 0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b634ed95 ],
    'explorer' => [0x8c4a5391b40, 0x8c45391b40, 0x8c4a5391b240, 0x8c45931b7240, 0x8c45391b240 ],
    'opr' => [0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b34ed952, 0x8c1b34ed95 ],
    'yowser' => [0x8c1b34eda952, 0x8c1b34eda95, 0x8c1b634eda952, 0x1bc76834eda952, 0x8c1b34a95, 0x8c1b34952, 0x8c1b634a952, 0x1bc76384a952, 0x8c1b34a952 ],
    'yabrowser' => [0x8c1b43a95, 0x8c1b43952, 0x8c1b34a95, 0x8c1b463a952, 0x1bc74638a952 ],
    'googlebot' => [0x8c1b439, 0x8c1943, 0x1c958a43, 0x1c958a743, 0x8c193, ],
    'httpwwwgooglecombothtml' => [0x8c1b439, 0x8c1943, 0x1c958a43, 0x1c958a743, 0x8c193, ],
    'yandexbot' => [0x8c1493b, 0x8c1934b],
    'miuibrowser' => [0x8c19634eda5, 0x1c976834eda52, 0x1c9384eda52, 0x8c19634ed5, 0x8c19634ed52, 0x1c9384eda5],
    'bingbot' => [ 0x8c19743 ],
    'vivobrowser' => [0x1B9634EDA52, 0x8C19634EDA5, 0x8C19634ED5, 0x1B9634EDA52, 0x8C196345 ],
    'huaweibrowser' => [0x8c19634eda5, 0x1c976384eda52, 9627561578197],
    'ucturbo' => [0x8c19634a52, 0x1c976384a52],

    'facebook' => [0x8C19634EDA52, 0x8C19634EDA5, 0xC159ADE436],
];


const SIGNATURE_MAP = [
    'safari' => ['&pABCDrP', 'ABHFJKPQ'],
    'chrome' => ['ABQSFHJKMNOPR','ABCD&pP']
];



const FINGERPRINT_IDENT = [
    0x8c1349 => 'zgrab',
    0x8c134 => 'curl',
    0x8c1b3 => 'nmap',
    0x8c139b => 'go-http-client',
    0x8c1394b => 'python-requests',
    0x8c913b => 'python-urllib',
    0x8c1394b2 => 'python-urllib',
    0x149b3c8 => 'python-httpx',
    0x19b348c => 'python-httpx',
    0x1b98c32 => 'wp-login-cracker'
];
/*
    0x134598cba6  => 'boaform', // login cracker
    0x8c13b459 => 'malware_d12j', // log4j exploiter
    0x149b3c8 => 'python-httpx',
    0x19b348c => 'python-httpx',
    0x8c1b439 => 'googlebot',
    0xc138a9 => 'malware_a56a', // think PHP
    0x8c314b => 'malware_c42a', // mirai
    0x43a2c891 => 'malware_a56b',
    0x8c139b => 'malware_b42a',
    0x134598cba6 => 'malware_b32a', // boaform/admin/login
    0x8c1394b => 'python-requests',
    0x8c913b => 'python-urllib'
];
*/


const BOT_WORDS = [
    'google', 'bingweb', 'wordpress', 'bot', 'spider', 'crawler', 'broadsign', 'favicon', 'phantomjs', 'winhttprequest', 'python'
];


const OS_MAP = [
    "windows" => 1,
    "wow" => 1,
    "mac" => 2,
    "os x" => 2,
    "iphone" => 3,
    "ios" => 3,
    "cfnetwork" => 3,
    "android" => 4,
    "linux" => 5,
    "linux i" => 5,
    "chrome os" => 6,
    "cros" => 6,
    "watch os" => 7,
    "watchos" => 7
];


// keywords that identify browsers
const BROWSER_WORDS = [
    'msie', 'opera', 'browser', 'media center', 'funwebproducts', 'mathplayer', 'cfnetwork'
];

// mapping of common words to unique browsers
const BROWSER_MAP = [
    1536 => "chrome",
    3072 => "safari",
    8192 => 'firefox',
    3584 => 'chrome',
    12288 => "firefox",
    16384 => "explorer",
    33792 => "safari",
    35840 => "safari",
    69120 => "edge"
];

// common applications with embedded browsers
const APPS = [
    "infopath",
    "wbxapp",
    "ms-office",
    "msoffice",
    "microsoft office",
    "broadsign",
    "wirtschaftswoche-ios-",
    "powerpoint"
];

// common words that don't help us identify the browser because they are so common
const COMMON_WORDS = [
    'android' => 1,
    'opera' => 1,
    'ubuntu' => 1,
    'presto' => 1,
    'x' => 1,
    'x64' => 1,
    'msie' => 1,
    'mozilla' => 1,
    'trident' => 1,
    'gecko' => 1,
    'safari' => 1,
    'chrome' => 1,
    'compatible' => 1,
    'build' => 1,
    'version' => 1,
    'mobile' => 1,
    'linux' => 1,
    'like' => 1,
    'khtml' => 1,
    'mobi' => 1,
    'intel' => 1,
    'wow' => 1,
    'wow64' => 1,
    'self' => 1,
    'rv' => 1,
    'bri' => 1,
    'fedora' => 1,
    'like gecko' => 1,
    'linux x' => 1,
    'linux x_' => 1,
    'linux i' => 1,
    'build' => 1,
    'windows' => 1,
    'windows nt' => 1,
    'win' => 1,
    'bot' => 1,
    'america' => 1,
    'europe' => 1,
    'asia' => 1,
    'channel' => 1,
    'nettype' => 1,
    'jssdk' => 1,
    'gsa' => 1,
    'avast' => 1,
    'avg' => 1,
    'ddg' => 1,
    'lucid' => 1,  // sometimes ubuntu adds release names we want to ignore
    'karmic' => 1,
    'jaunty' => 1,
    'intrepid' => 1,
    'hardy' => 1,
    'gutsy' => 1,
    'feisty' => 1,
    'config' => 1,
    'viewer' => 1,
    'trailer' => 1,
    'xtpt' => 1
];






// list of unique browser names
const BROWSER_LIST = [
    'asktblmw2' => 1,
    '234explorer' => 2,
    'amigo' => 3,
    'apusbrowser' => 4,
    'avirascout' => 5,
    'centbrowser' => 6,
    'cmbrowser' => 7,
    'acheetahi' => 8,
    'lbbrowser' => 9,
    'diglo' => 10,
    'liebaofast' => 11,
    'mzbrowser' => 12,
    'oculusbrowser' => 13,
    'mms' => 14,
    'overwolfclient' => 15,
    'qq' => 16,
    'sleipnir' => 17,
    'sparrow' => 18,
    'superbird' => 19,
    'tesla' => 20,
    'vivobrowser' => 21,
    'ucbrowser' => 22,
    'aviator' => 23,
    '1stbrowser' => 24,
    'bdbrowser' => 25,
    'chedot' => 26,
    'coc_coc_browser' => 27,
    'comodo_dragon' => 28,
    'heytapbrowser' => 29,
    'lovense' => 30,
    '37abc' => 31,
    'browser' => 32,
    'explorer' => 33,
    'oneplusbrowser' => 34,
    'nichrome' => 35,
    'polarity' => 36,
    'crossapp' => 37,
    'camino' => 38,
    'samsungbrowser' => 39,
    'sputnikbrowser' => 40,
    'surfbrowser' => 41,
    'slimjet' => 42,
    'slimboat' => 43,
    'mb2345browser' => 44,
    'coolnovo' => 45,
    'duckduckgo' => 46,
    'focus' => 47,
    'huaweibrowser' => 48,
    'maxthon' => 49,
    'oppobrowser' => 50,
    'miuibrowser' => 51,
    'nueron' => 52,
    'qt' => 53,
    'sznprohlizec' => 54,
    'sraf' => 55,
    'swing' => 56,
    'puffin' => 57,
    'yabrowser' => 58,
    'asw' => 59,
    'aolshield' => 60,
    'alohabrowser' => 61,
    'beamrise' => 62,
    'crios' => 63,
    'openwave' => 64,
    'degdegan' => 65,
    'iridium' => 66,
    'kinza' => 67,
    'mobileiron' => 68,
    'ntentbrowser' => 69,
    'tungstenbrowser' => 70,
    'vivaldi' => 71,
    'whale' => 72,
    'gameoverlay' => 73,
    'com.laiwang.dingtalk' => 74,
    'citrixchromeapp' => 75,
    'fbav' => 76,
    'snapchat' => 77,
    'line' => 78,
    'alitrip' => 80,
    'crosswalk' => 81,
    'flipboard' => 82,
    'sohunews' => 83,
    'tieba' => 84,
    'futureve' => 85,
    'baiduboxapp' => 86,
    'baidubrowser' => 87,
    'flyflow' => 88,
    'baiduhd' => 89,
    'electron' => 90,
    'avastsecurebrowser'=> 91,
    'pinterest' => 92,
    'twitter' => 93,
    'twitterandroid' => 94,
    'bingweb' => 95,
    'instagram' => 96,
    'secondlife' => 97,
    'tenfoot' => 98,
    'wechat' => 99,
    'micromessenger' => 100,
    'player' => 101,
    'podcastaddict' => 102,
    'basilisk' => 103,
    'palemoon' => 104,
    'konqueror' => 105,
    'sonycebrowser' => 106,
    'opr' => 107,
    'opt' => 108,
    'opios' => 109,
    'opera' => 110,
    'presto' => 111,
    'nintendobrowser' => 112,
    'qqbrowser' => 113,
    '360se' => 114,
    '360ee' => 115,
    'qihu' => 116,
    'mercury' => 117,
    'epiphany' => 118,
    'fluid' => 119,
    'ibrowser' => 120,
    'omniweb' => 121,
    'phantom' => 122,
    'rekonq' => 123,
    'hbbtv' => 124,
    'slik' => 125,
    'thano' => 126,
    'sunrisebrowser' => 127,
    'android' => 128,
    'chromeplus' => 129,
    'icab' => 130,
    'kindle' => 131,
    'midori' => 132,
    'quicklook' => 133,
    'rockmelt' => 134,
    'arora' => 135,
    'fxios' => 136,
    'lunascape' => 137,
    'ilunascape' => 138,
    'xiaomi' => 139,
    'origin' => 140,
    'playstation' => 141,
    'qupzilla' => 142,
    'sogoumobilebrowser' => 143,
    'atomicbrowser' => 144,
    'battlenet' => 145,
    'netfront' => 146,
    'otter' => 147,
    'tizenbrowser' => 148,
    'webos' => 149,
    'kmail2' => 150,
    'vienna' => 151,
    'quiterss' => 152,
    '115browser' => 153,
    'deezer' => 154,
    'whatsapp' => 155,
    'blackberry8520' => 156,
    'mobilesafari' => 157,
    'applecoremedia' => 158,
    'edgios' => 159,
    "podcasts" => 160,
    "patient" => 161,
    "Подкасты" => 162,
    "exoplayerlib" => 163,
    "macoutlook" => 164,
    "itunes" => 165,
    "spotify" => 166,
    "roku" => 167,
    "outlook-ios" => 168,
    "edge" => 169,
    "darwin" => 170,
    "outlook-express" => 171,
    "dalvik" => 172,
    'thunderbird' => 173,
    'officelivepatch' => 174,
    'granparadiso' => 175,
    'media center pc' => 176,
    'iemb' => 177,
    'minefield' => 178,
    'google desktop' => 179,
    'edga' => 180,
    'edg' => 181,
    'headlesschrome' => 182,
    'sf' => 183,
    'nitro-optimizer-agent' => 184,
    'fbsn' => 185,
    'soul' => 186,
    'gsa' => 187,
    'ztunnel' => 188,
    'nettype' => 189,
    'bit.ly' => 190,
    'iphone' => 191,
    'browserng' => 192,
    'openbsd' => 193,
    'ios_text_message' => 194,
    'os x' => 195,
    '[pinterest' => 196,
    'phx' => 197,
    'linkedinapp' => 198,
    '[linkedinapp]' => 199,
    'chromium' => 200,
    'norton' => 201,
    'ccleaner' => 202,
    'blade' => 203,
    'bytedancewebview' => 204,
    'pinterest' => 205,
    'atcontent' => 206,
    'quark' => 207,
    'rrdocuments' => 208,

    "chrome" => 512,
    "applewebkit" => 1024,
    "safari" => 2048,
    "firefox" => 4096,
    "gecko" => 8192,
    "trident" => 16384,
    "mobile" => 32768,
    "edge" => 65536
];
// final list of common words that specific combinations map to unique browsers


// libraries and bots
const LIB_LIST = [
    "python-urllib" => 1,
    "python-requests" => 2, 
    "python-httpx" => 3, 
    "weatherreport" => 4,
    "wordpress.com" => 5,
    "curl" => 8,
    "pycurl" => 9,
    "guzzlehttp" => 10,
    "okhttp" => 11,
    "wget" => 12,
    "alamofire" => 13,
    "gsa" => 14,
    "java" => 15,
    "libwww-perl" => 16,
    "microsoft-webdav-miniredir" => 17,
    "microsoft-cryptoapi" => 18,
    "zgrab" => 19,
    "lua-resty-http" => 20,
    "restsharp" => 21,
    "facebookexternalhit" => 22,
    "phpcrawl" => 23,
    "gomezagent" => 24,
    'exabot-thumbnails' => 25,
    'exabot' => 26,
    'ceeviewhttpclient' => 27,
    'postmanruntime' => 28,
    'exaleadcloudview' => 30,
    'dejaclick' => 31,
    'ahc' => 32,
    'pocketparser' => 33,
    'linkcheck' => 34,
    'cloudflair-alwaysonline' => 35,
    'openstat.ru' => 36,
    'amazonbot' => 37,
    'getthit.com' => 38,
    'feedbot' => 39,
    'qtwebengine' => 40,
    'adbeat.com' => 41,
    'whatcms' => 42,
    'yelpspider' => 43,
    'watchmouse' => 44,
    '2gisbot' => 45,
    'sortsitecmd' => 46,
    'mappercmd' => 47,
    'dmbrowser' => 48,
    'bingpreview' => 49,
    'yisouspider' => 50,
    'bit.ly' => 51,
    'commoncrawl.org' => 52,
    'morningscore.org' => 53,
    'websnapr' => 54,
    'brokenlinkcheck.com' => 55,
    'phantomjscloud.com' => 56,
    'fullstorybot' => 57,
    'webthumb' => 58,
    'pingdomtms' => 59,
    '+feeder.co' => 60,
    'screenshotservice' => 61,
    'seositecheckup' => 62,
    'archivebot' => 63,
    'warc' => 63,
    'archivebot' => 63,
    'adsbot' => 64,
    'cloudinary' => 65,
    'crowdtanglebot' => 66,
    'dun&bradstreetbot' => 67,
    'evc-batch' => 68,
    'gigablastopensource' => 69,
    'goodzer' => 70,
    'kaz.kz_bot' => 71,
    'mail.ru' => 72,
    'komodiabot' => 73,
    'daum' => 74,
    'daumoa-image' => 75,
    'daumoa' => 76,
    'najdi.si' => 77,
    'netcraftsurveyagent' => 78,
    'paesslercloudbot' => 79,
    'pro-sitemaps' => 80,
    'seplinkbot' => 81,
    'statonlinerubot' => 82,
    '+epicardtest' => 83,
    'vsagent' => 84,
    'xml-sitemaps' => 85,
    'compatible;contxbot' => 86,
    'laserlikebot' => 88,
    'klarnabot-pricewatcher' => 89,
    'applebot' => 90,
    'web-capture.net' => 92,
    'builtwith' => 93,
    'surveybot' => 94,
    'miniature.io' => 96,
    'custom-crawler' => 97,
    'sqwatcher' => 98,
    'heartrails_capture' => 99,
    'cloudwatchsynthetics' => 100,
    'mail.ru_bot' => 101,
    'google-site-verification' => 102,
    'morningscore' => 103,
    'chrome-prerendercloud' => 104,
    'google-hoteladsverifier' => 105,
    'storebot-google' => 106,
    'slackbot' => 107,
    'rss' => 108,
    'cds' => 109,
    'msiecrawler' => 110,
    'censysinspect' => 111,
    'googlebot' => 112,
    'google' => 113,
    'go-http-client' => 114,
    'bw' => 115,
    "python-urllib3" => 116,
    'yandexbot' => 117,
    'yandexsearch' => 118,
    'bingbot' => 119,
    'gptbot' => 120,
    'chatgpt-user' => 121,
    'microsoftpreview' => 122,
    'wordpress' => 123,
    'x-middleton' => 124,
    'anglesharp' => 125
];

const EVIL_LIST = [
'hydra' => 1,
'nasl' => 1,
'extractor' => 1,
'brutus' => 1,
'commix' => 1,
'masscan' => 1,
'dotdotpwn' => 1,
'evil' => 1,
'dirbuster' => 1,
'gobuster' => 1,
'havij' => 1,
'zmeu' => 1,
'mysql' => 1,
'nessus' => 1,
'nikto' => 1,
'nmap' => 1,
'wpscan' => 1,
'openvas' => 1,
'paros' => 1,
'sqlmap' => 1,
'vega' => 1,
'w3af' => 1,
'webshag' => 1,
'pwn' => 1,
'backweb' => 1,
'bender' => 1,
'widow' => 1,
'whisker' => 1,
'webstripper' => 1,
'sitesucker' => 1,
'phantomjs' => 1,
'slimerjs' => 1,
'k2spider' => 1,
'leakix' => 1,
'zgrab' => 1,
'hello world' => 1,
'nvdorz' => 1,
'gnu ( cow )' => 1,
'gnu (cow)' => 1,
'pdrlabs.net' => 1,
'mozila' => 1,
'whatweb' => 1,
' sf/' => 1,
'sfish' => 1,
'gaaaaa' => 1,
];

