<?php
namespace GPLSCore\GPLS_PLUGIN_ARCW;

defined( 'ABSPATH' ) || exit();

/**
 * Core Class
 */
class Core {

	/**
	 * Plugin Info
	 *
	 * @var array
	 */
	protected $plugin_info;

	/**
	 * Core Path
	 *
	 * @var string
	 */
	public $core_path;

	/**
	 * Core URL
	 *
	 * @var string
	 */
	public $core_url;

	/**
	 * Core Assets PATH
	 *
	 * @var string
	 */
	public $core_assets_path;

	/**
	 * Core Assets URL
	 *
	 * @var string
	 */
	public $core_assets_url;

	/**
	 * Core Version.
	 *
	 * @var string
	 */
	private $version = '2.0';

	/**
	 * Plugins List.
	 *
	 * @var array
	 */
	private $plugins_list = array();

	/**
	 * Constructor.
	 *
	 * @param array $plugin_info
	 */
	public function __construct( $plugin_info ) {
		$this->init( $plugin_info );
		$this->hooks();
	}

	/**
	 * Init constants and other variables.
	 *
	 * = Set the Plugin Update URL
	 *
	 * @return void
	 */
	public function init( $plugin_info ) {
		$this->plugin_info      = $plugin_info;
		$this->core_path        = plugin_dir_path( __FILE__ );
		$this->core_url         = plugin_dir_url( __FILE__ );
		$this->core_assets_path = $this->core_path . 'assets';
		$this->core_assets_url  = $this->core_url . 'assets';
		$this->plugins_list     = array(
			'woo-name-you-price'              => array(
				'title'     => 'Woo Name Your Price',
				'desc'      => 'Empower your website with Woo Name Your Price. Let shoppers set their own prices for your WooCommerce products, boosting engagement and sales flexibility.',
				'thumbnail' => 'woo-name-your-price.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-name-your-price/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-customers-cleanup'           => array(
				'title'     => 'Woo Customers Cleanup',
				'desc'      => 'Automatically remove WooCommerce customer accounts with no orders to keep your database clean and efficient.',
				'thumbnail' => 'woo-customers-cleanup.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-customers-cleanup/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-limited-offers'              => array(
				'title'     => 'Woo Limited Offers',
				'desc'      => 'Limit WooCommerce sale prices by specific quantities,! Limited Offers for WooCommerce lets you set sales like Amazon with claimed percentage tracking.',
				'thumbnail' => 'woo-limited-offer.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-limited-offers/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-order-uploader'              => array(
				'title'     => 'Woo Order Uploader',
				'desc'      => 'Enhance customer experience with Order Uploader for WooCommerce. Upload, manage, and share files seamlessly between customers and store admins.',
				'thumbnail' => 'woo-order-uploader.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-order-uploader/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-lemonsqueezy-checkout'       => array(
				'title'     => 'Woo Lemonsqueezy Checkout',
				'desc'      => 'Integrate Lemonsqueezy payment gateway with WooCommerce. Accept payments, manage subscriptions, and streamline your digital product sales effortlessly.',
				'thumbnail' => 'woo-lemonsqueezy-checkout.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-lemonsqueezy-gateway/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-paypal-checkout'             => array(
				'title'     => 'Woo Paypal Checkout',
				'desc'      => 'integrates PayPal payment options seamlessly into your WooCommerce store. It allows customers to complete purchases directly from checkout, single product page, and shop pages with ease.',
				'thumbnail' => 'woo-paypal-checkout.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-paypal-checkout/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-gift-cards'                  => array(
				'title'     => 'Woo Gift Cards',
				'desc'      => 'Sell gift cards easily on your WooCommerce sites. Create simple, variable gift cards, generate gift cards manually and automatically and send customized gift cards emails to customers.',
				'thumbnail' => 'woo-gift-cards.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-gift-cards/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-bulk-price-stock'            => array(
				'title'     => 'Woo Bulk Price & Stock Manager',
				'desc'      => 'Update price and stock for your WooCommerce store in bulk easily',
				'thumbnail' => 'woo-bulk-price-&-stock.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-bulk-price-change/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-paddle-checkout'             => array(
				'title'     => 'Woo Paddle Checkout',
				'desc'      => 'Integrates Paddle\'s secure payment gateway into your WooCommerce website allowing customers to make secure and hassle-free payments and subscriptions through Paddle for their orders.....',
				'thumbnail' => 'woo-paddle-checkout.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-paddle-checkout/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-restrict-orders'             => array(
				'title'     => 'Woo Restrict Orders',
				'desc'      => 'Secure your WooCommerce store from spam users making spam orders',
				'thumbnail' => 'woo-restrict-orders.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-restrict-orders/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-sales-notifications'         => array(
				'title'     => 'Woo Sales notifications',
				'desc'      => 'boost your e-commerce store\'s sales and build customer trust. displaying real-time, eye-catching sales notifications on your website, notifying potential customers of recent product purchases..',
				'thumbnail' => 'woo-sales-notification.png',
				'pro_link'  => 'https://grandplugins.com/product/woo-sales-notification/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-advanced-add-to-cart' => array(
				'title'     => 'Woo Advanced Add To Cart',
				'desc'      => 'Add To cart in bulk, custom prices and more...',
				'thumbnail' => 'woo-advanced-add-to-cart.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-advanced-add-to-cart/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-advanced-pricing' => array(
				'title'     => 'Woo Advanced Pricing',
				'desc'      => 'Apply all types of Quantity based pricing models',
				'thumbnail' => 'woo-advanced-pricing.webp',
				'pro_link'  => 'https://grandplugins.com/product/woo-advanced-pricing/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-best-seller' => array(
				'title'     => 'Woo Best Sellers',
				'desc'      => '',
				'thumbnail' => 'woo-best-sellers.webp',
				'free_link' => 'https://wordpress.org/plugins/best-seller-for-woocommerce/',
				'pro_link'  => 'https://grandplugins.com/product/woo-best-seller/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'image-sizes-controller' => array(
				'title'     => 'Image Sizes Controller',
				'desc'      => 'Control your website image sizes, create custom image sizes and disable generating unneeded sizes.',
				'thumbnail' => 'image-sizes-controller.png',
				'free_link' => 'https://wordpress.org/plugins/image-sizes-controller/',
				'pro_link'  => 'https://grandplugins.com/product/image-sizes-controller/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'simple-countdown-timer' => array(
				'title'     => 'Simple Countdown Timer',
				'desc'      => 'Add countdown timers easily to your WordPress website',
				'thumbnail' => 'simple-countdown-timer.gif',
				'free_link' => 'https://wordpress.org/plugins/simple-countdown/',
				'pro_link'  => 'https://grandplugins.com/product/simple-countdown-timer/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'wp-watermark-pdf' => array(
				'title'     => 'WP Watermark PDF',
				'desc'      => 'Add text and image watermarks to your PDF files easily with our watermark PDFs plugin.',
				'thumbnail' => 'wp-watermark-pdf.png',
				'free_link' => 'https://wordpress.org/plugins/watermark-pdf/',
				'pro_link'  => 'https://grandplugins.com/product/wp-watermark-pdf/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-cart-limiter' => array(
				'title'     => 'WooCommerce Cart Limiter',
				'desc'      => 'Control your website cart, limit cart totals, products count and quantity, limit products based on other products in cart, set minimum and maxmium quantity limits and more...',
				'thumbnail' => 'woo-cart-limiter.jpg',
				'free_link' => 'https://wordpress.org/plugins/cart-limiter/',
				'pro_link'  => 'https://grandplugins.com/product/woo-cart-limiter/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-coming-soon' => array(
				'title'     => 'WooCommerce Coming Soon Products',
				'desc'      => 'Set your products to coming soon mode with countdown timer.',
				'thumbnail' => 'woo-coming-soon.png',
				'free_link' => 'https://wordpress.org/plugins/coming-soon-products-for-woocommerce/',
				'pro_link'  => 'https://grandplugins.com/product/woo-coming-soon-products/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'wp-watermark-images' => array(
				'title'     => 'WP Watermark Images',
				'desc'      => 'protect your images by watermarking them with text and image watermarks using the most advanced watermarking plugin',
				'thumbnail' => 'wp-watermark-images.png',
				'free_link' => 'https://wordpress.org/plugins/watermark-images-for-wp-and-woo-grandpluginswp/',
				'pro_link'  => 'https://grandplugins.com/product/wp-images-watermark/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-quick-view' => array(
				'title'     => 'WooCommerce Quick View and Buy Now',
				'desc'      => 'Increase your website conversion rate, encourage your visitors to buy from your website using quick view and buy now buttons with direct checkout.',
				'thumbnail' => 'woo-quick-view-and-buy-now.png',
				'free_link' => 'https://wordpress.org/plugins/quick-view-and-buy-now-for-woocommerce/',
				'pro_link'  => 'https://grandplugins.com/product/quick-view-and-buy-now-for-woocommerce/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'wp-gif-editor'   => array(
				'title'     => 'WP GIF Uploader',
				'desc'      => 'Upload GIF images without losing the GIF animation in the uploaded gif and all generated subsizes.',
				'thumbnail' => 'wp-gif-editor.gif',
				'free_link' => 'https://wordpress.org/plugins/gif-uploader-wp-grandplugins',
				'pro_link'  => 'https://grandplugins.com/product/wp-gif-editor/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'woo-maintenance-mode' => array(
				'title'     => 'Woo Maintenance Mode',
				'desc'      => '',
				'thumbnail' => 'woo-maintenance-mode.png',
				'free_link' => 'https://wordpress.org/plugins/ultimate-maintenance-mode-for-woocommerce/',
				'pro_link'  => 'https://grandplugins.com/product/woocommerce-maintenance-mode-pro/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'pdf-password-protected' => array(
				'title'     => 'PDF Password Protect',
				'desc'      => '',
				'thumbnail' => 'pdf-password-protect.gif',
				'free_link' => 'https://wordpress.org/plugins/pdf-password-protect/',
				'pro_link'  => 'https://grandplugins.com/product/pdf-password-protect/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
			'wp-paypal_subscriptions' => array(
				'title'     => 'WP Paypal Subscriptions',
				'desc'      => '',
				'thumbnail' => 'wp-paypal-subscriptions.png',
				'free_link' => 'https://wordpress.org/plugins/gpls-paypal-subscriptions/',
				'pro_link'  => 'https://grandplugins.com/product/wp-paypal-subscriptions/?utm_source=free&utm_medium=sidebar&utm_content=' . $this->plugin_info['name'],
			),
		);
	}

	/**
	 * Core Hooks.
	 *
	 * @return void
	 */
	public function hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 1000, 1 );
	}

	/**
	 * Core Admin Scripts.
	 *
	 * @param string $hook_prefix
	 *
	 * @return void
	 */
	public function admin_scripts( $hook_suffix ) {
		global $pagenow;

		if ( ! wp_style_is( 'gpls-core-plugins-general-admin-head-styles-' . $this->version ) ) {
			wp_enqueue_style( 'gpls-core-plugins-general-admin-head-styles-' . $this->version, $this->core_assets_file( 'admin-head', 'css', 'css' ), array(), 'all' );
		}
	}

	/**
	 * Get Core assets file
	 *
	 * @param string $asset_file    Assets File Name
	 * @param string $type          Assets File Folder Type [ js / css /images / etc.. ]
	 * @param string $suffix        Assets File Type [ js / css / png /jpg / etc ... ]
	 * @param string $prefix        [ .min ]
	 * @return string
	 */
	public function core_assets_file( $asset_file, $type, $suffix, $prefix = 'min' ) {
		return $this->core_assets_url . '/dist/' . $type . '/' . $asset_file . ( ! empty( $prefix ) ? ( '.' . $prefix ) : '' ) . '.' . $suffix;
	}

	/**
	 * Get Core assets lib file
	 *
	 * @param string $asset_file    Assets File Name
	 * @param string $suffix        Assets File Type [ js / css / png /jpg / etc ... ]
	 * @param string $prefix        [ .min ]
	 * @return string
	 */
	public function core_assets_lib( $asset_file, $suffix, $prefix = 'min' ) {
		return $this->core_assets_url . '/libs/' . $asset_file . ( ! empty( $prefix ) ? ( '.' . $prefix ) : '' ) . '.' . $suffix;
	}

	/**
	 * Plugin Activation Hub function
	 *
	 * @return void
	 */
	public function plugin_activated() {

		do_action( $this->plugin_info['name'] . '-core-activated', $this );
	}

	/**
	 * Plugin Deactivation Hub function
	 *
	 * @return void
	 */
	public function plugin_deactivated() {

		do_action( $this->plugin_info['name'] . '-core-deactivated', $this );
	}

	/**
	 * Uninstall the plugin hook.
	 *
	 * @return void
	 */
	public function plugin_uninstalled() {

		do_action( $this->plugin_info['name'] . '-core-uninstalled', $this );
	}

	/**
	 * Pro Button.
	 *
	 * @param string $pro_link
	 * @param string $btn_title
	 * @param string $additional_classes
	 * @param string $additional_css
	 * @return void
	 */
	public function pro_btn( $pro_link = '', $btn_title = 'Pro', $additional_classes = '', $additional_css = '', $return = false ) {

		if ( empty( $pro_link ) && empty( $this->plugin_info['pro_link'] ) ) {
			return;
		}
		$pro_link = empty( $pro_link ) ? $this->plugin_info['pro_link'] : $pro_link;

		if ( $return ) {
			ob_start();
		}
		?>
		<a target="_blank" class="ms-2 btn gpls-permium-btn-wave btn-primary <?php echo esc_attr( $additional_classes ); ?>" href="<?php echo esc_url_raw( $pro_link ); ?>" style="<?php echo esc_attr( $additional_css ); ?>">
			<span class="pro-title" style="position:relative;z-index:10;color:#FFF;text-decoration:underline;"><?php printf( esc_html__( '%s' ), $btn_title ); ?></span>
			<span class="wave"></span>
		</a>
		<?php
		if ( $return ) {
			return ob_get_clean();
		}
	}

	/**
	 * Default Footer Section
	 *
	 * @return void
	 */
	public function default_footer_section() {
		?>
		<style>
		#wpfooter {display: block !important;}
		.wrap.woocommerce {position: relative;}
		.gpls-contact {position: relative; max-width: 350px; z-index: 1000;}
		.gpls-contact .link { color: #acde86!important; }
		.gpls-contact .text { background-color: #176875!important; }
		</style>
		<div class="gpls-contact float-end">
		  <p class="p-3 bg-light text-center text text-white"><?php esc_html_e( 'in case you want to report a bug, submit a new feature or request a custom plugin, Please' ); ?> <a class="link" target="_blank" href="https://grandplugins.com/contact-us"> <?php esc_html_e( 'contact us' ); ?></a></p>
		</div>
		<?php
	}

	/**
	 * Review Link.
	 *
	 * @param string $review_link
	 * @return void
	 */
	public function review_notice( $review_link, $is_dismissible = true ) {
		?>
		<p style="max-width:650px;" class="notice notice-success p-4 my-0 <?php echo esc_attr( $is_dismissible ? 'is-dismissible' : '' ); ?>">
			<?php esc_html_e( 'We would love your feedback. leaving ' ); ?>
			<a class="text-decoration-none" href="<?php echo esc_url_raw( $review_link ); ?>" target="_blank">
				<u><?php esc_html_e( 'a review is much appreciated' ); ?></u>
				<span class="dashicons dashicons-star-filled"></span>
				<span class="dashicons dashicons-star-filled"></span>
				<span class="dashicons dashicons-star-filled"></span>
				<span class="dashicons dashicons-star-filled"></span>
				<span class="dashicons dashicons-star-filled"></span>
			</a>
			<?php esc_html_e( ':) Thanks!' ); ?>
		</p>
			<?php
	}

		/**
		 * New Keyword.
		 *
		 * @param string  $title
		 * @param boolean $return
		 *
		 * @return string|void
		 */
	public function new_keyword( $title = 'New', $return = true ) {
		if ( $return ) {
			ob_start();
		}
		?>
		<span style="display: inline;position: relative;text-decoration: none; padding: 4px 12px;color: white;font-weight: 500;background: linear-gradient(to bottom,#5fbf78,#58e34f);border-radius: 999px;box-shadow: 0 2px 4px rgb(0 0 0 / 20%); user-select: none;margin-left: 5px;" class="<?php echo esc_attr( $this->plugin_info['classes_general'] . '-new-keyword' ); ?> ms-1"><?php printf( esc_html__( '%s' ), $title ); ?></span>
			<?php
			if ( $return ) {
				return ob_get_clean();
			}
	}

	/**
	 * Plugins Sidebar.
	 *
	 * @return void
	 */
	public function plugins_sidebar( $exclude = '' ) {
		?>
		<div class="gpls-core-recommended-section mt-5">
			<h6 class="shadow-sm border p-3 shadow-sm border rounded"><?php esc_html_e( 'Check our other plugins' ); ?></h6>
			<div class="section-body bg-light p-3 shadow-sm border rounded">
				<ul class="plugins-list list-group">
					<?php
					foreach ( $this->plugins_list as $plugin_key => $plugin_arr ) :
						if ( $plugin_key === $exclude ) {
							continue;
						}
						?>
					<li class="plugin-list-item list-group-item border rounded">
						<h6 class="border rounded p-1 mb-2 text-center py-3"><?php echo esc_html( $plugin_arr['title'] ); ?></h6>
						<?php if ( ! empty( $plugin_arr['thumbnail'] ) ) : ?>
							<img width="200px" src="<?php echo esc_url_raw( $this->plugin_info['url'] . 'core/assets/images/' . $plugin_arr['thumbnail'] ); ?>" class="thumbnail img-thumbanil my-3 mx-auto">
						<?php endif; ?>
						<p><?php echo esc_html( $plugin_arr['desc'] ); ?></p>
						<div class="row border p-1 rounded gx-0">
							<?php if ( ! empty( $plugin_arr['pro_link'] ) ) : ?>
							<div class="col d-flex justify-content-center border-end">
								<a class="btn btn-primary text-decoration-underline" target="_blank" href="<?php echo esc_url_raw( $plugin_arr['pro_link'] ); ?>"><strong><?php esc_html_e( 'Pro' ); ?></strong></a>
							</div>
							<?php endif; ?>
							<?php if ( ! empty( $plugin_arr['free_link'] ) ) : ?>
							<div class="col d-flex justify-content-center">
								<a class="btn btn-success text-decoration-underline" target="_blank" href="<?php echo esc_url_raw( $plugin_arr['free_link'] ); ?>"><?php esc_html_e( 'Free' ); ?></a>
							</div>
							<?php endif; ?>
						</div>
					</li>
					<?php endforeach; ?>
				</ul>
				<a class="btn btn-primary d-block mt-3" target="_blank" href="https://grandplugins.com/product-category/plugin/?utm_source=free&utm_medium=sidebar"><?php esc_html_e( 'Browse All Plugins' ); ?></a>
			</div>
		</div>
		<style>
			.gpls-core-recommended-section .plugins-list {
				display: flex;flex-direction: row;padding-left: 0;margin-bottom: 0;border-radius: 0.25rem;flex-wrap: wrap;
			}
			.gpls-core-recommended-section .plugin-list-item {
				width: 375px;display: flex;flex-direction: column;justify-content: space-between;margin: 10px;
			}
		</style>
		<?php
	}
}
