<?php
/**
 * Razzi Addons Modules functions and definitions.
 *
 * @package Razzi
 */

namespace Razzi\Addons;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Addons Modules
 */
class Modules {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
		$this->includes();
		add_action('init', array( $this, 'init' ));

		if ( class_exists( 'WooCommerce' ) ) {
			\Razzi\Addons\Modules\Products_Filter\Module::instance();
		}
	}

	/**
	 * Includes files
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function includes() {
		\Razzi\Addons\Auto_Loader::register( [
			'Razzi\Addons\Modules\Size_Guide\Module'    			=> RAZZI_ADDONS_DIR . 'modules/size-guide/module.php',
			'Razzi\Addons\Modules\Catalog_Mode\Module'    			=> RAZZI_ADDONS_DIR . 'modules/catalog-mode/module.php',
			'Razzi\Addons\Modules\Product_Deals\Module'    			=> RAZZI_ADDONS_DIR . 'modules/product-deals/module.php',
			'Razzi\Addons\Modules\Buy_Now\Module'    				=> RAZZI_ADDONS_DIR . 'modules/buy-now/module.php',
			'Razzi\Addons\Modules\Mega_Menu\Module'    				=> RAZZI_ADDONS_DIR . 'modules/mega-menu/module.php',
			'Razzi\Addons\Modules\Products_Filter\Module'     		=> RAZZI_ADDONS_DIR . 'modules/products-filter/module.php',
			'Razzi\Addons\Modules\Related_Products\Module'    		=> RAZZI_ADDONS_DIR . 'modules/related-products/module.php',
			'Razzi\Addons\Modules\Product_Tabs\Module'    			=> RAZZI_ADDONS_DIR . 'modules/product-tabs/module.php',
			'Razzi\Addons\Modules\Variation_Images\Module'    		=> RAZZI_ADDONS_DIR . 'modules/variation-images/module.php',
			'Razzi\Addons\Modules\Product_Bought_Together\Module'   => RAZZI_ADDONS_DIR . 'modules/product-bought-together/module.php',
			'Razzi\Addons\Modules\Free_Shipping_Bar\Module'    		=> RAZZI_ADDONS_DIR . 'modules/free-shipping-bar/module.php',
			'Razzi\Addons\Modules\Live_Sales_Notification\Module'   => RAZZI_ADDONS_DIR . 'modules/live-sales-notification/module.php',
			'Razzi\Addons\Modules\Advanced_Search\Catalog'   => RAZZI_ADDONS_DIR . 'modules/advanced-search/catalog.php',
			'Razzi\Addons\Modules\Ajax'    							=> RAZZI_ADDONS_DIR . 'modules/ajax.php',
			'Razzi\Addons\Modules\Shortcodes' 						=> RAZZI_ADDONS_DIR . 'modules/shortcodes.php',
		] );

	}


	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function init() {
		if ( is_admin() ) {
			\Razzi\Addons\Modules\Ajax::instance();
		}

		if ( class_exists( 'WooCommerce' ) ) {
			\Razzi\Addons\Modules\Buy_Now\Module::instance();
			\Razzi\Addons\Modules\Catalog_Mode\Module::instance();
			\Razzi\Addons\Modules\Product_Deals\Module::instance();
			\Razzi\Addons\Modules\Size_Guide\Module::instance();
			\Razzi\Addons\Modules\Related_Products\Module::instance();
			\Razzi\Addons\Modules\Product_Tabs\Module::instance();
			\Razzi\Addons\Modules\Variation_Images\Module::instance();
			\Razzi\Addons\Modules\Free_Shipping_Bar\Module::instance();
			\Razzi\Addons\Modules\Product_Bought_Together\Module::instance();
			\Razzi\Addons\Modules\Live_Sales_Notification\Module::instance();
			\Razzi\Addons\Modules\Advanced_Search\Catalog::instance();
		}

		\Razzi\Addons\Modules\Mega_Menu\Module::instance();
		\Razzi\Addons\Modules\Shortcodes::instance();
	}

}
