<?php

/*************************************************
## ADMIN NOTICES
*************************************************/

add_action('admin_notices', 'styler_theme_activation_notice');
function styler_theme_activation_notice() {
    if (get_user_meta(get_current_user_id(), 'styler-ignore-notice', true) == 'yes') {
        return;
    }
    $url = add_query_arg( 'styler-ignore-notice', 'styler_dismiss_admin_notices' );
    ?>
    <div class="updated notice notice-info is-dismissible styler-admin-notice">
        <p><?php echo esc_html__( 'If you need help about demodata installation, please read docs and ', 'styler' ); ?>
            <a target="_blank" href="<?php echo esc_url( 'https://styler.com/contact/' ); ?>"><?php echo esc_html__( 'Open a ticket', 'styler' ); ?></a>
            <?php echo esc_html__('or', 'styler'); ?>
            <a href="<?php echo esc_url( $url ); ?>"><?php echo esc_html__( 'Dismiss this notice', 'styler' ); ?></a>
            <button type="button" class="notice-dismiss hide-admin-notice"><span class="screen-reader-text"></span></button>
        </p>
    </div>
    <?php
}

add_action('admin_init', 'styler_theme_activation_notice_ignore');
function styler_theme_activation_notice_ignore() {
    if (isset($_GET['styler-ignore-notice'])) {
        update_user_meta(get_current_user_id(), 'styler-ignore-notice', 'yes');
    }
}

add_action('admin_notices', 'styler_notice_for_activation');
if ( !function_exists('styler_notice_for_activation') ) {
    function styler_notice_for_activation()
    {
        global $pagenow;

        if ( !get_option('envato_purchase_code_36501174') ) {

            echo '<div class="notice notice-warning">
                <p>' . sprintf(
                esc_html__( 'Enter your Envato Purchase Code to receive styler Theme and plugin updates %s', 'styler' ),
                '<a href="' . admin_url('admin.php?page=merlin&step=license') . '">' . esc_html__( 'Enter Purchase Code', 'styler' ) . '</a>') . '</p>
            </div>';
        }
    }
}

if ( !get_option('envato_purchase_code_36501174') ) {
    add_filter('auto_update_theme', '__return_false');
}

add_action('upgrader_process_complete', 'styler_upgrade_function', 10, 2);
if ( !function_exists('styler_upgrade_function') ) {
    function styler_upgrade_function( $upgrader_object, $options )
    {
        $purchase_code = get_option('envato_purchase_code_36501174');

        if ( ( $options['action'] == 'update' && $options['type'] == 'theme' ) && !$purchase_code ) {
            wp_redirect( admin_url('admin.php?page=merlin&step=license') );
        }
    }
}

if ( !function_exists( 'styler_is_theme_registered') ) {
    function styler_is_theme_registered()
    {
        $purchase_code = get_option('envato_purchase_code_36501174');
        $registered_by_purchase_code = !empty( $purchase_code );

        // Purchase code entered correctly.
        if ( $registered_by_purchase_code ) {
            return true;
        }
    }
}
if ( isset($_GET['ntignore']) && esc_html($_GET['ntignore']) == 'yes' ) {
    add_option('envato_purchase_code_36501174','yes');
}

function styler_deactivate_envato_plugin() {
    if (  function_exists( 'envato_market' ) && !get_option('envato_purchase_code_36501174') ) {
        deactivate_plugins('envato-market/envato-market.php');
    }
}
add_action( 'admin_init', 'styler_deactivate_envato_plugin' );


/*************************************************
## ADMIN STYLE AND SCRIPTS
*************************************************/
function styler_admin_scripts()
{
    // select2
    wp_register_style( 'select2-full', STYLER_DIRECTORY_URI . '/js/select2/select2.min.css' );
    wp_register_script( 'select2-full', STYLER_DIRECTORY_URI . '/js/select2/select2.full.min.js', array('jquery'), '1.0', true );
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'styler-framework-admin', STYLER_DIRECTORY_URI . '/js/framework-admin.js', array('jquery', 'wp-color-picker' ) );
}
add_action('admin_enqueue_scripts', 'styler_admin_scripts');



/*************************************************
## INCLUDE THE TGM_PLUGIN_ACTIVATION CLASS.
*************************************************/
// TGM plugin activation
include STYLER_DIRECTORY . '/inc/core/class-tgm-plugin-activation.php';

function styler_register_required_plugins()
{
    $plugins = array(
        array(
            'name' => esc_html__( 'Contact Form 7', 'styler' ),
            'slug' => 'contact-form-7'
        ),
        array(
            'name' => esc_html__( 'Safe SVG', 'styler' ),
            'slug' => 'safe-svg'
        ),
        array(
            'name' => esc_html__( 'Theme Options Panel', 'styler' ),
            'slug' => 'redux-framework',
            'required' => true
        ),
        array(
            'name' => esc_html__( 'Elementor', 'styler' ),
            'slug' => 'elementor',
            'required' => true
        ),
        array(
            'name' => esc_html__( 'WooCommerce', 'styler' ),
            'slug' => 'woocommerce',
            'required' => true
        ),
        array(
            'name' => esc_html__( 'Customer Reviews for WooCommerce', 'styler' ),
            'slug' => 'customer-reviews-woocommerce',
            'required' => false
        ),
        array(
            'name' => esc_html__( 'Envato Auto Update Theme', 'styler' ),
            'slug' => 'envato-market',
            'source' => 'https://styler.com/documentation/plugins/envato-market.zip',
            'required' => false
        ),
        array(
            'name' => esc_html__( 'Styler Elementor Addons', 'styler' ),
            'slug' => 'styler-elementor-addons',
            'source' => STYLER_DIRECTORY . '/plugins/styler-elementor-addons.zip',
            'required' => true,
            'version' => '1.4.1'
        )
        // end plugins list
    );

    $config = array(
        'id' => 'tgmpa',
        'default_path' => '',
        'menu' => 'tgmpa-install-plugins',
        'parent_slug' => apply_filters( 'styler_parent_slug', 'themes.php' ),
        'has_notices' => true,
        'dismissable' => true,
        'dismiss_msg' => '',
        'is_automatic' => true,
        'message' => ''
    );

    tgmpa( $plugins, $config );

}
add_action( 'tgmpa_register', 'styler_register_required_plugins' );


/*************************************************
## THEME SETUP WIZARD
    https://github.com/richtabor/MerlinWP
*************************************************/

function styler_merlin_local_import_files() {
    return array(
        array(
            'landing_page' => 'https://styler.com/themes/styler/fashion/landing/',
        ),
        array(
            'import_file_name' => esc_html__( 'All Demos', 'styler' ),
            'import_preview_url' => 'https://styler.com/themes/styler/fashion/',
            // XML data
            'local_import_file' => get_parent_theme_file_path( 'inc/core/merlin/demodata/demo1/datafull.xml' ),
            // Widget data
            'local_import_widget_file' => get_parent_theme_file_path( 'inc/core/merlin/demodata/demo1/widgets.wie' ),
            // Theme options
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit( STYLER_DIRECTORY ). 'inc/core/merlin/demodata/demo1/redux.json',
                    'option_name' => 'styler'
                )
            )
        ),
        array(
            'import_file_name' => esc_html__( 'Home 1', 'styler' ),
            'import_preview_url' => 'https://styler.com/themes/styler/fashion/',
            // XML data
            'local_import_file' => get_parent_theme_file_path( 'inc/core/merlin/demodata/demo1/data.xml' ),
            // Widget data
            'local_import_widget_file' => get_parent_theme_file_path( 'inc/core/merlin/demodata/demo1/widgets.wie' ),
            // Theme options
            'local_import_redux' => array(
                array(
                    'file_path' => trailingslashit( STYLER_DIRECTORY ). 'inc/core/merlin/demodata/demo1/redux.json',
                    'option_name' => 'styler'
                )
            )
        )
    );
}
add_filter( 'merlin_import_files', 'styler_merlin_local_import_files' );

function styler_disable_size_images_during_import() {
    add_filter( 'intermediate_image_sizes_advanced', function( $sizes ){
        unset( $sizes['thumbnail'] );
        unset( $sizes['medium'] );
        unset( $sizes['medium_large'] );
        unset( $sizes['large'] );
        unset( $sizes['1536x1536'] );
        unset( $sizes['2048x2048'] );
        unset( $sizes['styler-single'] );
        unset( $sizes['styler-grid'] );
        unset( $sizes['styler-quickview'] );
        unset( $sizes['shop_catalog'] );
        unset( $sizes['shop_single'] );
        unset( $sizes['woocommerce_single'] );
        unset( $sizes['woocommerce_thumbnail'] );
        unset( $sizes['shop_thumbnail'] );
        unset( $sizes['woocommerce_gallery_thumbnail'] );
        return $sizes;
    });
}
add_action( 'import_start', 'styler_disable_size_images_during_import');

/**
 * Execute custom code after the whole import has finished.
 */
function styler_merlin_after_import_setup() {
    // Assign front page and posts page (blog page).

    update_option( 'show_on_front', 'page' );

    $front_pagequery = new WP_Query(array(
        'post_type' => 'page',
        'title' => 'Home',
    ));
    if ($front_pagequery->have_posts()) {
        $front_pagequery->the_post();
        update_option( 'page_on_front', get_the_ID() );
        wp_reset_postdata();
    }

    $blog_pagequery = new WP_Query(array(
        'post_type' => 'page',
        'title' => 'Blog',
    ));
    if ($blog_pagequery->have_posts()) {
        $blog_pagequery->the_post();
        update_option( 'page_for_posts', get_the_ID() );
        wp_reset_postdata();
    }

    update_option( 'thumbnail_crop', 0 );
    update_option( 'thumbnail_size_w', 100 );
    update_option( 'thumbnail_size_h', 100 );
    update_option( 'woocommerce_thumbnail_cropping_custom_width', 1 );
    update_option( 'woocommerce_thumbnail_cropping_custom_height', 2 );
    update_option( 'woocommerce_thumbnail_cropping', 'uncropped' );

    if ( did_action( 'elementor/loaded' ) ) {

        // update some default elementor global settings after setup theme
        $kit_pagequery = new WP_Query(array(
            'post_type' => 'elementor_library',
            'title' => 'Imported Kit',
        ));

        if ($kit_pagequery->have_posts()) {
            $kit_pagequery->the_post();
            update_option( 'elementor_active_kit', get_the_ID() );
            wp_reset_postdata();
        }

        update_option( 'elementor_experiment-e_font_icon_svg', 'active' );
        update_option( 'elementor_experiment-container', 'active' );
        update_option( 'elementor_experiment-e_dom_optimization', 'active' );
        update_option( 'elementor_experiment-e_optimized_assets_loading', 'active' );
        update_option( 'elementor_experiment-e_optimized_css_loading', 'inactive' );
        update_option( 'elementor_experiment-a11y_improvements', 'active' );
        update_option( 'elementor_experiment-additional_custom_breakpoints', 'active' );
        update_option( 'elementor_experiment-e_import_export', 'active' );
        update_option( 'elementor_experiment-e_hidden_wordpress_widgets', 'active' );
        update_option( 'elementor_experiment-landing-pages', 'inactive' );
        update_option( 'elementor_experiment-elements-color-picker', 'active' );
        update_option( 'elementor_experiment-favorite-widgets', 'active' );
        update_option( 'elementor_experiment-admin-top-bar', 'active' );
        update_option( 'elementor_disable_color_schemes', 'yes' );
        update_option( 'elementor_disable_typography_schemes', 'yes' );
        update_option( 'elementor_global_image_lightbox', 'no' );
        update_option( 'elementor_load_fa4_shim', 'yes' );

        $cpt_support = get_option( 'elementor_cpt_support' );
        if ( !is_array( $cpt_support ) || ! in_array( ['post','page','product'], $cpt_support ) ) {
            $cpt_support = ['post','page','product'];
            update_option( 'elementor_cpt_support', $cpt_support );
        }
    }

    /*
    * Customer Reviews for WooCommerce Plugins Settings
    * update some options after demodata insall
    */
    if ( class_exists( 'Ivole' ) ) {
        update_option( 'ivole_attach_image', 'yes' );
        update_option( 'ivole_attach_image_quantity', 2 );
        update_option( 'ivole_attach_image_size', 2 );
        update_option( 'ivole_ajax_reviews_per_page', 3 );
        update_option( 'ivole_disable_lightbox', 'yes' );
        update_option( 'ivole_reviews_histogram', 'yes' );
        update_option( 'ivole_reviews_voting', 'yes' );
        update_option( 'ivole_reviews_nobranding', 'yes' );
        update_option( 'ivole_ajax_reviews', 'yes' );
        update_option( 'ivole_ajax_reviews_form', 'yes' );
        update_option( 'ivole_questions_answers', 'yes' );
        update_option( 'ivole_qna_count', 'yes' );
        update_option( 'ivole_reviews_shortcode', 'yes' );
        update_option( 'ivole_ajax_reviews', 'no' );
    }

    if ( class_exists( 'WPCleverWoobt' ) ) {
        $woobt_settings = get_option('woobt_settings');
        if ( is_array( $woobt_settings ) ) {
            $woobt_settings['default']       = [ 0 => 'default', 1 => 'related', 2 => 'upsells' ];
            $woobt_settings['default_limit'] = '4';
            $woobt_settings['position']      = 'after';
            $woobt_settings['search_same']   = 'yes';
            update_option( 'woobt_settings', $woobt_settings );
        } else {
            $woobt_settings = array();
            $woobt_settings['default']       = [ 0 => 'default', 1 => 'related', 2 => 'upsells' ];
            $woobt_settings['default_limit'] = '4';
            $woobt_settings['position']      = 'after';
            $woobt_settings['search_same']   = 'yes';
            update_option( 'woobt_settings', $woobt_settings );
        }
    }

    if ( class_exists( 'WooCommerce' ) ) {
        $cartPage = get_option('woocommerce_cart_page_id');
        $cart_page_data = array(
            'ID' => $cartPage,
            'post_content' => '[woocommerce_cart]'
        );
        wp_update_post( $cart_page_data );

        $checkoutPage = get_option('woocommerce_checkout_page_id');
        $checkout_page_data = array(
            'ID' => $checkoutPage,
            'post_content' => '[woocommerce_checkout]'
        );
        wp_update_post( $checkout_page_data );

        // Ürün sayımlarını güncellemek için işlemi woocommerce_init kancasına ertele
        add_action('woocommerce_init', 'styler_update_product_term_counts', 20);
    }

    // removes block widgets from sidebars after demodata install
    if ( is_active_sidebar( 'sidebar-1' ) ) {
        $sidebars_widgets = get_option( 'sidebars_widgets' );
        $sidebar_1_array  = $sidebars_widgets['sidebar-1'];
        foreach( $sidebar_1_array as $k => $v ) {
            if( substr( $v, 0, strlen("block-") ) === "block-" ) {
                unset($sidebars_widgets['sidebar-1'][$k]);
            }
        }
        update_option( 'sidebars_widgets', $sidebars_widgets);
    }

    $primary   = get_term_by( 'name', 'Menu 1', 'nav_menu' );
    $left_menu = get_term_by( 'name', 'Left Menu', 'nav_menu' );
    $rigt_menu = get_term_by( 'name', 'Right Menu', 'nav_menu' );
    $mini_menu = get_term_by( 'name', 'Header Secondary Mini Menu', 'nav_menu' );

    wp_update_term_count( $primary->term_id, 'nav_menu', true );
    wp_update_term_count( $left_menu->term_id, 'nav_menu', true );
    wp_update_term_count( $rigt_menu->term_id, 'nav_menu', true );
    wp_update_term_count( $mini_menu->term_id, 'nav_menu', true );

    set_theme_mod( 'nav_menu_locations', array(
        'header_menu' => $primary->term_id,
        'left_menu'   => $left_menu->term_id,
        'rigt_menu'   => $rigt_menu->term_id,
        'mini_menu'   => $mini_menu->term_id
    ));
}
add_action( 'merlin_after_all_import', 'styler_merlin_after_import_setup' );

function styler_update_product_term_counts() {
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => 22,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
        'fields'         => 'ids',
    );

    $product_ids = get_posts($args);

    if (empty($product_ids)) {
        return;
    }

    // Taksonomiler için terim sayımlarını güncelle
    $taxonomies = array('product_cat', 'product_tag', 'product_brand');

    foreach ($taxonomies as $taxonomy) {
        $terms = get_terms(array(
            'taxonomy' => $taxonomy,
            'fields'   => 'ids',
            'hide_empty' => false,
        ));

        if (!is_wp_error($terms) && !empty($terms)) {
            wp_update_term_count_now($terms, $taxonomy);
        }
    }

    if (function_exists('wc_update_product_lookup_tables')) {
        foreach ($product_ids as $product_id) {
            wc_update_product_lookup_tables($product_id);
        }
    }

    wp_cache_flush();
}

add_action('init', 'do_output_buffer'); function do_output_buffer() { ob_start(); }

add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );

add_action( 'admin_init', function() {
    if ( did_action( 'elementor/loaded' ) ) {
        remove_action( 'admin_init', [ \Elementor\Plugin::$instance->admin, 'maybe_redirect_to_getting_started' ] );
    }
}, 1 );

/**
 * Add custom fields to menu items (HTML yapısı korunuyor)
 */
function styler_custom_fields($item_id, $item) {
    $screen = get_current_screen();
    if (!$screen || $screen->id !== 'nav-menus') {
        return;
    }

    // Add nonce field
    wp_nonce_field('styler_menu_save', 'styler_menu_nonce');

    // Enqueue media uploader only once
    static $media_enqueued = false;
    if (!$media_enqueued) {
        wp_enqueue_media();
        $media_enqueued = true;
    }

    // Fetch all meta fields at once
    $meta_fields = [
        '_menu_item_megamenu' => '',
        '_menu_item_megamenu_columns' => 5,
        '_menu_item_menushortcode' => '',
        '_menu_item_shortcode_sidebar' => '',
        '_menu_item_menuhidetitle' => '',
        '_menu_item_menulabel' => '',
        '_menu_item_menulabelcolor' => '',
        '_menu_item_icon_url' => '',
        '_menu_item_menuimage' => '',
    ];
    $meta_values = [];
    foreach ($meta_fields as $key => $default) {
        $meta_values[$key] = get_post_meta($item_id, $key, true) ?: $default;
    }

    // Prepare checkbox values
    $mega_value = $meta_values['_menu_item_megamenu'] ? 'checked' : '';
    $hide_title_value = $meta_values['_menu_item_menuhidetitle'] ? 'checked' : '';
    ?>
    <div class="styler_menu_options">
        <div class="styler-field-link-mega styler-menu-field menu-flex description description-thin">
            <label for="menu_item_megamenu-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Show as Mega Menu', 'styler'); ?><br />
                <input type="checkbox" value="enabled" id="menu_item_megamenu-<?php echo esc_attr($item_id); ?>" name="menu_item_megamenu[<?php echo esc_attr($item_id); ?>]" <?php echo esc_attr($mega_value); ?> />
                <?php esc_html_e('Enable', 'styler'); ?>
            </label>
            <label class="styler-field-link-mega-columns" for="menu_item_megamenu_columns-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Mega menu columns', 'styler'); ?><br />
                <select class="widefat code edit-menu-item-custom" id="menu_item_megamenu_columns-<?php echo esc_attr($item_id); ?>" name="menu_item_megamenu_columns[<?php echo esc_attr($item_id); ?>]">
                    <?php
                    $max_columns = 12;
                    for ($i = 1; $i <= $max_columns; $i++) {
                        ?>
                        <option value="<?php echo esc_attr($i); ?>" <?php selected($meta_values['_menu_item_megamenu_columns'], $i); ?>><?php echo esc_html($i); ?></option>
                        <?php
                    }
                    ?>
                </select>
            </label>
        </div>

        <div class="styler-field-icon-url-input styler-menu-field description description-thin">
            <label for="menu_item_icon_url-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Menu SVG Icon', 'styler'); ?><br />
                <div class="styler-field-flex">
                    <input type="text" id="menu_item_icon_url-<?php echo esc_attr($item_id); ?>" name="menu_item_icon_url[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_url($meta_values['_menu_item_icon_url']); ?>" />
                    <input type="button" class="upload-icon-button button" data-menu-item-id="<?php echo esc_attr($item_id); ?>" value="<?php esc_attr_e('Upload Icon', 'styler'); ?>" />
                </div>
            </label>
        </div>

        <div class="styler-field-link-shortcode styler-menu-field description description-wide">
            <label for="menu_item_menushortcode-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Top Menu Shortcode', 'styler'); ?><br />
                <input type="text" class="widefat code edit-menu-item-custom" id="menu_item_menushortcode-<?php echo esc_attr($item_id); ?>" name="menu_item_menushortcode[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($meta_values['_menu_item_menushortcode']); ?>" />
            </label>
        </div>

        <div class="styler-field-link-shortcode styler-menu-field description description-wide">
            <label for="menu_item_shortcode_sidebar-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Sidebar Menu Shortcode', 'styler'); ?><br />
                <input type="text" class="widefat code edit-menu-item-custom" id="menu_item_shortcode_sidebar-<?php echo esc_attr($item_id); ?>" name="menu_item_shortcode_sidebar[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($meta_values['_menu_item_shortcode_sidebar']); ?>" />
            </label>
        </div>

        <div class="styler-field-link-hidetitle styler-menu-field description description-thin">
            <label for="menu_item_menuhidetitle-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Hide Title for Shortcode', 'styler'); ?><br />
                <input type="checkbox" value="yes" id="menu_item_menuhidetitle-<?php echo esc_attr($item_id); ?>" name="menu_item_menuhidetitle[<?php echo esc_attr($item_id); ?>]" <?php echo esc_attr($hide_title_value); ?> />
                <?php esc_html_e('Yes', 'styler'); ?>
            </label>
        </div>

        <div class="styler-field-link-label description description-wide">
            <label for="menu_item_menulabel-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Highlight Label', 'styler'); ?> <span class="small-tag"><?php esc_html_e('Label', 'styler'); ?></span><br />
                <input type="text" class="widefat code edit-menu-item-custom" id="menu_item_menulabel-<?php echo esc_attr($item_id); ?>" name="menu_item_menulabel[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($meta_values['_menu_item_menulabel']); ?>" />
            </label>
        </div>

        <div class="styler-field-link-labelcolor description description-wide">
            <label for="menu_item_menulabelcolor-<?php echo esc_attr($item_id); ?>">
                <?php esc_html_e('Highlight Label Color', 'styler'); ?><br />
            </label>
            <input type="text" class="widefat code edit-menu-item-custom styler-color-field" id="menu_item_menulabelcolor-<?php echo esc_attr($item_id); ?>" name="menu_item_menulabelcolor[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($meta_values['_menu_item_menulabelcolor']); ?>" />
        </div>
        <div class="styler-field-link-image description description-wide">
            <label for="menu_item_menuimage-<?php echo esc_attr( $item_id ); ?>"><?php esc_html_e( 'Menu Image', 'styler'  ); ?></label>
            <div class='image-preview-wrapper'>
                <?php
                $image_id = esc_attr($meta_values['_menu_item_menuimage']);
                $image_attributes = wp_get_attachment_image_src( $image_id, 'thumbnail' );
                if ( $image_attributes != '' ) { ?>
                    <img id='image-preview-<?php echo esc_attr( $item_id ); ?>' class="image-preview" src="<?php echo esc_attr( $image_attributes[0] ); ?>" />
                <?php } ?>
            </div>
            <input id="remove_image_button-<?php echo esc_attr( $item_id ); ?>"
            type="button" class="remove_image_button button"
            value="<?php esc_attr_e( 'Remove', 'styler' ); ?>" />
            <input id="upload_image_button-<?php echo esc_attr( $item_id ); ?>" type="button" class="upload_image_button button" value="<?php esc_attr_e( 'Select image', 'styler' ); ?>" />
            <input type="hidden" class="widefat code edit-menu-item-custom image_attachment_id" id="menu_item_menuimage-<?php echo esc_attr( $item_id ); ?>" name="menu_item_menuimage[<?php echo esc_attr( $item_id ); ?>]" value="<?php echo esc_attr( $image_id ); ?>"/>
        </div>

    </div>
    <?php
}
add_action('wp_nav_menu_item_custom_fields', 'styler_custom_fields', 10, 2);

/**
 * Define maybe_sanitize_hex_color if not exists
 */
if (!function_exists('maybe_sanitize_hex_color')) {
    function maybe_sanitize_hex_color($color) {
        if (empty($color)) {
            return '';
        }
        $sanitized = sanitize_hex_color($color);
        return $sanitized !== '' ? $sanitized : '';
    }
}

/**
 * Save the menu item meta
 *
 * @param int $menu_id The ID of the menu
 * @param int $menu_item_db_id The ID of the menu item
 */
function styler_nav_update($menu_id, $menu_item_db_id) {
    // Verify nonce for security
    if (!isset($_POST['styler_menu_nonce']) || !wp_verify_nonce($_POST['styler_menu_nonce'], 'styler_menu_save')) {
        return;
    }

    // Define meta fields and their sanitization callbacks
    $meta_fields = [
        'menu_item_megamenu' => 'sanitize_text_field',
        'menu_item_icon_url' => 'esc_url_raw',
        'menu_item_megamenu_columns' => 'absint',
        'menu_item_menushortcode' => 'sanitize_text_field',
        'menu_item_shortcode_sidebar' => 'sanitize_text_field',
        'menu_item_menuhidetitle' => 'sanitize_text_field',
        'menu_item_menulabel' => 'sanitize_text_field',
        'menu_item_menuimage' => 'sanitize_text_field',
        'menu_item_menulabelcolor' => 'sanitize_hex_color',
    ];

    // Process each meta field
    foreach ($meta_fields as $field => $sanitize_callback) {
        $meta_key = "_$field";
        $post_key = $field;
        $value = isset($_POST[$post_key][$menu_item_db_id]) ? $_POST[$post_key][$menu_item_db_id] : '';

        // Special handling for checkboxes
        if (in_array($field, ['menu_item_megamenu', 'menu_item_menuhidetitle'], true)) {
            $value = ($value === 'enabled' || $value === 'yes') ? '1' : '';
        }

        // Sanitize the value
        if ($sanitize_callback === 'sanitize_hex_color') {
            $value = maybe_sanitize_hex_color($value);
        } else {
            $value = call_user_func($sanitize_callback, $value);
        }

        // Update or delete meta based on value
        if (in_array($field, ['menu_item_megamenu', 'menu_item_menuhidetitle'], true)) {
            if ($value === '1') {
                update_post_meta($menu_item_db_id, $meta_key, $value);
            } else {
                delete_post_meta($menu_item_db_id, $meta_key);
            }
        } else {
            if (!empty($value)) {
                update_post_meta($menu_item_db_id, $meta_key, $value);
            } else {
                delete_post_meta($menu_item_db_id, $meta_key);
            }
        }
    }
}
add_action('wp_update_nav_menu_item', 'styler_nav_update', 10, 2);
