jQuery(document).ready(function($) {

    /*-- Strict mode enabled --*/
    'use strict';

    function scrollToTop(target,delay,timeout) {
        setTimeout(function(){
            $('html, body').stop().animate({
                scrollTop: target.offset().top
            }, delay);
        }, timeout );
    }

    if ( $('.styler-product-gallery-main-slider-carousel').length ) {
        if ( $('.styler-product-thumbnails').length ) {
            var thumbsOptions  = $('.styler-product-thumbnails').data('swiper-options');
                thumbsOptions["on"] = {
                resize: function(swiper){
                    swiper.update();
                }
            };
            $('.styler-product-gallery-main-slider-carousel .swiper-slide').each(function(){
                var clonedImg = $(this).find('img').clone();
                var videoIcon = $(this).hasClass('iframe-video') ? ' video-icon' : '';
                if ( $(this).hasClass('iframe-video') ) {
                    $('<div class="swiper-slide"><div class="video-icon"><i class="fa fa-play"></i></div></div>').appendTo('.styler-product-thumbnails .swiper-wrapper');
                } else {
                    $(clonedImg).appendTo('.styler-product-thumbnails .swiper-wrapper').wrap('<div class="swiper-slide"></div>');
                }

            })
            var galleryThumbs  = new NTSwiper( '.styler-product-thumbnails', thumbsOptions );
        }

        var galleryOptionsFull       = $('.styler-product-gallery-main-slider-carousel').data('swiper-options');
            if ( $('.styler-product-thumbnails').length ) {
                galleryOptionsFull["thumbs"]  = {swiper: galleryThumbs};
            }
            galleryOptionsFull["on"] = {
                transitionEnd : function ( swiper ) {
                    var  active = swiper.realIndex;

                    $( '.styler-product-gallery-main-slider-carousel .iframe-video:not(.swiper-slide-active)' ).each(function () {
                        var iframe = $( this ).find('iframe');
                        if ( iframe.length && iframe.hasClass('youtube-video') ) {
                            iframe[0].contentWindow.postMessage('{"event":"command","func":"' + 'pauseVideo' + '","args":""}', '*');
                        }
                        if ( iframe.length && iframe.hasClass('vimeo-video') ) {
                            iframe[0].contentWindow.postMessage('{"method":"pause"}', '*');
                        }
                    });

                    $( '.styler-product-gallery-main-slider-carousel .iframe-video.swiper-slide-active' ).each(function () {
                        var iframe2 = $( this ).find('iframe');
                        if ( iframe2.length && iframe2.hasClass('youtube-video') ) {
                            iframe2[0].contentWindow.postMessage('{"event":"command","func":"' + 'playVideo' + '","args":""}', '*');
                        }
                        if ( iframe2.length && iframe2.hasClass('vimeo-video') ) {
                            iframe2[0].contentWindow.postMessage('{"method":"play"}', '*');
                        }
                    });
                },
                resize: function(swiper){
                    swiper.update();
                }
            };
        var galleryMainFull     = new NTSwiper( '.styler-product-gallery-main-slider-carousel', galleryOptionsFull );

        var $oMainImgFull       = $('.styler-product-gallery-main-slider-carousel .styler-swiper-slide-first img'),
            $oZoomSrc           = $('.styler-product-gallery-main-slider-carousel .styler-swiper-slide-first').data('src'),
            $oMainSrcFull       = $oMainImgFull.data('src'),
            $oMainSrcSetFull    = $oMainImgFull.data('srcset'),
            $oMainSrcSizesFull  = $oMainImgFull.data('sizes');

        $( document ).on('change','.styler-product-summary .variations_form select', function( e ) {
            var $thisFull      = $(this),
                $formFull      = $thisFull.parents('.variations_form'),
                variationsFull = $formFull.data('product_variations'),
                $oZoomImgFull  = $('.styler-product-gallery-main-slider-carousel .styler-swiper-slide-first img.zoomImg'),
                galleryFull    = $('.styler-product-gallery-main-slider-carousel');

            setTimeout( function() {
                var current_id = $formFull.attr('current-image'),
                    full_src,
                    imageFull,
                    timageFull,
                    srcFull,
                    srcsetFull,
                    sizesFull;

                $.map(variationsFull, function(elementOfArray, indexInArray) {
                    if (elementOfArray.image_id == current_id) {
                        imageFull  = elementOfArray.image;
                        full_src   = imageFull.full_src;
                        srcFull    = imageFull.src;
                        srcsetFull = imageFull.srcset;
                        sizesFull  = imageFull.sizes;
                    }
                });

                if ( current_id ) {
                    $oMainImgFull.attr('src',srcFull);
                    $oMainImgFull.attr('data-src',srcFull);
                    $oZoomImgFull.attr('src',full_src);
                    if ( srcsetFull ) {
                        $oMainImgFull.attr('srcset',srcsetFull);
                    }
                    if ( sizesFull ) {
                        $oMainImgFull.attr('sizes',sizesFull);
                    }

                    setTimeout( function() {
                        if ( !$oMainImgFull.hasClass('swiper-slide-active') ) {
                            $('.styler-product-gallery-main-slider-carousel .swiper-pagination .swiper-pagination-bullet:first').trigger('click');
                        }
                        $('.styler-product-gallery-main-slider-carousel .swiper-slide-active').attr('data-src',srcFull);
                        initZoomFull('reinit',full_src);
                    }, 100, $oMainImgFull,galleryMainFull );

                    if ( styler_vars.scrolltop == 'yes' ) {
                        scrollToTop(galleryFull,300,300);
                    }
                }
            }, 50 );

        });

        $( document ).on('click','.styler-product-summary .reset_variations', function( e ) {
            var $formFull     = $(this).parents('.variations_form'),
                galleryFull   = $('.styler-product-gallery-main-slider-carousel'),
                $oZoomImgFull = $('.styler-product-gallery-main-slider-carousel .styler-swiper-slide-first img.zoomImg');

            $oMainImgFull.attr('src',$oMainSrcFull);
            $oMainImgFull.attr('data-src',$oMainSrcFull);
            $oZoomImgFull.attr('src',$oZoomSrc);
            if ( $oMainSrcSetFull ) {
                $oMainImgFull.attr('srcset',$oMainSrcSetFull);
            }
            if ( $oMainSrcSizesFull ) {
                $oMainImgFull.attr('sizes',$oMainSrcSizesFull);
            }

            setTimeout( function() {
                if ( !$oMainImgFull.hasClass('swiper-slide-active') ) {
                    $('.styler-product-gallery-main-slider-carousel .swiper-pagination .swiper-pagination-bullet:first').trigger('click');
                }
                $('.styler-product-gallery-main-slider-carousel .swiper-slide-active').attr('data-src',$oZoomSrc);
                initZoomFull('reinit',$oZoomSrc);
            }, 100, $oMainImgFull,galleryMainFull );

            if ( styler_vars.scrolltop == 'yes' ) {
                scrollToTop(galleryFull,400,300);
            }
        });

        initZoomFull('load');

        /**
        * Init zoom.
        */
        function initZoomFull($action,$url) {
            if ( 'function' !== typeof $.fn.zoom && !wc_single_product_params.zoom_enabled ) {
                return false;
            }

            var galleryWidthFull = $('.styler-product-gallery-main-slider-carousel .swiper-slide').width(),
                zoomEnabled  = false,
                zoom_options = {
                    touch: false
                };

            if ( 'ontouchstart' in document.documentElement ) {
                zoom_options.on = 'click';
            }

            $('.styler-product-gallery-main-slider-carousel .swiper-slide img').each( function( index, target ) {
                var imageFull = $( target );
                var imageIndex = imageFull.parents('.swiper-slide').data('swiper-slide-index');

                if ( imageFull.attr( 'width' ) > galleryWidthFull ) {
                    if ( $action == 'load' ) {

                        zoom_options.url = imageFull.parent().data('src');
                        imageFull.wrap('<span class="styler-zoom-wrapper" style="display:inline-block"></span>')
                          .css('display', 'block')
                          .parent()
                          .zoom(zoom_options);
                    } else {
                        imageFull.trigger('zoom.destroy').unwrap();
                        zoom_options.url = imageIndex == 0 ? $url : imageFull.parent().data('src');
                        imageFull.wrap('<span class="styler-zoom-wrapper" style="display:inline-block"></span>')
                          .css('display', 'block')
                          .parent()
                          .zoom(zoom_options);
                    }
                }
            });
        }
    }

});
