'use strict';

window.styler = {};

(
function(styler, $) {
    styler = styler || {};

    $.extend(styler, {
        Swatches: {
            init: function() {
                var $term = $('.styler-term'),
                $active_term = $('.styler-term:not(.styler-disabled)');

                // load default value
                $term.each(function() {
                    var $this       = $(this),
                        term        = $this.attr('data-term'),
                        attr        = $this.closest('.styler-terms').attr('data-attribute'),
                        $select_box = $this.closest('.styler-terms').parent().find('select#' + attr),
                        val         = $select_box.val();
                        
                    if ( val != '' && term == val ) {
                        $(this).addClass('styler-selected').find('input[type="radio"]').prop('checked', true);
                    }
                });

                $active_term.unbind('click touch').on('click touch', function(e) {
                    var $this       = $(this),
                        term        = $this.attr('data-term'),
                        title       = $this.attr('title'),
                        attr        = $this.closest('.styler-terms').attr('data-attribute'),
                        $select_box = $this.closest('.styler-terms').parent().find('select#' + attr);

                    if ( $this.hasClass('styler-disabled') ) {
                        return false;
                    }

                    if ( !$this.hasClass('styler-selected') ) {
                        $select_box.val(term).trigger('change');

                        $this.closest('.styler-terms').find('.styler-selected').removeClass('styler-selected').find('input[type="radio"]').prop('checked', false);

                        $this.addClass('styler-selected').find('input[type="radio"]').prop('checked', true);

                        $(document).trigger('styler_selected', [attr, term, title]);
                    }

                    e.preventDefault();
                });

                $(document).on('woocommerce_update_variation_values', function(e) {

                    setTimeout(function(){
                        var resetBtn = $(e['target']).find('.reset_variations');
                        if ( resetBtn.css('visibility') == 'visible' ) {
                            resetBtn.parent().addClass('active');
                        }
                    },100);

                    $(e['target']).find('select').each(function() {
                        var $this = $(this);
                        var $terms = $this.parent().find('.styler-terms');

                        $terms.find('.styler-term').removeClass('styler-enabled').addClass('styler-disabled');

                        $this.find('option.enabled').each(function() {
                            var val = $(this).val();
                            if (val) {
                                $terms.find('.styler-term[data-term="' + val + '"]').removeClass('styler-disabled').addClass('styler-enabled');
                            }
                        });
                    });
                });

                $(document).on('reset_data', function(e) {
                    $(document).trigger('styler_reset');
                    var $this = $(e['target']);
                    $this.find('.styler-selected').removeClass('styler-selected').find('input[type="radio"]').prop('checked', false);

                    $this.find('select').each(function() {
                        var attr = $(this).attr('id');
                        var title = $(this).find('option:selected').text();
                        var term = $(this).val();

                        if ( term != '' ) {
                            $(this).parent().
                            find('.styler-term[data-term="' + term + '"]').
                            addClass('styler-selected').find('input[type="radio"]').
                            prop('checked', true);

                            $(document).trigger('styler_reset', [attr, term, title]);
                        }
                    });
                });
            }
        }
    });

}).apply(this, [window.styler, jQuery]);

(function(styler, $) {

    $(document).on('wc_variation_form', function() {
        if ( typeof styler.Swatches !== 'undefined' ) {
            styler.Swatches.init();
        }
    });

    $(document.body).on('styler_variations_init', function() {
        if ( typeof styler.Swatches !== 'undefined' ) {
            styler.Swatches.init();
        }
        $('.styler-products-wrapper .variations_form').each(function () {
            $(this).wc_variation_form();
        });
    });

    $('form.variations_form').each(function() {
        var $form = $(this);

        var disabledTerms = $form.find('.styler-term.styler-disabled').map(function() {
            return $(this).data('term');
        }).get();
    });

    $(document).on('found_variation', function(e, t) {
        if ( $(e['target']).closest('.styler-loop-swatches').length ) {
            var $product = $(e['target']).closest('.styler-product'),
                $atc     = $product.find('.add_to_cart_button'),
                $image   = $product.find('.attachment-woocommerce_thumbnail'),
                $price   = $product.find('.price');

            if ( $atc.length ) {
                $atc.addClass('styler_add_to_cart').removeClass('styler-quick-shop-btn').attr('data-variation_id', t['variation_id']).attr('data-product_sku', t['sku']);

                if ( !t['is_purchasable'] || !t['is_in_stock'] ) {
                    $atc.addClass('disabled wc-variation-is-unavailable');
                } else {
                    $atc.removeClass('disabled wc-variation-is-unavailable');
                }

                $atc.removeClass('added error loading');
            }

            $product.find('a.added_to_cart').remove();

            // add to cart button text
            if ( $atc.length ) {
                $atc.text(styler_vars.add_to_cart);
                $product.find('.styler-add-to-cart-btn').addClass('ready');
            }

            // product image
            if ( $image.length ) {

                if ( $image.attr('data-src') == undefined ) {
                    $image.attr('data-src', $image.attr('src'));
                }

                if ( $image.attr('data-srcset') == undefined ) {
                    $image.attr('data-srcset', $image.attr('srcset'));
                }

                if ( $image.attr('data-sizes') == undefined ) {
                    $image.attr('data-sizes', $image.attr('sizes'));
                }

                if ( t['image']['src'] != undefined && t['image']['src'] != '' ) {
                    if ( t['image']['thumb_src'] != undefined && t['image']['thumb_src'] != '' ) {
                        $image.attr('src', t['image']['thumb_src']);
                    } else {
                        $image.attr('src', t['image']['src']);
                    }
                }

                if ( t['image']['srcset'] != undefined && t['image']['srcset'] != '' ) {
                    $image.attr('srcset', t['image']['srcset']);
                } else {
                    $image.attr('srcset', '');
                }

                if ( t['image']['sizes'] != undefined && t['image']['sizes'] != '' ) {
                    $image.attr('sizes', t['image']['sizes']);
                } else {
                    $image.attr('sizes', '');
                }
            }

            // product price
            if ( $price.length ) {
                if ( $price.attr('data-price') == undefined ) {
                    $price.attr('data-price', $price.html());
                }

                if ( t['price_html'] ) {
                    $price.html( t['price_html'] );
                }
            }

            $(document).trigger('styler_archive_found_variation', [t]);
        }
    });

    $(document).on('reset_data', function(e) {
        if ( $(e['target']).closest('.styler-loop-swatches').length ) {
            var $product = $(e['target']).closest('.styler-product'),
                $atc     = $product.find('.add_to_cart_button'),
                $image   = $product.find('.attachment-woocommerce_thumbnail'),
                $price   = $product.find('.price');

            if ( $atc.length ) {
                $atc.addClass('styler-quick-shop-btn').removeClass('styler_add_to_cart disabled wc-variation-is-unavailable').attr('data-variation_id', '0').attr('data-product_sku', '');
                $atc.removeClass('added error loading');
                $product.find('.styler-add-to-cart-btn').removeClass('ready');
            }

            $product.find('a.added_to_cart').remove();

            // add to cart button text
            if ( $atc.length ) {
                $atc.text(styler_vars.select_options);
            }

            // product image
            if ( $image.length ) {
                $image.attr('src', $image.attr('data-src'));
                $image.attr('srcset', $image.attr('data-srcset'));
                $image.attr('sizes', $image.attr('data-sizes'));
            }

            // product price
            if ( $price.length ) {
                $price.html($price.attr('data-price'));
            }

            $(document).trigger('styler_archive_reset_data');
        }
    });

    $(document).on('click touch', '.styler_add_to_cart', function(e) {
        e.preventDefault();
        var $this = $(this);
        var $product = $this.closest('.styler-product');
        var attributes = {};

        $this.removeClass('added error');
        $product.addClass('loading');

        if ($product.length) {
            $product.find('a.added_to_cart').remove();

            $product.find('[name^="attribute"]').each(function() {
                attributes[$(this).attr('data-attribute_name')] = $(this).val();
            });

            var data = {
                action       : 'styler_swatches_add_to_cart',
                nonce        : styler_vars.security,
                product_id   : $this.attr('data-product_id'),
                variation_id : $this.attr('data-variation_id'),
                quantity     : $this.attr('data-quantity'),
                attributes   : JSON.stringify(attributes),
            };

            $.post(styler_vars.ajax_url, data, function(response) {
                if (response) {
                    $this.addClass('added');
                    $product.removeClass('loading');

                    var fragments = response.fragments;
                    var appended  = '<div class="woocommerce-notices-wrapper">'+fragments.notices+'</div>';
                    var duration  = styler_vars.duration;

                    $(appended).prependTo('.styler-shop-popup-notices').delay(duration).fadeOut(300, function(){
                        $(this).remove();
                    });

                    // update other areas
                    $('.styler-minicart').replaceWith(fragments.minicart);
                    $('.styler-cart-count').html(fragments.count);
                    $('.styler-side-panel').attr('data-cart-count',fragments.count);
                    $('.styler-cart-total:not(.page-total)').html(fragments.total);
                    if ( $('.styler-cart-goal-text').length>0 ) {
                        $('.styler-cart-goal-text').html(fragments.shipping.message);
                        $('.styler-progress-bar').css('width',fragments.shipping.value+'%');
                        if ( fragments.shipping.value >= 100 ) {
                            $('.styler-cart-goal-wrapper').addClass('free-shipping-success shakeY');
                        }
                    }

                    // Redirect to cart option
                    if ( styler_vars.cart_redirect === 'yes' ) {
                        window.location = styler_vars.cart_url;
                        return;
                    }

                    if ( styler_vars.minicart_open === 'yes' ) {
                        $('html,body').addClass('styler-overlay-open');
                        $('.styler-side-panel,.panel-content .cart-area').addClass('active');
                    }

                    if ( styler_vars.is_checkout == 'yes' ){
                        location.reload(); // page reload
                    }

                    $(document.body).trigger('styler_update_minicart');
                    $(document.body).trigger('added_to_cart').trigger('wc_fragment_refresh');
                } else {
                    $this.removeClass('loading').addClass('error');
                }
            });
        }
    });

}).apply(this, [window.styler, jQuery]);
