<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class Styler_Template_Slider extends Widget_Base {
    use Styler_Helper;
    public function get_name() {
        return 'styler-template-slider';
    }
    public function get_title() {
        return 'Template Slider (N)';
    }
    public function get_icon() {
        return 'eicon-slider-push';
    }
    public function get_categories() {
        return [ 'styler' ];
    }
    // Registering Controls
    protected function register_controls() {
        /*****   END CONTROLS SECTION   ******/
        $this->start_controls_section( 'home_slider_content_section',
            [
                'label' => esc_html__( 'Content', 'wavo' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control( 'content',
            [
                'label' => esc_html__( 'Content', 'elementories' ),
                'type' => Controls_Manager::SELECT2,
                'default' => '',
                'multiple' => false,
                'options' => $this->styler_get_elementor_templates()
            ]
        );
        $this->add_responsive_control( 'content_maxwidth',
            [
                'label' => esc_html__( 'Slide Item Container Max Width', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 4000,
                'step' => 1,
                'default' => 1140,
                'selectors' => [ '{{WRAPPER}} .elementor-section.swiper-slide>.elementor-container' => 'max-width:{{SIZE}}px;' ]
            ]
        );
        $this->add_responsive_control( 'slider_height',
            [
                'label' => esc_html__( 'Slider Height', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 2000,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .elementor-section.swiper-slide>.elementor-container,{{WRAPPER}} .swiper-slide' => 'height:{{SIZE}}px;max-height:{{SIZE}}px;min-height:auto;' ]
            ]
        );
        $this->add_control( 'bg_video_mute',
            [
                'label' => esc_html__( 'Background Video Sound?', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/

        $this->start_controls_section( 'home_slider_section',
            [
                'label' => esc_html__( 'Slider Options', 'wavo' ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );
        $this->add_control( 'speed',
            [
                'label' => esc_html__( 'Speed', 'wavo' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 5000,
                'step' => 100,
                'default' => 1000,
                'separator' => 'before',
            ]
        );
        $this->add_control( 'dots',
            [
                'label' => esc_html__( 'Dots', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control( 'nav',
            [
                'label' => esc_html__( 'Navigation', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
            ]
        );
        $this->add_control( 'mousewheel',
            [
                'label' => esc_html__( 'Mousewheel', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes'
            ]
        );
        $this->add_control( 'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );
        $this->add_control( 'loop',
            [
                'label' => esc_html__( 'Loop', 'wavo' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control( 'duration',
            [
                'label' => esc_html__( 'Duration (ms)', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 10000,
                'step' => 5,
                'default' => ''
            ]
        );
        $this->add_control( 'durations',
            [
                'label' => esc_html__( 'Side Items Duration', 'styler' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => 'Duration : {{duration}}',
                'default' => []
            ]
        );

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('dots_style_section',
            [
                'label'=> esc_html__( 'SLIDER DOTS STYLE', 'styler' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [ 'dots' => 'yes' ]
            ]
        );
        $this->add_control( 'dots_top_offset',
            [
                'label' => esc_html__( 'Bottom Offset', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .styler-swiper-theme-style .swiper-pagination-bullets' => 'bottom:{{SIZE}}px;' ]
            ]
        );
        $this->add_responsive_control( 'dots_alignment',
            [
                'label' => esc_html__( 'Alignment', 'styler' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'styler' ),
                        'icon' => 'eicon-h-align-left'
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'styler' ),
                        'icon' => 'eicon-h-align-center'
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'styler' ),
                        'icon' => 'eicon-h-align-right'
                    ]
                ],
                'toggle' => true,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .styler-swiper-theme-style .swiper-pagination-bullets' => 'text-align:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'dots_size',
            [
                'label' => esc_html__( 'Size', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet:before' => 'width:{{SIZE}}px;height:{{SIZE}}px;' ]
            ]
        );
        $this->add_control( 'dots_space',
            [
                'label' => esc_html__( 'Space', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .swiper-horizontal > .swiper-pagination-bullets .swiper-pagination-bullet + .swiper-pagination-bullet' => 'margin: 0;margin-left: {{SIZE}}px;',
                    '{{WRAPPER}} .swiper-pagination-horizontal.swiper-pagination-bullets .swiper-pagination-bullet + .swiper-pagination-bullet' => 'margin: 0;margin-left: {{SIZE}}px;',
                ]
            ]
        );
        $this->start_controls_tabs( 'dots_nav_tabs');
        $this->start_controls_tab( 'dots_normal_tab',
            [ 'label' => esc_html__( 'Normal', 'styler' ) ]
        );
        $this->add_control( 'dots_bgcolor',
            [
                'label' => esc_html__( 'Background', 'styler' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet:before' => 'background-color:{{VALUE}};' ]
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_border',
                'label' => esc_html__( 'Border', 'styler' ),
                'selector' => '{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet',
            ]
        );
        $this->add_responsive_control( 'dots_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'styler' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet:before,{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'dots_hover_tab',
            [ 'label' => esc_html__( 'Active', 'styler' ) ]
        );
        $this->add_control( 'dots_hvrbgcolor',
            [
                'label' => esc_html__( 'Color', 'styler' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active:before' => 'background-color:{{VALUE}};' ]
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'dots_hvrborder',
                'label' => esc_html__( 'Border', 'styler' ),
                'selector' => '{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active'
            ]
        );
        $this->add_responsive_control( 'dots_hvrborder_radius',
            [
                'label' => esc_html__( 'Border Radius', 'styler' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active:before,{{WRAPPER}} .swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
        /*****   START CONTROLS SECTION   ******/
        $this->start_controls_section('navs_style_section',
            [
                'label'=> esc_html__( 'SLIDER NAV STYLE', 'styler' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [ 'nav' => 'yes' ]
            ]
        );
        $this->add_control( 'navs_size',
            [
                'label' => esc_html__( 'Size', 'styler' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => '',
                'selectors' => [ '{{WRAPPER}} .styler-swiper-theme-style .swiper-button-prev:after,{{WRAPPER}} .styler-swiper-theme-style .swiper-button-next:after' => 'font-size:{{SIZE}}px;' ]
            ]
        );
        $this->add_control( 'navs_color',
            [
                'label' => esc_html__( 'Color', 'styler' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .styler-swiper-theme-style .swiper-button-prev:after,{{WRAPPER}} .styler-swiper-theme-style .swiper-button-next:after' => 'color:{{VALUE}};' ]
            ]
        );
        $this->add_control( 'navs_hvrcolor',
            [
                'label' => esc_html__( 'Hover Color', 'styler' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => ['{{WRAPPER}} .styler-swiper-theme-style .swiper-button-prev:hover:after,{{WRAPPER}} .styler-swiper-theme-style .swiper-button-next:hover:after' => 'color:{{VALUE}};' ]
            ]
        );

        $this->end_controls_section();
        /*****   END CONTROLS SECTION   ******/
    }

    protected function render() {
        $settings   = $this->get_settings_for_display();
        $id = $this->get_id();

        $speed      = $settings['speed'] ? $settings['speed'] : 1000;
        $loop       = 'yes' == $settings['loop'] ? 'true' : 'false';
        $autoplay   = 'yes' == $settings['autoplay'] ? 'true' : 'false';
        $mousewheel = 'yes' == $settings['mousewheel'] ? 'true' : 'false';
        $is_edit    = \Elementor\Plugin::$instance->editor->is_edit_mode() ? '-'.$id : '';
        $slider_options = json_encode( array(
            "slidesPerView"  => 1,
            "loop"           => 'yes' == $settings['loop'] ? true: false,
            "autoplay"       => 'yes' == $settings['autoplay'] ? true: false,
            "mousewheel"     => 'yes' == $settings['mousewheel'] ? true: false,
            "releaseOnEdges" =>  true,
            "allowTouchMove" =>  true,
            "touchRatio"     =>  2,
            "speed"          => $settings['speed'],
            "spaceBetween"   => 0,
            "direction"      => "horizontal",
            "navigation"     => [
                "nextEl" => ".styler-swiper-theme-style .slide-next-{$id}",
                "prevEl" => ".styler-swiper-theme-style .slide-prev-{$id}"
            ],
            "pagination"    => [
                "el"        => ".styler-swiper-theme-style .styler-pagination-$id",
                "type"      => "bullets",
                "clickable" => true
            ]
        ));
        $durations = array();
        foreach ( $settings['durations'] as $item ) {
            if ( !empty( $item[ 'duration' ] ) ) {
                $durations[] = $item[ 'duration' ];
            }
        }
        $duration = !empty( $durations ) ? json_encode( $durations) : '';

        echo '<div class="slider-home-onepage'.$is_edit.' styler-swiper-theme-style styler-swiper-onepage-style">';
            echo '<div id="slider-'.$id.'" class="swiper-container parallax-slider-two" data-slider-settings=\''.$slider_options.'\' data-durations=\''.$duration.'\'>';
                echo '<div class="swiper-wrapper styler-template-slider-wrapper">';
                    if ( !empty( $settings[ 'content' ] ) && isset($settings[ 'content' ]) != '' ) {
                        $template = $settings[ 'content' ];
                        $content = new Frontend;
                        $css = ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) ? true : false;
                        echo $content->get_builder_content_for_display( $template, false );
                    }
                echo '</div>';
                if ( 'yes' == $settings[ 'dots' ] ) {
                    echo '<div class="swiper-pagination styler-swiper-pagination styler-pagination-'.$id.'"></div>';
                }
                if ( 'yes' == $settings['nav'] ) {
                    if ( is_rtl() ) {
                        echo '<div class="swiper-button-next slide-next-'.$id.'"></div>';
                        echo '<div class="swiper-button-prev slide-prev-'.$id.'"></div>';
                    } else {
                        echo '<div class="swiper-button-prev slide-prev-'.$id.'"></div>';
                        echo '<div class="swiper-button-next slide-next-'.$id.'"></div>';
                    }
                }
            echo '</div>';
        echo '</div>';

        if ( $duration ) {
            ?>
            <script>
            jQuery( document ).ready( function($) {

                var durations = $( '#slider-<?php echo $id ?>' ).data('durations');
                var slideItems = $( '#slider-<?php echo $id ?> .elementor-top-section' ).length;
                count = 0;
                $( '#slider-<?php echo $id ?> .elementor-top-section' ).each( function () {
                    if ( count <= slideItems  ) {
                        $( this ).attr( 'data-swiper-autoplay', durations[count] );
                    }
                    count = count + 1;
                });
            });
            </script>
            <?php
        }
        if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
            <script>
            jQuery( document ).ready( function($) {
                stylerSlider('.slider-home-onepage-<?php echo $id ?> .swiper-container');

                function stylerSlider(el) {

                    var self         = $( el ),
                        myPSlider    = self,
                        myInvisible  = self.find( '.elementor-invisible' ),
                        mySlide      = self.find( '.elementor-top-section' ),
                        myWrapper    = self.find( '.swiper-wrapper.styler-template-slider-wrapper' ),
                        myPage       = self.find( '[data-elementor-type="section"]' ),
                        myElSecId    = myPage.data('data-elementor-id'),
                        myPageClass  = myPage.attr( 'class' ),
                        myData       = self.data( 'slider-settings' ),
                        myParallaxSlider,
                        myVideoMuteYoutube,
                        myVideoMuteVimeo,
                        myVideoHtml,
                        windowWidth  = window.innerWidth;

                    var checkVideo = function() {
                        if ( self.hasClass('video-unmute') ) {
                            myVideoMuteYoutube = 'mute=0';
                            myVideoMuteVimeo   = 'muted=0';
                            myVideoHtml        = 'muted';
                        } else {
                            myVideoMuteYoutube = 'mute=1';
                            myVideoMuteVimeo   = 'muted=1';
                        }

                        mySlide.each( function () {
                            var $this = $( this );
                            $this.addClass( 'swiper-slide' ).prependTo( myWrapper );

                            $this.find( 'div[data-settings]').each(function () {
                                var $thiss = $( this );
                                var $anim = $thiss.data('settings');

                                if ( $anim._animation.length ) {
                                   $thiss.removeClass( 'elementor-invisible' );
                                }
                            });

                            var htmlVideo,
                                video          = $this.data('styler-bg-video'),
                                provider       = video ? video.provider : '',
                                videoId        = video ? video.video_id : '',
                                videoContainer = $this.find('.elementor-background-video-container'),
                                videoEl        = $this.find('.elementor-widget-video'),
                                videoElCont    = videoEl.find('.elementor-video'),
                                vSettings      = videoEl.data('settings'),
                                videoType      = vSettings ? vSettings.video_type : '',
                                videoUrl       = vSettings ? vSettings.youtube_url : '';

                            if ( videoEl.length ) {
                                if ( 'vimeo' == videoType ) {
                                    var videoIDParts = videoUrl.match(/^(?:https?:\/\/)?(?:www|player\.)?(?:vimeo\.com\/)?(?:video\/|external\/)?(\d+)([^.?&#"'>]?)/);
                                    htmlVideo = '<iframe class="elementor-background-embed-video vimeo-video" title="vimeo Video Player" src="https://player.vimeo.com/video/'+videoIDParts[1]+'?autoplay=1&loop=1&autopause=0&'+self.myVideoMuteVimeo+'" allow="autoplay; fullscreen" webkitallowfullscreen mozallowfullscreen allowfullscreen frameborder="0" data-ready="true" width="640" height="360"></iframe>';
                                }
                                if ( 'youtube' == videoType ) {
                                    var videoIDParts = videoUrl.match(/^(?:https?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?vi?=|(?:embed|v|vi|user)\/))([^?&"'>]+)/);
                                        htmlVideo    = '<iframe class="elementor-background-embed-video youtube-video" title="youtube Video Player" src="https://www.youtube.com/embed/'+videoIDParts[1]+'?controls=0&rel=0&autoplay=1&playsinline=1&enablejsapi=1&version=3&playerapiid=ytplayer&'+self.myVideoMuteYoutube+'" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" webkitallowfullscreen mozallowfullscreen allowfullscreen frameborder="0" width="640" height="360"></iframe>';
                                }
                                if ( 'hosted' == videoType ) {
                                    videoEl.find('video:first-child').remove();
                                    htmlVideo = '<video class="elementor-background-video-hosted elementor-html5-video video-hosted" autoplay '+self.myVideoHtml+' playsinline loop src="'+video.video_id+'"></video>';
                                }
                                videoElCont.prepend( htmlVideo );
                            }

                            if ( videoId.length ) {
                                videoContainer.find('div.elementor-background-video-embed').remove();
                                if ( 'vimeo' == provider ) {
                                    htmlVideo = '<iframe class="elementor-background-embed-video vimeo-video" title="vimeo Video Player" src="https://player.vimeo.com/video/'+video.video_id+'?autoplay=1&loop=1&autopause=0&'+self.myVideoMuteVimeo+'" allow="autoplay; fullscreen" webkitallowfullscreen mozallowfullscreen allowfullscreen frameborder="0" data-ready="true" width="640" height="360"></iframe>';
                                }
                                if ( 'youtube' == provider ) {
                                    htmlVideo = '<iframe class="elementor-background-embed-video youtube-video" title="youtube Video Player" src="https://www.youtube.com/embed/'+video.video_id+'?controls=0&rel=0&autoplay=1&playsinline=1&enablejsapi=1&version=3&playerapiid=ytplayer&'+self.myVideoMuteYoutube+'" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" webkitallowfullscreen mozallowfullscreen allowfullscreen frameborder="0" width="640" height="360"></iframe>';
                                }
                                if ( 'hosted' == provider ) {
                                    videoContainer.find('video:first-child').remove();
                                    htmlVideo = '<video class="elementor-background-video-hosted elementor-html5-video video-hosted" autoplay '+self.myVideoHtml+' playsinline loop src="'+video.video_id+'"></video>';
                                }
                                videoContainer.prepend( htmlVideo );
                            }
                        });
                    };

                    var createSlider = function() {

                        self.addClass( myPageClass );

                        checkVideo();

                        myPage.remove();

                        myData["on"] = {
                            init: function (swiper) {

                                setTimeout(function(){
                                    self.find( '.swiper-slide:not(:first-child)' ).each(function () {

                                        var iframe = $( this ).find('iframe');
                                        var vid = $( this ).find('.video-hosted');
                                        if ( iframe.length && iframe.hasClass('youtube-video') ) {
                                            iframe[0].contentWindow.postMessage('{"event":"command","func":"' + 'pauseVideo' + '","args":""}', '*');
                                        }
                                        if ( iframe.length && iframe.hasClass('vimeo-video') ) {
                                            iframe[0].contentWindow.postMessage('{"method":"pause"}', '*');
                                        }
                                        if ( vid.length ) {
                                            vid.get(0).pause();
                                        }
                                    });
                                }, 2000);
                            },
                            transitionEnd : function ( swiper ) {
                                var  active = swiper.realIndex;
                                $( '.swiper-slide:not([data-swiper-slide-index="'+active+'"])' ).find( 'div[data-settings]' ).each(function () {
                                    var $this    = $( this ),
                                        animData = $this.data('settings'),
                                        anim     = animData._animation;
                                    if ( 'undefined' === typeof animData._animation ) {
                                        anim = animData.animation;
                                    }

                                    $this.addClass( 'elementor-invisible' ).removeClass( 'animated ' + anim );

                                });
                            },
                            slideChange : function ( swiper ) {
                                var  active = swiper.realIndex;

                                $( '.swiper-slide[data-swiper-slide-index="'+active+'"]' ).find( 'div[data-settings]' ).each(function () {
                                    var $this    = $( this ),
                                        animData = $this.data( 'settings' ),
                                        anim     = animData._animation,
                                        delay    = animData._animation_delay;
                                    if ( 'undefined' === typeof animData._animation ) {
                                        anim = animData.animation;
                                    }
                                    setTimeout(function() {
                                        $this.addClass( 'animated ' + anim ).removeClass( 'elementor-invisible' );
                                    }, delay, $this);

                                });

                                $( '.swiper-slide:not(.swiper-slide-active)' ).each(function () {

                                    var iframe = $( this ).find('iframe');
                                    var vid    = $( this ).find('.video-hosted');
                                    if ( iframe.length && iframe.hasClass('youtube-video') ) {
                                        iframe[0].contentWindow.postMessage('{"event":"command","func":"' + 'pauseVideo' + '","args":""}', '*');
                                    }
                                    if ( iframe.length && iframe.hasClass('vimeo-video') ) {
                                        iframe[0].contentWindow.postMessage('{"method":"pause"}', '*');
                                    }
                                    if ( vid.length ) {
                                        vid.get(0).pause();
                                    }

                                });

                                $( '.swiper-slide-active' ).each(function () {

                                    var iframe2 = $( this ).find('iframe');
                                    var vid     = $( this ).find('.video-hosted');
                                    if ( iframe2.length && iframe2.hasClass('youtube-video') ) {
                                        iframe2[0].contentWindow.postMessage('{"event":"command","func":"' + 'playVideo' + '","args":""}', '*');
                                    }
                                    if ( iframe2.length && iframe2.hasClass('vimeo-video') ) {
                                        iframe2[0].contentWindow.postMessage('{"method":"play"}', '*');
                                    }
                                    if ( vid.length ) {
                                        vid.get(0).play();
                                    }
                                });

                            },
                            resize : function (swiper) {
                                swiper.update();
                            }
                        };
                        myParallaxSlider = new NTSwiper( el, myData );

                    };

                    createSlider();
                }
            });
            </script>
            <?php
        }
    }
}
