<?php

/**
 *
 * @package WordPress
 * @subpackage styler
 * @since Styler 1.0
 *
**/
define('STYLER_DIRECTORY_URI', get_template_directory_uri());
define('STYLER_DIRECTORY', get_template_directory());
update_option('envato_purchase_code_36501174','************************************');
$ninethemeOpt = get_option('styler');
/*************************************************
## GOOGLE FONTS
*************************************************/
if ( ! function_exists( 'styler_fonts_url' ) ) {
    function styler_fonts_url()
    {
        $fonts_url = '';
        $jost = _x( 'on', 'Jost font: on or off', 'styler' );

        if (  'off' !== $jost ) {

            $font_families = array();

            if ( 'off' !== $jost ) {
                $font_families[] = 'Jost:300,400,500,600,700';
            }

            $query_args = array(
                'family' => urlencode( implode( '|', $font_families ) ),
                'subset' => urlencode( 'latin,latin-ext' ),
                'display' => urlencode( 'swap' ),
            );

            $fonts_url = add_query_arg( $query_args, "//fonts.googleapis.com/css" );
        }

        return esc_url_raw( $fonts_url );
    }
}

/*************************************************
## STYLES AND SCRIPTS
*************************************************/

function styler_theme_scripts()
{
    $rtl = is_rtl() ? '-rtl' : '';
    // theme inner pages files

    // upload Google Webfonts
    wp_enqueue_style( 'styler-fonts', styler_fonts_url(), array(), null );

    // plugins
    wp_enqueue_style( 'fontawesome', STYLER_DIRECTORY_URI .'/css/fontawesome/fontawesome-all.min.css', false, '1.0' );

    if ( class_exists('Elementor\Plugin')) {

        $is_elementor = get_post_meta( get_the_ID(), '_elementor_edit_mode', true);

        $kit_id = \Elementor\Plugin::$instance->kits_manager->get_active_id();

        $kitcss_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
        ? new \Elementor\Core\Files\CSS\Post( $kit_id )
        : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $kit_id ) : null );

        $kitcss_file->enqueue();

        $footerId   = apply_filters( 'ninetheme_footer_elementor_template_id', styler_settings( 'footer_elementor_templates' ) );
        $footerId   = apply_filters( 'styler_translated_template_id', $footerId );
        $shopTemp1  = styler_settings( 'shop_before_loop_templates' );
        $shopTemp1  = apply_filters( 'styler_translated_template_id', $shopTemp1 );
        $shopTemp2  = styler_settings( 'shop_after_loop_templates' );
        $shopTemp2  = apply_filters( 'styler_translated_template_id', $shopTemp2 );

        if ( $footerId || $shopTemp1 || $shopTemp2 ) {
            wp_enqueue_style( 'font-awesome-5-all' );
            wp_enqueue_style( 'widget-image' );
            wp_enqueue_style( 'widget-icon-list' );
            wp_enqueue_style( 'widget-social-icons' );
            wp_enqueue_style( 'widget-heading' );
            wp_enqueue_style( 'e-apple-webkit' );
        }

        if ( class_exists( 'WooCommerce' ) && is_woocommerce() ) {
            if ( $shopTemp1 ) {
                $shopTemp1css_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
                ? new \Elementor\Core\Files\CSS\Post( $shopTemp1 )
                : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $shopTemp1 ) : null );

                $shopTemp1css_file->enqueue();
            }

            if ( $shopTemp2 ) {
                $shopTemp2css_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
                ? new \Elementor\Core\Files\CSS\Post( $shopTemp2 )
                : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $shopTemp2 ) : null );

                $shopTemp2css_file->enqueue();
            }
        }

        if ( $footerId ) {
            $footercss_file = class_exists( '\Elementor\Core\Files\CSS\Post' )
            ? new \Elementor\Core\Files\CSS\Post( $footerId )
            : ( class_exists( '\Elementor\Post_CSS_File' ) ? new \Elementor\Post_CSS_File( $footerId ) : null );

            if ( $footercss_file ) {
                $footercss_file->enqueue();
            }
        }
    }
    // bootstrap
    wp_enqueue_style( 'bootstrap-grid', STYLER_DIRECTORY_URI .'/css/bootstrap/bootstrap-grid'.$rtl.'.min.css', false, '1.0' );
    wp_enqueue_style( 'styler-default', STYLER_DIRECTORY_URI .'/css/default'.$rtl.'.css', false, '1.0' );
    // styler-framework-style
    wp_enqueue_style( 'styler-framework-style', STYLER_DIRECTORY_URI .'/css/framework-style'.$rtl.'.css', false, '1.0' );
    // styler-main-style
    wp_enqueue_style( 'styler-styles', STYLER_DIRECTORY_URI .'/css/style'.$rtl.'.css', false, '1.0' );

    if ( 'masonry' == apply_filters('styler_index_type', styler_settings( 'index_type', 'grid' ) ) ) {
        wp_enqueue_script( 'imagesloaded' );
        wp_enqueue_script( 'masonry' );
    }

    // lazy load
    if ( '1' == styler_settings( 'theme_lazyload_images', '1' ) ) {
        wp_enqueue_script( 'lazyload', STYLER_DIRECTORY_URI .'/js/lazy/lazyload.min.js', array('jquery'), '1.0', false );
        wp_enqueue_script( 'styler-lazyload', STYLER_DIRECTORY_URI .'/js/lazy/lazyload-script.js', array('jquery'), '1.0', false );
    }
    // nice-select
    wp_register_script('jquery-nice-select', STYLER_DIRECTORY_URI .'/js/nice-select/jquery-nice-select.min.js', array('jquery'), '1.0', true );
    // slick slider
    wp_enqueue_script('slick', STYLER_DIRECTORY_URI .'/js/slick/slick.min.js', array('jquery'), '1.0', true );
    // magnific
    wp_enqueue_script('magnific', STYLER_DIRECTORY_URI .'/js/magnific/magnific-popup.min.js', array('jquery'), '1.0', true );
    // swiper
    wp_register_script('styler-swiper', STYLER_DIRECTORY_URI .'/js/swiper/swiper-bundle.min.js', array('jquery'), '1.0', true );
    wp_enqueue_script('styler-swiper' );
    // jquery-cookie
    wp_register_script('jquery-cookie', STYLER_DIRECTORY_URI .'/js/jquery/jquery-cookie.min.js', array('jquery'), '1.0', true );
    // sliding-menu
    wp_enqueue_script('sliding-menu', STYLER_DIRECTORY_URI .'/js/sliding-menu/sliding-menu.js', array('jquery'), '1.0', true );
    // jquery-countdown
    wp_register_script('styler-countdown', STYLER_DIRECTORY_URI .'/js/countdown/script.js', array('jquery'), '1.0', true );

    wp_enqueue_script('styler-main', STYLER_DIRECTORY_URI .'/js/scripts.js', array('jquery'), '1.0', true );
    wp_enqueue_script('framework-settings', STYLER_DIRECTORY_URI .'/js/framework-settings.js', array('jquery'), '1.0', true );

    if ( class_exists( 'WooCommerce' ) ) {
        wp_register_style('owl-carousel', STYLER_DIRECTORY_URI .'/js/owl/owl.carousel.min.css',false, '1.0');
        wp_register_style('owl-theme-default', STYLER_DIRECTORY_URI .'/js/owl/owl.theme.default.min.css',false, '1.0');
        wp_register_script('owl-carousel', STYLER_DIRECTORY_URI .'/js/owl/owl.carousel.min.js', array('jquery'), '1.0', true );
        wp_register_script('flex-thumbs', STYLER_DIRECTORY_URI .'/js/owl/flex_thumbs.js', array('jquery'), '1.0', true );

        wp_register_style('fancybox', STYLER_DIRECTORY_URI .'/js/fancybox/jquery.fancybox.css', false, '1.0' );
        wp_register_script('fancybox', STYLER_DIRECTORY_URI .'/js/fancybox/jquery.fancybox.min.js', array(), '1.0', true );

        wp_register_style('free-shipping-progressbar', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/free-shipping-progressbar'.$rtl.'.css',false, '1.0');
        wp_enqueue_style('styler-wc', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/woocommerce-general'.$rtl.'.css',false, '1.0');

        if ( class_exists('WeDevs_Dokan') ) {
            wp_enqueue_style( 'styler-dokan', STYLER_DIRECTORY_URI. '/woocommerce/assets/css/dokan.css',false, '1.0');
        }
        if ( class_exists('WCFMmp') ) {
            wp_enqueue_style( 'styler-wcfm', STYLER_DIRECTORY_URI. '/woocommerce/assets/css/wcfm.css',false, '1.0');
        }

        wp_register_script('myaccount-multisteps', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/myaccount-multisteps.js', array('jquery'), '1.0', true );
        wp_register_script('checkout-multisteps', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/checkout-multisteps.js', array('jquery'), '1.0', true);
        wp_register_script('product-gallery-main', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/product-gallery-main.js', array('jquery'), '1.0', true);
        wp_register_script('product-gallery-carousel', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/product-gallery-carousel.js', array('jquery'), '1.0', true);
        wp_register_script('product-gallery-grid', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/product-gallery-grid.js', array('jquery'), '1.0', true);
        wp_enqueue_script('styler-wc', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/woocommerce-general.js', array('jquery'), '1.0', true);
        wp_register_style('styler-checkout-popup', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/checkout-ajax-popup.css',false, '1.0');
        wp_register_script('styler-checkout-popup', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/checkout-ajax-popup.js', array('jquery'), '1.0', true);
        wp_register_script('styler-panel-checkout', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/panel-checkout-form.js', array('jquery'), '1.0', true);

        wp_register_script('pjax', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/pjax.js', array('jquery'), '1.0', true );
        wp_register_script('shopAjaxFilter', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/shopAjaxFilter.js', array('jquery', 'pjax'), '1.0', true );
        wp_register_script('styler-infinite-scroll', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/infinite-scroll.js', array('jquery'), false, '1.0' );
        wp_register_script('styler-load-more', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/load_more.js', array('jquery'), false, '1.0' );
        wp_enqueue_script('styler-quantity-button', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/quantity_button.js', array('jquery'), '1.0.0', true );

        if ( '1' == styler_settings( 'ajax_addtocart', '1' ) && '0' == styler_settings( 'woo_catalog_mode', '1' ) ) {
            wp_enqueue_script('styler-ajax-addtocart', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/ajax-addtocart.js', array('jquery'), '1.0', true);
        }
        if ( '1' == styler_settings( 'quick_shop_visibility', '1' ) && '0' == styler_settings( 'woo_catalog_mode', '1' ) ) {
            wp_enqueue_style('styler-quick-shop', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/quick-shop'.$rtl.'.css',false, '1.0');
            wp_enqueue_script('styler-quick-shop', STYLER_DIRECTORY_URI .'/woocommerce/assets/js/quick-shop.js', array('jquery'), '1.0.0', true );
        }
        if ( '1' == styler_settings( 'quick_view_visibility', '1' ) ) {
            wp_enqueue_style('styler-quick-view', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/quick-view'.$rtl.'.css',false, '1.0');
        }
        if ( is_cart() ) {
            wp_enqueue_style('styler-cart-page', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/cart-page'.$rtl.'.css',false, '1.0');
        }
        if ( is_checkout() ) {
            wp_enqueue_style('styler-checkout-page', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/checkout-page'.$rtl.'.css',false, '1.0');
        }
        if ( is_account_page() ) {
            wp_enqueue_style('styler-myaccount-page', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/myaccount-page'.$rtl.'.css',false, '1.0');
        }
        if ( is_woocommerce() && 'no-sidebar' != styler_settings('shop_layout', 'left-sidebar') ) {
            wp_enqueue_style('styler-woo-sidebar', STYLER_DIRECTORY_URI .'/woocommerce/assets/css/sidebar'.$rtl.'.css',false, '1.0');
        }
    }

    if ( '1' == styler_settings( 'theme_blocks_styles', '0' ) ) {
        wp_dequeue_style( 'wp-block-library' );
        wp_deregister_style( 'wp-block-library' );

        // woocommerce
        wp_dequeue_style( 'woocommerce-inline' );
        wp_deregister_style( 'woocommerce-inline' );

        wp_dequeue_style( 'global-styles' );

        global $wp_styles;
        foreach ( $wp_styles->queue as $handle ) {
            if ( str_starts_with( $handle, 'wc-blocks' ) ) {
                wp_deregister_style( $handle );
                wp_dequeue_style( $handle );
            }
        }
    }

    // comment form reply
    if ( is_singular() ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'styler_theme_scripts' );

// preconnect theme fonts
function styler_resource_hints( $urls, $relation_type )
{
    if ( wp_style_is( 'styler-fonts', 'queue' ) && 'preconnect' === $relation_type ) {
        $urls[] = array(
            'href' => 'https://fonts.gstatic.com',
            'crossorigin'
        );
    }
    return $urls;
}
add_filter( 'wp_resource_hints', 'styler_resource_hints', 10, 2 );

if ( isset($ninethemeOpt['theme_blocks_styles']) && '1' == $ninethemeOpt['theme_blocks_styles'] ) {
    remove_theme_support( 'widgets-block-editor' );
    add_filter( 'use_widgets_block_editor', '__return_false' );
    add_filter('use_block_editor_for_post', '__return_false', 10);
    add_filter('use_block_editor_for_page', '__return_false', 10);
}


/*************************************************
## THEME SETUP
*************************************************/

if ( ! isset( $content_width ) ) {
    $content_width = 960;
}

function styler_theme_setup()
{
    /*
    * This theme styles the visual editor to resemble the theme style,
    * specifically font, colors, icons, and column width.
    */
    add_editor_style( 'custom-editor-style.css' );

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );
    add_image_size( 'styler-quickview', 60, 60, true );
    add_image_size( 'styler-panel', 80, 80, true );
    add_image_size( 'styler-mini', 300, 300, true );
    add_image_size( 'styler-medium', 370, 370, true );
    add_image_size( 'styler-square', 500, 500, true );
    add_image_size( 'styler-grid', 767, 767, true );
    /*
    * Enable support for Post Thumbnails on posts and pages.
    *
    * See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
    */
    add_theme_support( 'post-thumbnails' );

    // theme supports
    add_theme_support( 'title-tag' );
    add_theme_support( 'custom-background' );
    add_theme_support( 'custom-header' );
    add_theme_support( 'html5', array( 'search-form' ) );
    add_theme_support( 'admin-bar', array( 'callback' => '__return_false' ) );

    // Make theme available for translation
    // Translations can be filed in the /languages/ directory
    load_theme_textdomain( 'styler', STYLER_DIRECTORY . '/languages' );

    if ( is_admin() ) {
        include STYLER_DIRECTORY . '/inc/admin.php';
        // Theme admin menu
        require_once get_parent_theme_file_path( '/inc/core/merlin/admin-menu.php' );
        require_once get_parent_theme_file_path( '/inc/core/merlin/class-merlin.php' );
        require_once get_parent_theme_file_path( '/inc/core/demo-wizard-config.php' );
    }

    // Template-functions
    include STYLER_DIRECTORY . '/inc/template-functions.php';

    // Theme parts
    include STYLER_DIRECTORY . '/inc/template-parts/menu.php';
    include STYLER_DIRECTORY . '/inc/template-parts/post-formats.php';
    include STYLER_DIRECTORY . '/inc/template-parts/single-post-formats.php';
    include STYLER_DIRECTORY . '/inc/template-parts/paginations.php';
    include STYLER_DIRECTORY . '/inc/template-parts/comment-parts.php';
    include STYLER_DIRECTORY . '/inc/template-parts/small-parts.php';
    include STYLER_DIRECTORY . '/inc/template-parts/header-parts.php';
    include STYLER_DIRECTORY . '/inc/template-parts/footer-parts.php';
    include STYLER_DIRECTORY . '/inc/template-parts/page-hero.php';
    include STYLER_DIRECTORY . '/inc/template-parts/breadcrumbs.php';
    include STYLER_DIRECTORY . '/inc/template-parts/custom-style.php';

    if ( class_exists('Redux' ) ) {
        // Redux theme options panel
        include STYLER_DIRECTORY . '/inc/core/theme-options/options.php';

        $header_template = styler_settings( 'header_template', 'default' );
        if ( $header_template == 'sidebar' ) {
            register_nav_menus(array(
                'header_menu' => esc_html__( 'Sidebar Primary Menu', 'styler' ),
                'sidebar_second_menu' => esc_html__( 'Sidebar Second Menu', 'styler' ),
                'header_lang_menu' => esc_html__( 'Sidebar Lang Menu', 'styler' ),
                'mobile_bottom_menu' => esc_html__( 'Mobile Bottom Menu', 'styler' ),
            ));
        } else {
            register_nav_menus(array(
                'header_menu' => esc_html__( 'Header Menu', 'styler' ),
                'sidebar_menu' => esc_html__( 'Sidebar Menu', 'styler' ),
                'left_menu' => esc_html__( 'Left Menu ( for logo center )', 'styler' ),
                'rigt_menu' => esc_html__( 'Right Menu ( for logo center )', 'styler' ),
                'header_mini_menu' => esc_html__( 'Secondary Mini Menu', 'styler' ),
                'header_lang_menu' => esc_html__( 'Header Lang Menu', 'styler' ),
                'mobile_bottom_menu' => esc_html__( 'Mobile Bottom Menu', 'styler' ),
            ));
        }
    } else {
        register_nav_menus(array(
            'header_menu' => esc_html__( 'Header Menu', 'styler' )
        ) );
    }
}
add_action( 'after_setup_theme', 'styler_theme_setup' );

// WooCommerce init
if ( class_exists( 'WooCommerce' ) ) {
    include STYLER_DIRECTORY . '/woocommerce/init.php';
}

// disable srcset on frontend
if ( !function_exists('styler_disable_wp_responsive_images') ){
    function styler_disable_wp_responsive_images() {
        return 1;
    }
    add_filter('max_srcset_image_width', 'styler_disable_wp_responsive_images');
}


/*************************************************
## REMOVING CONTACT FORM 7 BR TAGS
*************************************************/
add_filter( 'wpcf7_autop_or_not', '__return_false' );


/*************************************************
## WIDGET COLUMNS
*************************************************/

function styler_widgets_init()
{
    register_sidebar(array(
        'name' => esc_html__( 'Blog Sidebar', 'styler' ),
        'id' => 'sidebar-1',
        'description' => esc_html__( 'These widgets for the Blog page.', 'styler' ),
        'before_widget' => '<div class="nt-sidebar-inner-widget widget blog-sidebar-widget mb-40 %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
        'after_title' => '</h5></div>'
    ));
    if ( class_exists( 'Redux' ) ) {
        if ( 'full-width' != styler_settings( 'styler_page_layout' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Default Page Sidebar', 'styler' ),
                'id' => 'styler-page-sidebar',
                'description' => esc_html__( 'These widgets for the Default Page pages.', 'styler' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget widget blog-sidebar-widget mb-40 %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
        if ( 'full-width' != styler_settings( 'archive_layout', 'full-width' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Archive Sidebar', 'styler' ),
                'id' => 'styler-archive-sidebar',
                'description' => esc_html__( 'These widgets for the Archive pages.', 'styler' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
        if ( 'full-width' != styler_settings( 'search_layout', 'full-width' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Search Sidebar', 'styler' ),
                'id' => 'styler-search-sidebar',
                'description' => esc_html__( 'These widgets for the Search pages.', 'styler' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
        if ( 'full-width' != styler_settings( 'single_layout', 'full-width' ) ) {
            register_sidebar(array(
                'name' => esc_html__( 'Blog Single Sidebar', 'styler' ),
                'id' => 'styler-single-sidebar',
                'description' => esc_html__( 'These widgets for the Blog single page.', 'styler' ),
                'before_widget' => '<div class="nt-sidebar-inner-widget widget blog-sidebar-widget mb-40 %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="nt-sidebar-inner-widget-title blog-sidebar-title"><h5>',
                'after_title' => '</h5></div>'
            ));
        }
    } // end if redux exists
} // end styler_widgets_init
add_action( 'widgets_init', 'styler_widgets_init' );

function styler_register_elementor_locations( $elementor_theme_manager ) {

    $elementor_theme_manager->register_location( 'header' );
    $elementor_theme_manager->register_location( 'footer' );
    $elementor_theme_manager->register_location( 'single' );
    $elementor_theme_manager->register_location( 'archive' );
}
add_action( 'elementor/theme/register_locations', 'styler_register_elementor_locations' );
