jQuery(document).ready(function($) {

    /*-- Strict mode enabled --*/
    'use strict';
    // countdown
    $('[data-countdown]').each(function () {
        var self      = $(this),
            data      = self.data('countdown'),
            countDate = data.date,
            expired   = data.expired,
            tday      = data.day,
            thour     = data.hour,
            tmin      = data.min,
            tsec      = data.sec;

        self.parents('.styler-summary-item').removeClass('loading');

        let countDownDate = new Date(countDate).getTime();

        const d  = self.find('.days .count');
        const h  = self.find('.hours .count');
        const m  = self.find('.minutes .count');
        const s  = self.find('.second .count');
        const dt = self.find('.days .text');
        const ht = self.find('.hours .text');
        const mt = self.find('.minutes .text');
        const st = self.find('.second .text');

        var x = setInterval(function() {

            var now = new Date().getTime();

            var distance = countDownDate - now;

            if (distance < 0) {
                clearInterval(x);
                self.parents('.styler-summary-item').addClass('expired');
                self.html('<div class="expired">' + expired + '</div>');
                return;
            }

            // Günleri hesapla (tam fark)
            var mdays = Math.floor(distance / (1000 * 60 * 60 * 24));
            var mhours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var mmins = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var msecs = Math.floor((distance % (1000 * 60)) / 1000);

            // Değerleri sıfır ekleyerek formatla
            var days  = mdays < 10 ? '0' + mdays : mdays;
            var hours = mhours < 10 ? '0' + mhours : mhours;
            var mins  = mmins < 10 ? '0' + mmins : mmins;
            var secs  = msecs < 10 ? '0' + msecs : msecs;

            // Ekrana yazdır
            d.text(days);
            h.text(hours);
            m.text(mins);
            s.text(secs);

            // Gün, saat, dakika ve saniyelerin çoğul veya tekil formunu seç
            dt.text(mdays < 10 ? tday[0] : tday[1]);
            ht.text(mhours < 10 ? thour[0] : thour[1]);
            mt.text(mmins < 10 ? tmin[0] : tmin[1]);
            st.text(msecs < 10 ? tsec[0] : tsec[1]);

        }, 1000);
    });
});
