<?php

if ( ! function_exists( 'cyberdom_core_add_404_page_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function cyberdom_core_add_404_page_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => CYBERDOM_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => '404',
				'icon'        => 'fa fa-book',
				'title'       => esc_html__( '404', 'cyberdom-core' ),
				'description' => esc_html__( 'Global 404 Page Options', 'cyberdom-core' ),
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_404_page_header_skin',
					'title'       => esc_html__( 'Header Skin', 'cyberdom-core' ),
					'description' => esc_html__( 'Choose a predefined header style for header elements', 'cyberdom-core' ),
					'options'     => array(
						'none'  => esc_html__( 'None', 'cyberdom-core' ),
						'light' => esc_html__( 'Light', 'cyberdom-core' ),
						'dark'  => esc_html__( 'Dark', 'cyberdom-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_404_page_title',
					'title'         => esc_html__( 'Enable Page Title', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable page title on 404 page', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_404_page_footer',
					'title'         => esc_html__( 'Enable Page Footer', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use this option to enable/disable page footer on 404 page', 'cyberdom-core' ),
					'default_value' => 'yes',
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_404_page_background_color',
					'title'       => esc_html__( 'Background Color', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter 404 page area background color', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_404_page_background_image',
					'title'       => esc_html__( 'Background Image', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter 404 page area background image', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_404_page_subtitle',
					'title'      => esc_html__( 'Subtitle Label', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_404_page_title',
					'title'      => esc_html__( 'Title Label', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_404_page_title_color',
					'title'      => esc_html__( 'Title Color', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_404_page_text',
					'title'      => esc_html__( 'Text Label', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_404_page_text_color',
					'title'      => esc_html__( 'Text Color', 'cyberdom-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_404_page_button_text',
					'title'      => esc_html__( 'Button Text', 'cyberdom-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'cyberdom_core_action_after_404_page_options_map', $page );
		}
	}

	add_action( 'cyberdom_core_action_default_options_init', 'cyberdom_core_add_404_page_options', cyberdom_core_get_admin_options_map_position( '404' ) );
}
