<?php
$blog_list_image                             = get_post_meta( get_the_ID(), 'qodef_blog_list_image', true );
$blog_list_bg_color                          = get_post_meta( get_the_ID(), 'qodef_masonry_background_color_post', true );
$blog_list_bg_gradient_color                 = get_post_meta( get_the_ID(), 'use_gradient_background_post', true );
$blog_list_bg_gradient_alternative_animation = get_post_meta( get_the_ID(), 'gradient_background_alternative_animation', true );
$has_image                                   = ! empty( $blog_list_image ) || has_post_thumbnail();
$image_holder_classes                        = array();
$styles                                      = array();

if ( $has_image ) {
	$image_dimension        = isset( $image_dimension ) && ! empty( $image_dimension ) && 'custom' !== $image_dimension ? esc_attr( $image_dimension['size'] ) : 'full';
	$image_url              = cyberdom_core_get_list_shortcode_item_image_url( $image_dimension, $blog_list_image );
	$styles[]               = ! empty( $image_url ) ? 'background-image: url( ' . esc_url( $image_url ) . ')' : '';
	$styles[]               = ! empty( $blog_list_bg_color ) ? 'background: ' . esc_html( $blog_list_bg_color ) : '';
	$image_holder_classes[] = 'qodef-e-media-image qodef--background';
	$image_holder_classes[] = ! empty( $blog_list_bg_gradient_color ) && 'yes' === $blog_list_bg_gradient_color ? 'qodef--gradient-bg' : '';
    $image_holder_classes[] = ! empty( $blog_list_bg_gradient_alternative_animation ) && 'yes' === $blog_list_bg_gradient_alternative_animation ? 'qodef--gradient-bg-alternative-animation' : '';
	?>
	<div <?php qode_framework_class_attribute( $image_holder_classes ); ?> <?php qode_framework_inline_style( $styles ); ?>>
		<?php echo cyberdom_core_get_list_shortcode_item_image( $image_dimension, $blog_list_image ); ?>
	</div>
<?php } ?>
