<?php

if ( ! function_exists( 'cyberdom_core_add_blog_list_variation_info_left' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function cyberdom_core_add_blog_list_variation_info_left( $variations ) {
		$variations['info-left'] = esc_html__( 'Info Left', 'cyberdom-core' );

		return $variations;
	}

	add_filter( 'cyberdom_core_filter_blog_list_layouts', 'cyberdom_core_add_blog_list_variation_info_left' );
}

if ( ! function_exists( 'cyberdom_core_add_blog_list_options_info_left' ) ) {
	/**
	 * Function that add additional options for variation layout
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	function cyberdom_core_add_blog_list_options_info_left( $options ) {
		$info_left_options   = array();
		$blog_badge_option        = array(
			'field_type'    => 'select',
			'name'          => 'info_left_show_blog_badge',
			'title'         => esc_html__( 'Show Blog Badge', 'cyberdom-core' ),
			'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
			'default_value' => 'no',
			'dependency' => array(
				'show' => array(
					'layout' => array(
						'values'        => 'info-left',
						'default_value' => '',
					),
				),
			),
			'group'      => esc_html__( 'Layout', 'cyberdom-core' ),
		);
		$info_left_options[] = $blog_badge_option;

		return array_merge( $options, $info_left_options );
	}

	add_filter( 'cyberdom_core_filter_blog_list_extra_options', 'cyberdom_core_add_blog_list_options_info_left' );
}
