<?php

if ( ! function_exists( 'cyberdom_core_add_general_page_meta_box' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function cyberdom_core_add_general_page_meta_box( $page ) {

		$general_tab = $page->add_tab_element(
			array(
				'name'        => 'tab-page',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Page Settings', 'cyberdom-core' ),
				'description' => esc_html__( 'General page layout settings', 'cyberdom-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_custom_css_class',
				'title'       => esc_html__( 'Page Custom CSS Class', 'cyberdom-core' ),
				'description' => esc_html__( 'Set custom CSS Class to body tag', 'trousseau-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_page_background_color',
				'title'       => esc_html__( 'Page Background Color', 'cyberdom-core' ),
				'description' => esc_html__( 'Set background color', 'cyberdom-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_page_background_image',
				'title'       => esc_html__( 'Page Background Image', 'cyberdom-core' ),
				'description' => esc_html__( 'Set background image', 'cyberdom-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_repeat',
				'title'       => esc_html__( 'Page Background Image Repeat', 'cyberdom-core' ),
				'description' => esc_html__( 'Set background image repeat', 'cyberdom-core' ),
				'options'     => array(
					''          => esc_html__( 'Default', 'cyberdom-core' ),
					'no-repeat' => esc_html__( 'No Repeat', 'cyberdom-core' ),
					'repeat'    => esc_html__( 'Repeat', 'cyberdom-core' ),
					'repeat-x'  => esc_html__( 'Repeat-x', 'cyberdom-core' ),
					'repeat-y'  => esc_html__( 'Repeat-y', 'cyberdom-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_size',
				'title'       => esc_html__( 'Page Background Image Size', 'cyberdom-core' ),
				'description' => esc_html__( 'Set background image size', 'cyberdom-core' ),
				'options'     => array(
					''        => esc_html__( 'Default', 'cyberdom-core' ),
					'contain' => esc_html__( 'Contain', 'cyberdom-core' ),
					'cover'   => esc_html__( 'Cover', 'cyberdom-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_attachment',
				'title'       => esc_html__( 'Page Background Image Attachment', 'cyberdom-core' ),
				'description' => esc_html__( 'Set background image attachment', 'cyberdom-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'cyberdom-core' ),
					'fixed'  => esc_html__( 'Fixed', 'cyberdom-core' ),
					'scroll' => esc_html__( 'Scroll', 'cyberdom-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding',
				'title'       => esc_html__( 'Page Content Padding', 'cyberdom-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'cyberdom-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding_mobile',
				'title'       => esc_html__( 'Page Content Padding Mobile', 'cyberdom-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'cyberdom-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed',
				'title'         => esc_html__( 'Boxed Layout', 'cyberdom-core' ),
				'description'   => esc_html__( 'Set boxed layout', 'cyberdom-core' ),
				'default_value' => '',
				'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$boxed_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_boxed_section',
				'title'      => esc_html__( 'Boxed Layout Section', 'cyberdom-core' ),
				'dependency' => array(
					'hide' => array(
						'qodef_boxed' => array(
							'values'        => 'no',
							'default_value' => '',
						),
					),
				),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed_disabled_680',
				'title'         => esc_html__( 'Disable Boxed Layout On Mobile', 'cyberdom-core' ),
				'default_value' => '',
				'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed_header_and_title_outside',
				'title'         => esc_html__( 'Force Fixed Header and Title Area outside the Boxed Layout', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes' ),
				'default_value' => '',
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed_footer_outside',
				'title'         => esc_html__( 'Force Footer outside the Boxed Layout', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes' ),
				'default_value' => '',
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_boxed_background_color',
				'title'       => esc_html__( 'Boxed Background Color', 'cyberdom-core' ),
				'description' => esc_html__( 'Set boxed background color', 'cyberdom-core' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_boxed_background_pattern',
				'title'       => esc_html__( 'Boxed Background Pattern', 'cyberdom-core' ),
				'description' => esc_html__( 'Set boxed background pattern', 'cyberdom-core' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_boxed_background_pattern_behavior',
				'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'cyberdom-core' ),
				'description' => esc_html__( 'Set boxed background pattern behavior', 'cyberdom-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'cyberdom-core' ),
					'fixed'   => esc_html__( 'Fixed', 'cyberdom-core' ),
					'scroll'  => esc_html__( 'Scroll', 'cyberdom-core' ),
					'unset'   => esc_html__( 'Unset', 'cyberdom-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_passepartout',
				'title'         => esc_html__( 'Passepartout', 'cyberdom-core' ),
				'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'cyberdom-core' ),
				'default_value' => '',
				'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$passepartout_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_passepartout_section',
				'dependency' => array(
					'hide' => array(
						'qodef_passepartout' => array(
							'values'        => 'no',
							'default_value' => '',
						),
					),
				),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_passepartout_color',
				'title'       => esc_html__( 'Passepartout Color', 'cyberdom-core' ),
				'description' => esc_html__( 'Choose background color for passepartout', 'cyberdom-core' ),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_passepartout_image',
				'title'       => esc_html__( 'Passepartout Background Image', 'cyberdom-core' ),
				'description' => esc_html__( 'Set background image for passepartout', 'cyberdom-core' ),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size',
				'title'       => esc_html__( 'Passepartout Size', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout', 'cyberdom-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'cyberdom-core' ),
				),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size_responsive',
				'title'       => esc_html__( 'Passepartout Responsive Size', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'cyberdom-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'cyberdom-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_content_width',
				'title'       => esc_html__( 'Initial Width of Content', 'cyberdom-core' ),
				'description' => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'cyberdom-core' ),
				'options'     => cyberdom_core_get_select_type_options_pool( 'content_width' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'yesno',
				'default_value' => 'no',
				'name'          => 'qodef_content_behind_header',
				'title'         => esc_html__( 'Always put content behind header', 'cyberdom-core' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'cyberdom-core' ),
			)
		);

		// Hook to include additional options after module options
		do_action( 'cyberdom_core_action_after_general_page_meta_box_map', $general_tab );
	}

	add_action( 'cyberdom_core_action_after_general_meta_box_map', 'cyberdom_core_add_general_page_meta_box', 9 );
}

if ( ! function_exists( 'cyberdom_core_add_general_page_meta_box_callback' ) ) {
	/**
	 * Function that set current meta box callback as general callback functions
	 *
	 * @param array $callbacks
	 *
	 * @return array
	 */
	function cyberdom_core_add_general_page_meta_box_callback( $callbacks ) {
		$callbacks['page'] = 'cyberdom_core_add_general_page_meta_box';

		return $callbacks;
	}

	add_filter( 'cyberdom_core_filter_general_meta_box_callbacks', 'cyberdom_core_add_general_page_meta_box_callback' );
}
