<?php

if ( ! function_exists( 'cyberdom_core_add_standard_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function cyberdom_core_add_standard_header_meta( $page ) {
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_standard_header_section',
				'title'      => esc_html__( 'Standard Header', 'cyberdom-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => array( '', 'standard' ),
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'cyberdom-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'cyberdom-core' ),
				'default_value' => '',
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height',
				'title'       => esc_html__( 'Header Height', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter header height', 'cyberdom-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'cyberdom-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'cyberdom-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'cyberdom-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter header background color', 'cyberdom-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter header border color', 'cyberdom-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter header border width size', 'cyberdom-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'cyberdom-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'cyberdom-core' ),
				'description' => esc_html__( 'Choose header border style', 'cyberdom-core' ),
				'options'     => cyberdom_core_get_select_type_options_pool( 'border_style' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_menu_position',
				'title'         => esc_html__( 'Menu position', 'cyberdom-core' ),
				'default_value' => '',
				'options'       => array(
					''       => esc_html__( 'Default', 'cyberdom-core' ),
					'left'   => esc_html__( 'Left', 'cyberdom-core' ),
					'center' => esc_html__( 'Center', 'cyberdom-core' ),
					'right'  => esc_html__( 'Right', 'cyberdom-core' ),
				),
			)
		);
	}

	add_action( 'cyberdom_core_action_after_page_header_meta_map', 'cyberdom_core_add_standard_header_meta' );
}
