(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_round_product_slider = {};
	qodefCore.shortcodes.cyberdom_core_round_product_slider.qodefSwiper = qodef.qodefSwiper;

	$( document ).ready(
		function () {
			qodefRoundProductSlider.init();
		}
	);

	var qodefRoundProductSlider = {
		init: function () {
			this.holder = $( '.qodef-woo-round-product-slider' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $thisHolder = $( this );

						qodefRoundProductSlider.initSwiper( $thisHolder );
						qodefRoundProductSlider.fullHeightSliderCalc( $thisHolder );

						$( window ).resize(
							function () {
								qodefRoundProductSlider.fullHeightSliderCalc( $thisHolder );
							}
						);
					}
				);
			}
		},
		initSwiper: function ( $holder ) {
			const swiperInstance = $holder[0].swiper,
				  $contents      = $holder.find('.qodef-woo-product-content-holder > .qodef-woo-product-content');

			$contents.eq(0).addClass('qodef--active');

			swiperInstance.on(
				'slideChangeTransitionStart', function () {
					$('.qodef--active').removeClass('qodef--active');
					$contents.eq(swiperInstance.realIndex).addClass('qodef--active');
				}
			)

			$holder.addClass('qodef--init');
		},
		fullHeightSliderCalc: function ( $holder ) {
			if ( $holder.hasClass( 'qodef-swiper-container' ) ) {
				var windowHeight = (window.innerHeight || document.documentElement.clientHeight);
				var headerHeight = 0;

				if ( ! qodef.body.hasClass( 'qodef-header--transparent' ) ) {
					headerHeight = qodefGlobal.vars.headerHeight;
				}

				if ( qodefCore.windowWidth > 1024 ) {
					var sliderHeight = windowHeight - headerHeight - qodefGlobal.vars.topAreaHeight - qodefGlobal.vars.adminBarHeight;
				} else if ( qodefCore.windowWidth <= 1024 && qodefCore.windowWidth > 768 ) {
					sliderHeight = windowHeight - qodefGlobal.vars.mobileHeaderHeight - qodefGlobal.vars.adminBarHeight;
				} else if ( qodefCore.windowWidth <= 768 ) {
					sliderHeight = (windowHeight - qodefGlobal.vars.mobileHeaderHeight - qodefGlobal.vars.adminBarHeight);
				}

				if ( qodefCore.body.hasClass( 'qodef--passepartout' ) ) {
					var passepartoutSize = parseInt( qodefCore.body.css( 'padding-top' ) );
					sliderHeight -= passepartoutSize;
				}

				$holder.height( sliderHeight );
			}
		}
	};

	qodefCore.shortcodes.cyberdom_core_round_product_slider.qodefRoundProductSlider = qodefRoundProductSlider;

})( jQuery );
