<div class="qodef-fixed-content-holder">
	<div class="qodef-social-icons-group">
		<?php
		// social icons group
		for ( $i = 1; $i <= $this_shortcode->no_of_icons; $i ++ ) {

			$selected_icon_pack = str_replace( '-', '_', ${"main_icon_{$i}"} );
			$is_textual_icon    = isset( ${"text_icon_{$i}"} ) && ! empty( ${"text_icon_{$i}"} );

			if ( $is_textual_icon ) {
				$textual_styles = array();

				if ( ! empty( ${"icon_color_{$i}"} ) ) {
					$textual_styles[] = 'color: ' . ${"icon_color_{$i}"};
				}

				if ( ! empty( ${"margin_{$i}"} ) ) {
					$textual_styles[] = 'margin: ' . ${"margin_{$i}"};
				}

				$textual_hover_styles = array();
				if ( ! empty( ${"icon_hover_color_{$i}"} ) ) {
					$textual_hover_styles[] = ${"icon_hover_color_{$i}"};
				}
				?>
				<span class="qodef-icon-holder qodef--textual" <?php qode_framework_inline_style( $textual_styles ); ?> <?php qode_framework_inline_attr( $textual_hover_styles, 'data-hover-color' ); ?>>
				<?php
				echo sprintf(
					'%s%s%s',
					! empty( ${"link_{$i}"} ) ? '<a itemprop="url" href="' . esc_url( ${"link_{$i}"} ) . '" target="' . esc_url( ${"target_{$i}"} ) . '">' : '',
					esc_html( ${"text_icon_{$i}"} ),
					! empty( ${"link_{$i}"} ) ? '</a>' : ''
				);
				?>
			</span>
				<?php
			} elseif ( ! empty( ${"main_icon_{$i}_{$selected_icon_pack}"} ) ) {
				$params = array(
					'main_icon'                        => ${"main_icon_{$i}"},
					'main_icon_' . $selected_icon_pack => ${"main_icon_{$i}_{$selected_icon_pack}"},
					'link'                             => ${"link_{$i}"},
					'target'                           => ${"target_{$i}"},
					'custom_size'                      => ${"custom_size_{$i}"},
					'margin'                           => ${"margin_{$i}"},
					'background_color'                 => ${"icon_background_color_{$i}"},
					'color'                            => ${"icon_color_{$i}"},
					'hover_background_color'           => ${"icon_hover_background_color_{$i}"},
					'hover_color'                      => ${"icon_hover_color_{$i}"},
					'icon_layout'                      => $icon_layout,
				);

				echo CyberdomCore_Icon_Shortcode::call_shortcode( $params ); // XSS OK
			}
		}
		?>
	</div>
	<?php
	// button
	if ( class_exists( 'CyberdomCore_Button_Shortcode' ) && ! empty( $button_text ) && ! empty( $button_link ) ) :
		$button_params = array(
			'button_layout'    => 'textual',
			'link'             => $button_link,
			'target'           => $button_target,
			'text'             => $button_text,
			'show_arrow'       => 'yes',
		);
		?>
		<div class="qodef-button-holder">
			<?php
			echo CyberdomCore_Button_Shortcode::call_shortcode( $button_params );
			?>
		</div>
	<?php
	endif; ?>
</div>
