<?php

if ( ! function_exists( 'cyberdom_core_add_portfolio_interactive_showcase_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_portfolio_interactive_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Portfolio_Interactive_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_portfolio_interactive_showcase_shortcode' );
}

if ( class_exists( 'CyberdomCore_List_Shortcode' ) ) {
	class CyberdomCore_Portfolio_Interactive_Showcase_Shortcode extends CyberdomCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'portfolio-item' );
			$this->set_post_type_taxonomy( 'portfolio-category' );
			$this->set_post_type_additional_taxonomies( array( 'portfolio-tag' ) );
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_portfolio_interactive_showcase_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_portfolio_interactive_showcase_extra_options', array() ) );
			$this->set_hover_animation_options( apply_filters( 'cyberdom_core_filter_portfolio_interactive_showcase_hover_animation_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_CPT_URL_PATH . '/portfolio/shortcodes/portfolio-interactive-showcase' );
			$this->set_base( 'cyberdom_core_portfolio_interactive_showcase' );
			$this->set_name( esc_html__( 'Portfolio Interactive Showcase', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of portfolios', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_scripts( apply_filters( 'cyberdom_core_filter_portfolio_interactive_showcase_register_assets', array() ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'cyberdom-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'cyberdom-core' ),
						'light' => esc_html__( 'Light', 'cyberdom-core' ),
					),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options(
				array(
					'layouts'          => $this->get_layouts(),
					'hover_animations' => $this->get_hover_animation_options(),
					'exclude_option' => array( 'title_tag', 'text_transform' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'read_more_text',
					'title'         => esc_html__( 'Read More Text', 'cyberdom-core' ),
					'default_value' => esc_html__('See More Moments', 'cyberdom-core'),
					'group'         => esc_html__( 'Layout', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'read_more_link',
					'title'         => esc_html__( 'Read More Link', 'cyberdom-core' ),
					'default_value' => '',
					'group'         => esc_html__( 'Layout', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'read_more_target',
					'title'         => esc_html__( 'Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'group'         => esc_html__( 'Layout', 'cyberdom-core' ),
				)
			);
			$this->map_additional_options(
				array(
					'exclude_filter'     => true,
					'exclude_pagination' => true,
				)
			);
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_portfolio_interactive_showcase', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			parent::load_assets();

			do_action( 'cyberdom_core_action_portfolio_interactive_showcase_load_assets', $this->get_atts() );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );

			// force atts
			$atts['behavior']           = 'columns';
			$atts['space']              = 'no'; // spacing inherited from widgets map
			$atts['images_proportion']  = 'full';
			$atts['columns']            = 1;
			$atts['columns_responsive'] = 'predefined';

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['query_result']   = new \WP_Query( cyberdom_core_get_query_params( $atts ) );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );
			$atts['data_attr']      = cyberdom_core_get_pagination_data( CYBERDOM_CORE_REL_PATH, 'post-types/portfolio/shortcodes', 'portfolio-interactive-showcase', 'portfolio', $atts );

			$atts['this_shortcode'] = $this;

			return cyberdom_core_get_template_part( 'post-types/portfolio/shortcodes/portfolio-interactive-showcase', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-portfolio-interactive-showcase';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';
			$holder_classes[] = ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';

			$list_classes            = $this->get_list_classes( $atts );
			$hover_animation_classes = $this->get_hover_animation_classes( $atts );
			$holder_classes          = array_merge( $holder_classes, $list_classes, $hover_animation_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}

		public function get_list_item_style( $atts ) {
			$styles = array();

			return $styles;
		}
	}
}
