(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefPortfolioInteractiveShowcaseInteractiveList.init();
		}
	);

	var qodefPortfolioInteractiveShowcaseInteractiveList = {
		init: function () {
			this.holder = $( '.qodef-portfolio-interactive-showcase.qodef-item-layout--interactive-list' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefPortfolioInteractiveShowcaseInteractiveList.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var $links            = $currentItem.find( '.qodef-e' ),
				x                 = 0,
				y                 = 0,
				currentXCPosition = 0,
				currentYCPosition = 0;

			if ( $links.length ) {
				$links.on(
					'mousemove',
					function ( event ) {
						var $thisLink         = $( this ),
							$itemTitle        = $thisLink.find( '.qodef-e-title'),
							itemTitleWidth    = $itemTitle.width(),
							$followInfoHolder = $thisLink.find( '.qodef-e-follow-content' ),
							$followImage      = $followInfoHolder.find( '.qodef-e-follow-image' ),
							$followImageItem  = $followImage.find( 'img' ),
							followImageWidth  = $followImageItem.width(),
							followImagesCount = parseInt( $followImage.data( 'images-count' ), 10 ),
							followImagesSrc   = $followImage.data( 'images' ),
							$followTitle      = $followInfoHolder.find( '.qodef-e-follow-title' ),
							itemWidth         = $thisLink.outerWidth(),
							itemHeight        = $thisLink.outerHeight(),
							itemOffsetTop     = $thisLink.offset().top - qodefCore.scroll,
							itemOffsetLeft    = $thisLink.offset().left;

						$links.removeClass( 'qodef--active' );
						$thisLink.addClass( 'qodef--active' );

						x = (event.clientX - itemOffsetLeft) >> 0;
						y = (event.clientY - itemOffsetTop) >> 0;

						if ( x > qodef.windowWidth - followImageWidth * 2 ) {
							currentXCPosition = qodef.windowWidth - followImageWidth * 2;
						} else if ( x < itemTitleWidth + followImageWidth ) {
							currentXCPosition = itemTitleWidth + followImageWidth;
						} else {
							currentXCPosition = x;
						}

						if ( y > itemHeight ) {
							currentYCPosition = itemHeight;
						} else if ( y < 0 ) {
							currentYCPosition = 0;
						} else {
							currentYCPosition = y;
						}

						if ( followImagesCount > 1 ) {
							var imagesUrl    = followImagesSrc.split( '|' ),
								itemPartSize = itemWidth / followImagesCount;

							$followImageItem.removeAttr( 'srcset' );

							if ( currentXCPosition < itemPartSize ) {
								$followImageItem.attr( 'src', imagesUrl[0] );
							}

							// -2 is constant - to remove first and last item from the loop
							for ( var index = 1; index <= (followImagesCount - 2); index++ ) {
								if ( currentXCPosition >= itemPartSize * index && currentXCPosition < itemPartSize * (index + 1) ) {
									$followImageItem.attr( 'src', imagesUrl[index] );
								}
							}

							if ( currentXCPosition >= itemWidth - itemPartSize ) {
								$followImageItem.attr( 'src', imagesUrl[followImagesCount - 1] );
							}
						}
						$followTitle.css(
							{
								'transform': 'translateY(' + -(parseInt( itemHeight, 10 ) / 2 + currentYCPosition) + 'px)',
								'left': -(currentXCPosition - followImageWidth / 2),
							}
						);
					}
				).on(
					'mouseleave',
					function () {
						$links.removeClass( 'qodef--active' );
					}
				);
			}

			$currentItem.addClass( 'qodef--init' );
		},
	};

	qodefCore.shortcodes.cyberdom_core_portfolio_interactive_showcase.qodefPortfolioInteractiveShowcaseInteractiveList = qodefPortfolioInteractiveShowcaseInteractiveList;

})( jQuery );
