(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_portfolio_list = {};

	$( window ).on(
		'load',
		() => {
			qodefPortfolioList.init();
		}
	);

	const qodefPortfolioList = {
		init () {
			this.portfolio = $('.qodef-portfolio-list');

			if ( this.portfolio.length ) {
				this.portfolio.each(
					( index, element ) => {
						const $thisPortfolioList = $( element );

						qodefPortfolioList.linkHover( $thisPortfolioList );
					}
				);
			}
		},
		linkHover ( $holder ) {
			const $items = $holder.find('.qodef-e');

			$items.each(
				( index, element ) => {
					const $thisItem = $( element ),
						  $itemMedia = $thisItem.find('.qodef-e-media-image > a'),
						  $titleLink = $thisItem.find('.qodef-e-title-link');

					if ( $itemMedia.length ) {
						$itemMedia.on(
							'mouseenter',
							() => {
								$thisItem.addClass('qodef--active');
							}
						);

						$itemMedia.on(
							'mouseleave',
							() => {
								$thisItem.removeClass('qodef--active');
							}
						);
					}

					if ( $titleLink.length ) {
						$titleLink.on(
							'mouseenter',
							() => {
								$thisItem.addClass('qodef--active');
							}
						);

						$titleLink.on(
							'mouseleave',
							() => {
								$thisItem.removeClass('qodef--active');
							}
						);
					}
				}
			);
		}
	};

	qodefCore.shortcodes.cyberdom_core_portfolio_list.qodefPortfolioList = qodefPortfolioList;

})( jQuery );
