<?php
$post_id       = get_the_ID();
$is_enabled    = cyberdom_core_get_post_value_through_levels( 'qodef_portfolio_single_enable_related_posts' );
$related_posts = cyberdom_core_get_custom_post_type_related_posts( $post_id, cyberdom_core_get_portfolio_single_post_taxonomies( $post_id ) );

if ( 'yes' === $is_enabled && ! empty( $related_posts ) && class_exists( 'CyberdomCore_Portfolio_List_Shortcode' ) ) { ?>
	<div id="qodef-portfolio-single-related-items">
		<h3 class="qodef-related-portfolio-label">
			<?php
				esc_html_e('You May Also Like', 'cyberdom-core')
			?>
		</h3>
		<?php
		$params = apply_filters(
			'cyberdom_core_filter_portfolio_single_related_posts_params',
			array(
				'custom_class'      => 'qodef--no-bottom-space',
				'columns'           => '4',
				'posts_per_page'    => 4,
				'additional_params' => 'id',
				'space'             => 'medium',
				'post_ids'          => $related_posts['items'],
				'layout'            => 'info-below',
				'title_tag'         => 'h4',
				'excerpt_length'    => '30',
			)
		);

		echo CyberdomCore_Portfolio_List_Shortcode::call_shortcode( $params );
		?>
	</div>
<?php } ?>
