<?php

if ( ! function_exists( 'cyberdom_core_add_button_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_button_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Button_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_button_shortcode', 9 );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Button_Shortcode extends CyberdomCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_button_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_button_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/button' );
			$this->set_base( 'cyberdom_core_button' );
			$this->set_name( esc_html__( 'Button', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays button with provided parameters', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);

			$options_map = cyberdom_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'use_gradient_background',
					'title'         => esc_html__( 'Use Gradient Color', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use Gradient Color for the background', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency' => array(
						'hide' => array(
							'button_layout' => array(
								'values'        => array( 'outlined' ),
								'default_value' => 'filled',
							),
						),
					),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'hidden',
					'name'          => 'popup_link_data',
					'title'         => esc_html__( 'Popup Link Data', 'cyberdom-core' ),
					'description'   => esc_html__( 'Prints data markup for popup link', 'cyberdom-core' ),
					'default_value' => 'no',
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_layout',
					'title'         => esc_html__( 'Layout', 'cyberdom-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array(
						'map_for_page_builder' => $options_map['visibility'],
						'map_for_widget'       => $options_map['visibility'],
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_arrow',
					'title'      => esc_html__( 'Show Arrow', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency' => array(
						'hide' => array(
							'button_layout' => array(
								'values'        => array( 'circle' ),
								'default_value' => 'filled',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'underline_text',
					'title'      => esc_html__( 'Text Underline', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency' => array(
						'show' => array(
							'button_layout' => array(
								'values'        => array( 'textual' ),
								'default_value' => 'filled',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'size',
					'title'      => esc_html__( 'Size', 'cyberdom-core' ),
					'options'    => array(
						''      => esc_html__( 'Normal', 'cyberdom-core' ),
						'small' => esc_html__( 'Small', 'cyberdom-core' ),
						'large' => esc_html__( 'Large', 'cyberdom-core' ),
						'full'  => esc_html__( 'Normal Full Width', 'cyberdom-core' ),
					),
					'dependency' => array(
						'hide' => array(
							'button_layout' => array(
								'values'        => array( 'textual', 'circle' ),
								'default_value' => 'filled',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'text',
					'title'         => esc_html__( 'Button Text', 'cyberdom-core' ),
					'default_value' => esc_html__( 'Button Text', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Button Link', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'color',
					'title'      => esc_html__( 'Text Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'name'       => 'hover_color',
					'field_type' => 'color',
					'title'      => esc_html__( 'Text Hover Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'background_color',
					'title'      => esc_html__( 'Background Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'hover_background_color',
					'title'      => esc_html__( 'Background Hover Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'border_color',
					'title'      => esc_html__( 'Border Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'hover_border_color',
					'title'      => esc_html__( 'Border Hover Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'margin',
					'title'      => esc_html__( 'Margin', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'padding',
					'title'      => esc_html__( 'Padding', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'arrow_margin',
					'title'      => esc_html__( 'Arrow Margin', 'cyberdom-core' ),
					'group'      => esc_html__( 'Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'font_size',
					'title'      => esc_html__( 'Font Size', 'cyberdom-core' ),
					'group'      => esc_html__( 'Typography Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'font_line_height',
					'title'      => esc_html__( 'Line Height', 'cyberdom-core' ),
					'group'      => esc_html__( 'Typography Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'arrow_size',
					'title'      => esc_html__( 'Arrow Size', 'cyberdom-core' ),
					'group'      => esc_html__( 'Typography Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'font_weight',
					'title'      => esc_html__( 'Font Weight', 'cyberdom-core' ),
					'options'    => cyberdom_core_get_select_type_options_pool( 'font_weight' ),
					'group'      => esc_html__( 'Typography Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'text_transform',
					'title'      => esc_html__( 'Text Transform', 'cyberdom-core' ),
					'options'    => cyberdom_core_get_select_type_options_pool( 'text_transform' ),
					'group'      => esc_html__( 'Typography Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'html_type',
					'title'         => esc_html__( 'HTML Type', 'cyberdom-core' ),
					'options'       => array(
						'default' => esc_html__( 'Default', 'cyberdom-core' ),
						'input'   => esc_html__( 'Input', 'cyberdom-core' ),
						'submit'  => esc_html__( 'Submit', 'cyberdom-core' ),
					),
					'default_value' => 'default',
					'visibility'    => array(
						'map_for_page_builder' => false,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'input_name',
					'title'      => esc_html__( 'Input Name', 'cyberdom-core' ),
					'visibility' => array(
						'map_for_page_builder' => false,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'array',
					'name'       => 'custom_attrs',
					'title'      => esc_html__( 'Custom Data Attributes', 'cyberdom-core' ),
					'visibility' => array(
						'map_for_page_builder' => false,
					),
				)
			);
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_button', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {

			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['data_attrs']     = $this->get_data_attrs( $atts );
			$atts['styles']         = $this->get_styles( $atts );
			$atts['arrow_styles']         = $this->get_arrow_styles( $atts );
			$atts['text']           = $this->get_modified_text( $atts );

			return cyberdom_core_get_template_part( 'shortcodes/button', 'variations/' . $atts['button_layout'] . '/templates/' . $atts['html_type'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-button';
			$holder_classes[] = ! empty( $atts['button_layout'] ) ? 'qodef-layout--' . $atts['button_layout'] : '';
			$holder_classes[] = ! empty( $atts['size'] ) ? 'qodef-size--' . $atts['size'] : '';
			$holder_classes[] = 'yes' === $atts['disable_text_break_words'] ? 'qodef-text-break--disabled' : '';
			$holder_classes[] = 'yes' === $atts['use_gradient_background'] ? 'qodef-use-gradient-bg--yes' : '';
			$holder_classes[] = 'yes' === $atts['show_arrow'] ? 'qodef-show-arrow--yes' : '';
			$holder_classes[] = 'yes' === $atts['underline_text'] ? 'qodef-text-underline' : '';
			$holder_classes[] = 'default' === $atts['html_type'] ? 'qodef-html--link' : '';
			$holder_classes[] = ! empty( $atts['text_align'] ) ? 'qodef-text-align--' . $atts['text_align'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_data_attrs( $atts ) {
			$data = array();
			if ( ! empty( $atts['popup_link_data'] ) && 'yes' === $atts['popup_link_data'] ) {
				$data['data-type'] = 'iframe';
			}

			if ( ! empty( $atts['hover_color'] ) ) {
				$data['data-hover-color'] = $atts['hover_color'];
			}

			if ( ! empty( $atts['hover_background_color'] ) ) {
				$data['data-hover-background-color'] = $atts['hover_background_color'];
			}

			if ( ! empty( $atts['hover_border_color'] ) ) {
				$data['data-hover-border-color'] = $atts['hover_border_color'];
			}

			if ( ! empty( $atts['custom_attrs'] ) && is_array( $atts['custom_attrs'] ) ) {
				$data = array_merge( $data, $atts['custom_attrs'] );
			}

			return $data;
		}

		//get_arrow_styles
		private function get_arrow_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['arrow_size'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['font_size'] ) ) {
					$styles[] = 'width: ' . $atts['arrow_size'];
					$styles[] = 'height: ' . $atts['arrow_size'];
				} else {
					$styles[] = 'width: ' . intval( $atts['arrow_size'] ) . 'px';
					$styles[] = ' height: ' . intval( $atts['arrow_size'] ) . 'px';
				}
			}

			if ( '' !== $atts['arrow_margin'] ) {
				$styles[] = 'margin: ' . $atts['arrow_margin'];
			}

			return $styles;
		}

		private function get_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['color'] ) ) {
				$styles[] = 'color: ' . $atts['color'];
			}

			if ( ! empty( $atts['background_color'] ) && 'outlined' !== $atts['button_layout'] && 'textual' !== $atts['button_layout'] ) {
				$styles[] = 'background-color: ' . $atts['background_color'];
			}

			if ( ! empty( $atts['border_color'] ) && 'textual' !== $atts['button_layout'] ) {
				$styles[] = 'border-color: ' . $atts['border_color'];
			}

			if ( ! empty( $atts['font_size'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['font_size'] ) ) {
					$styles[] = 'font-size: ' . $atts['font_size'];
				} else {
					$styles[] = 'font-size: ' . intval( $atts['font_size'] ) . 'px';
				}
			}

			if ( ! empty( $atts['font_line_height'] ) ) {
				if ( qode_framework_string_ends_with_typography_units( $atts['font_line_height'] ) ) {
					$styles[] = 'line-height: ' . $atts['font_line_height'];
				} else {
					$styles[] = 'line-height: ' . intval( $atts['font_line_height'] ) . 'px';
				}
			}

			if ( ! empty( $atts['font_weight'] ) ) {
				$styles[] = 'font-weight: ' . $atts['font_weight'];
			}

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			if ( '' !== $atts['margin'] ) {
				$styles[] = 'margin: ' . $atts['margin'];
			}

			if ( '' !== $atts['padding'] ) {
				$styles[] = 'padding: ' . $atts['padding'];
			}

			return $styles;
		}

		private function get_modified_text( $atts ) {
			$title = $atts['text'];

			if ( ! empty( $title ) && ! empty( $atts['line_break_positions'] ) ) {
				$split_title          = explode( ' ', $title );
				$line_break_positions = explode( ',', str_replace( ' ', '', $atts['line_break_positions'] ) );

				foreach ( $line_break_positions as $position ) {
					$position = intval( $position );
					if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
						$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
					}
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}
	}
}
