<?php

if ( ! function_exists( 'cyberdom_core_add_circular_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param $shortcodes array
	 *
	 * @return array
	 */
	function cyberdom_core_add_circular_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Circular_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_circular_slider_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Circular_Slider_Shortcode extends CyberdomCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_circular_slider_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_circular_slider_extra_options', array() ) );

			parent::__construct();
		}

		public $no_of_icons = 5;

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/circular-slider' );
			$this->set_base( 'cyberdom_core_circular_slider' );
			$this->set_name( esc_html__( 'Circular Slider', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds circular slider element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
			) );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'use_gradient_background',
					'title'         => esc_html__( 'Use Gradient Color', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use Gradient Color for the background', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option( array(
				'field_type' => 'repeater',
				'name'       => 'children',
				'title'      => esc_html__( 'Child elements', 'cyberdom-core' ),
				'items'      => array(
					array(
						'field_type' => 'image',
						'name'       => 'item_image',
						'title'      => esc_html__( 'Image', 'cyberdom-core' )
					),
					array(
						'field_type' => 'color',
						'name'       => 'item_color',
						'title'      => esc_html__( 'Background Color', 'cyberdom-core' )
					),
					array(
						'field_type' => 'text',
						'name'       => 'item_title',
						'title'      => esc_html__( 'Title', 'cyberdom-core' ),
					),
					array(
						'field_type'    => 'text',
						'name'          => 'item_subtitle',
						'title'         => esc_html__( 'Subtitle', 'cyberdom-core' ),
					),
					array(
						'field_type'    => 'textarea',
						'name'          => 'item_text',
						'title'         => esc_html__( 'Text', 'cyberdom-core' ),
					),
					array(
						'field_type'    => 'text',
						'name'          => 'item_app_store_link',
						'title'         => esc_html__( 'App Store Link', 'cyberdom-core' ),
						'default_value' => ''
					),
					array(
						'field_type'    => 'text',
						'name'          => 'item_google_play_link',
						'title'         => esc_html__( 'Google Play Link', 'cyberdom-core' ),
						'default_value' => ''
					),
				)
			) );
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_text',
					'title'         => esc_html__( 'Button Text', 'cyberdom-core' ),
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_link',
					'title'         => esc_html__( 'Button Link', 'cyberdom-core' ),
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_target',
					'title'         => esc_html__( 'Button Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'icon_layout',
					'title'         => esc_html__( 'Icons Layout', 'cyberdom-core' ),
					'options'       => array(
						'normal'  => esc_html__( 'Normal', 'cyberdom-core' ),
						'circle'  => esc_html__( 'Circle', 'cyberdom-core' ),
						'square'  => esc_html__( 'Square', 'cyberdom-core' ),
						'textual' => esc_html__( 'Textual', 'cyberdom-core' ),
					),
					'default_value' => 'normal',
					'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				)
			);
			for ( $i = 1; $i <= $this->no_of_icons; $i ++ ) {
				$this->set_option(
					array(
						'field_type' => 'iconpack',
						'name'       => 'main_icon_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'text_icon_' . $i,
						'title'      => sprintf( esc_html__( 'Text Icon %s', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'show' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'link_' . $i,
						'title'      => sprintf( esc_html__( 'Link %s', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type'    => 'select',
						'name'          => 'target_' . $i,
						'title'         => sprintf( esc_html__( 'Link %s Target', 'cyberdom-core' ), $i ),
						'options'       => cyberdom_core_get_select_type_options_pool( 'link_target', false ),
						'default_value' => '_blank',
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'custom_size_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Size', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'text',
						'name'       => 'margin_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Margin', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Color', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_background_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Background Color', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_hover_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Hover Color', 'cyberdom-core' ), $i ),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
				$this->set_option(
					array(
						'field_type' => 'color',
						'name'       => 'icon_hover_background_color_' . $i,
						'title'      => sprintf( esc_html__( 'Icon %s Hover Background Color', 'cyberdom-core' ), $i ),
						'dependency' => array(
							'hide' => array(
								'icon_layout' => array(
									'values'        => 'textual',
									'default_value' => 'normal',
								),
							),
						),
						'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					)
				);
			}
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'locations',
					'title'      => esc_html__( 'Locations Info', 'cyberdom-core' ),
					'group'      => esc_html__( 'Fixed Content', 'cyberdom-core' ),
					'items'      => array(
						array(
							'field_type'    => 'text',
							'name'          => 'location',
							'title'         => esc_html__( 'Location', 'cyberdom-core' ),
						),
					),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['locations']      = $this->parse_repeater_items( $atts['locations'] );
			$atts['this_shortcode'] = $this;

			return cyberdom_core_get_template_part( 'shortcodes/circular-slider', 'templates/circular-slider', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-circular-slider-holder swiper-container-horizontal';
			$holder_classes[] = ! empty( $atts['use_gradient_background'] ) ? 'qodef-use-gradient-bg--' . $atts['use_gradient_background'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
