<div <?php qode_framework_class_attribute( $holder_classes ); ?>>
    <div class="qodef-m-items">
        <div class="qodef-m-swiper">
            <div class="swiper-wrapper">
				<?php foreach ( $items as $item ) :
					$style = array();
					if ( isset( $item['item_color'] ) && ! empty( $item['item_color'] ) ) {
						$style[] = 'background-color: ' . $item['item_color'];
					}
					?>
                    <div class="qodef-m-item swiper-slide" <?php qode_framework_inline_style( $style ); ?>>
	                    <div class="qodef-m-slide-content">
		                    <div class="qodef-m-image-holder">
			                    <?php echo wp_get_attachment_image( $item['item_image'], 'full' ); ?>
		                    </div>
		                    <div class="qodef-m-content">
			                    <?php if ( isset( $item['item_subtitle'] ) && ! empty( $item['item_subtitle'] ) ) { ?>
                                    <div class="qodef-m-subtitle-holder">
                                        <span class="qodef-m-subtitle">
                                            <?php echo esc_html( $item['item_subtitle'] ); ?>
                                        </span>
                                    </div>
			                    <?php } ?>
			                    <?php if ( isset( $item['item_title'] ) && ! empty( $item['item_title'] ) ) { ?>
                                    <div class="qodef-e-text-holder">
				                        <h1 class="qodef-e-text"><?php echo wp_kses_post( $item['item_title'] ); ?></h1>
                                    </div>
			                    <?php } ?>
			                    <?php if ( isset( $item['item_text'] ) && ! empty( $item['item_text'] ) ) { ?>
                                    <div class="qodef-e-item-text-holder">
                                        <p class="qodef-e-item-text">
                                            <?php echo esc_html( $item['item_text'] ); ?>
                                        </p>
                                    </div>
			                    <?php } ?>
			                    <?php if ( ! empty( $item['item_app_store_link'] ) || ! empty( $item['item_google_play_link'] ) ) : ?>
			                        <div class="qodef-buttons-holder">
				                        <?php if ( ! empty( $item['item_app_store_link'] ) ) : ?>
					                        <a href="<?php echo esc_url( $item['item_app_store_link'] ); ?>" target="_blank" class="qodef-app-store-btn">
						                        <?php cyberdom_core_render_svg_icon( 'app-store-btn', '' ); ?>
					                        </a>
				                        <?php endif; ?>

				                        <?php if ( ! empty( $item['item_google_play_link'] ) ) : ?>
					                        <a href="<?php echo esc_url( $item['item_google_play_link'] ); ?>" target="_blank" class="qodef-google-play-btn">
						                        <?php cyberdom_core_render_svg_icon( 'google-play-btn', '' ); ?>
					                        </a>
				                        <?php endif; ?>
			                        </div>
								<?php
			                    endif; ?>
		                    </div>
	                    </div>
                    </div>
				<?php endforeach; ?>
            </div><!-- .swiper-wrapper -->
        </div><!-- .qodef-m-swiper -->
    </div><!-- .qodef-m-items -->
    <div class="swiper-pagination"></div>

	<?php if ( ! empty( $button_text ) && ! empty( $button_link ) ) : ?>
		<div class="qodef-fixed-content-holder">

			<?php
			// button
			if ( class_exists( 'CyberdomCore_Button_Shortcode' ) && ! empty( $button_text ) && ! empty( $button_link ) ) :
			$button_params = array(
				'button_layout'    => 'textual',
				'link'             => $button_link,
				'target'           => $button_target,
				'text'             => $button_text,
				'show_arrow'       => 'yes',
			);
			?>
			<div class="qodef-button-holder">
			<?php
				echo CyberdomCore_Button_Shortcode::call_shortcode( $button_params );
			?>
			</div>
			<div class="qodef-social-icons-group">
			<?php
			// social icons group
			for ( $i = 1; $i <= $this_shortcode->no_of_icons; $i ++ ) {

				$selected_icon_pack = str_replace( '-', '_', ${"main_icon_{$i}"} );
				$is_textual_icon    = isset( ${"text_icon_{$i}"} ) && ! empty( ${"text_icon_{$i}"} );

				if ( $is_textual_icon ) {
					$textual_styles = array();

					if ( ! empty( ${"icon_color_{$i}"} ) ) {
						$textual_styles[] = 'color: ' . ${"icon_color_{$i}"};
					}

					if ( ! empty( ${"margin_{$i}"} ) ) {
						$textual_styles[] = 'margin: ' . ${"margin_{$i}"};
					}

					$textual_hover_styles = array();
					if ( ! empty( ${"icon_hover_color_{$i}"} ) ) {
						$textual_hover_styles[] = ${"icon_hover_color_{$i}"};
					}
					?>
					<span class="qodef-icon-holder qodef--textual" <?php qode_framework_inline_style( $textual_styles ); ?> <?php qode_framework_inline_attr( $textual_hover_styles, 'data-hover-color' ); ?>>
						<?php
						echo sprintf(
							'%s%s%s',
							! empty( ${"link_{$i}"} ) ? '<a itemprop="url" href="' . esc_url( ${"link_{$i}"} ) . '" target="' . esc_url( ${"target_{$i}"} ) . '">' : '',
							esc_html( ${"text_icon_{$i}"} ),
							! empty( ${"link_{$i}"} ) ? '</a>' : ''
						);
						?>
					</span>
					<?php
				} elseif ( ! empty( ${"main_icon_{$i}_{$selected_icon_pack}"} ) ) {
					$params = array(
						'main_icon'                        => ${"main_icon_{$i}"},
						'main_icon_' . $selected_icon_pack => ${"main_icon_{$i}_{$selected_icon_pack}"},
						'link'                             => ${"link_{$i}"},
						'target'                           => ${"target_{$i}"},
						'custom_size'                      => ${"custom_size_{$i}"},
						'margin'                           => ${"margin_{$i}"},
						'background_color'                 => ${"icon_background_color_{$i}"},
						'color'                            => ${"icon_color_{$i}"},
						'hover_background_color'           => ${"icon_hover_background_color_{$i}"},
						'hover_color'                      => ${"icon_hover_color_{$i}"},
						'icon_layout'                      => $icon_layout,
					);

					echo CyberdomCore_Icon_Shortcode::call_shortcode( $params ); // XSS OK
				}
			}
			?>
			</div>

			<?php
			// Locations
			if ( ! empty( $locations ) ) { ?>
			<div class="qodef-m-loactions-info-holder">
				<?php cyberdom_core_render_svg_icon( 'globe', 'qodef-m-globe-icon' ); ?>
				<?php foreach ( $locations as $location ) { ?>
					<div class="qodef-m-loaction-item">
						<p class="qodef-m-text">
							<?php echo esc_html( $location['location'] ); ?>
						</p>
					</div>
					<?php
				}
				?>
			</div>
			<?php } ?>

			<?php

			endif; ?>

		</div>
	<?php
	endif; ?>

</div>
