<?php

if ( ! function_exists( 'cyberdom_core_add_divided_showcase_section_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_divided_showcase_section_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Divided_Showcase_Section_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_divided_showcase_section_shortcode' );
}

class CyberdomCore_Divided_Showcase_Section_Shortcode extends CyberdomCore_List_Shortcode {

	public function map_shortcode() {
		$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/divided-showcase-section' );
		$this->set_base( 'cyberdom_core_divided_showcase_section' );
		$this->set_name( esc_html__( 'Divided Showcase Section', 'cyberdom-core' ) );
		$this->set_description( esc_html__( 'Shortcode that shows list of apartment items', 'cyberdom-core' ) );
		$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
		$this->set_scripts(
			array(
				'jquery-magnific-popup' => array(
					'registered' => true,
				),
			)
		);
		$this->set_necessary_styles(
			array(
				'magnific-popup' => array(
					'registered' => true,
				),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'behavior',
				'title'         => esc_html__( 'List Appearance', 'cyberdom-core' ),
				'options'       => array(
					'slider' => esc_html__( 'Slider', 'cyberdom-core' ),
				),
				'default_value' => 'slider',
			)
		);
		$this->set_option(
			array(
				'field_type' => 'select',
				'name'       => 'slider_loop',
				'title'      => esc_html__( 'Enable Slider Loop', 'cyberdom-core' ),
				'options'    => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
			)
		);
		$this->set_option(
			array(
				'field_type' => 'select',
				'name'       => 'slider_autoplay',
				'title'      => esc_html__( 'Enable Slider Autoplay', 'cyberdom-core' ),
				'options'    => cyberdom_core_get_select_type_options_pool( 'yes_no' ),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'text',
				'name'        => 'slider_speed',
				'title'       => esc_html__( 'Slide Duration', 'cyberdom-core' ),
				'description' => esc_html__( 'Default value is 5000 (ms)', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'text',
				'name'          => 'title',
				'title'         => esc_html__( 'Fixed Area Title', 'cyberdom-core' ),
				'default_value' => esc_html__( 'Reality or Not?', 'cyberdom-core' ),
				'dependency' => array(
					'show' => array(
						'behavior' => array(
							'values'        => 'slider',
							'default_value' => '',
						),
					),
				),
				'group'      => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type' => 'text',
				'name'       => 'subtitle',
				'title'      => esc_html__( 'Fixed Area Subtitle', 'cyberdom-core' ),
				'default_value' => esc_html__( 'Hello world', 'cyberdom-core' ),
				'dependency' => array(
					'show' => array(
						'behavior' => array(
							'values'        => 'slider',
							'default_value' => '',
						),
					),
				),
				'group'      => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'text',
				'name'        => 'line_break_positions',
				'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'show_question_mark',
				'title'         => esc_html__( 'Show Question Mark', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
				'default_value' => 'no',
				'description'   => esc_html__( 'Enabling this option will show superscript question mark only after first line break)', 'cyberdom-core' ),
				'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'disable_title_break_words',
				'title'         => esc_html__( 'Disable Title Line Break', 'cyberdom-core' ),
				'description'   => esc_html__( 'Enabling this option will disable title line breaks for screen size 1024 and lower', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
				'default_value' => 'no',
				'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'text',
				'name'        => 'button_text',
				'title'       => esc_html__( 'Button Text', 'cyberdom-core' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'text',
				'name'        => 'button_link',
				'title'       => esc_html__( 'Button Link', 'cyberdom-core' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'select',
				'name'        => 'button_link_target',
				'title'       => esc_html__( 'Button Target', 'cyberdom-core' ),
				'options'     => cyberdom_core_get_select_type_options_pool( 'link_target' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);


		$this->set_option(
			array(
				'field_type'  => 'text',
				'name'        => 'circle_button_text',
				'title'       => esc_html__( 'Circle Button Text', 'cyberdom-core' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'circle_button_link_behavior',
				'title'         => esc_html__( 'Circle Button Behavior', 'cyberdom-core' ),
				'options'       => array(
					'open-popup'  => esc_html__( 'Open Popup', 'cyberdom-core' ),
					'custom-link' => esc_html__( 'Custom Link', 'cyberdom-core' ),
				),
				'default_value' => 'open-popup',
				'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'text',
				'name'          => 'circle_button_link',
				'title'         => esc_html__( 'Circle Button Link', 'cyberdom-core' ),
				'default_value' => '#',
				'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'select',
				'name'        => 'circle_button_link_target',
				'title'       => esc_html__( 'Circle Button Target', 'cyberdom-core' ),
				'options'     => cyberdom_core_get_select_type_options_pool( 'link_target' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				'dependency'  => array(
					'show' => array(
						'circle_button_link_behavior' => array(
							'values'        => 'custom-link',
							'default_value' => 'open-popup',
						),
					),
				),
			)
		);
		$this->set_option(
			array(
				'field_type'  => 'text',
				'name'        => 'circle_line_break_positions',
				'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
				'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break for circle button. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
				'group'       => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'circle_disable_text_break_words',
				'title'         => esc_html__( 'Disable Text Line Break', 'cyberdom-core' ),
				'description'   => esc_html__( 'Enabling this option will disable text line breaks for screen size 1024 and lower for circle button', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
				'default_value' => 'no',
				'group'         => esc_html__( 'Fixed Content', 'cyberdom-core' ),
			)
		);
		$this->set_option(
			array(
				'field_type' => 'repeater',
				'name'       => 'locations',
				'title'      => esc_html__( 'Locations Info', 'cyberdom-core' ),
				'group'      => esc_html__( 'Fixed Content', 'cyberdom-core' ),
				'items'      => array(
					array(
						'field_type'    => 'text',
						'name'          => 'location',
						'title'         => esc_html__( 'Location', 'cyberdom-core' ),
					),
				),
			)
		);
		$this->set_option(
			array(
				'field_type'    => 'select',
				'name'          => 'use_gradient_background',
				'title'         => esc_html__( 'Use Gradient Color', 'cyberdom-core' ),
				'description'   => esc_html__( 'Use Gradient Color for the background', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
				'default_value' => 'yes',
				'group'         => esc_html__( 'Slider Content', 'cyberdom-core' ),
			)
		);
        $this->set_option(
            array(
                'field_type'    => 'select',
                'name'          => 'enable_appear_animation',
                'title'         => esc_html__( 'Enable Appear Animation', 'cyberdom-core' ),
                'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
                'default_value' => 'no',
                'group'         => esc_html__( 'Animation Options', 'cyberdom-core' )
            )
        );
		$this->set_option(
			array(
				'field_type' => 'repeater',
				'name'       => 'children',
				'title'      => esc_html__( 'Slider Images', 'cyberdom-core' ),
				'dependency' => array(
					'show' => array(
						'behavior' => array(
							'values'        => 'slider',
							'default_value' => '',
						),
					),
				),
				'group'      => esc_html__( 'Slider Content', 'cyberdom-core' ),
				'items'      => array(
					array(
						'field_type'    => 'image',
						'name'          => 'slider_image',
						'title'         => esc_html__( 'Slider Image', 'cyberdom-core' ),
					),
				),
			)
		);
		$this->map_additional_options(
			array(
				'exclude_filter'     => true,
				'exclude_pagination' => true,
			)
		);
		$this->map_extra_options();
	}

	public static function call_shortcode( $params ) {
		$html = qode_framework_call_shortcode( 'cyberdom_core_divided_showcase_section', $params );
		$html = str_replace( "\n", '', $html );

		return $html;
	}

	public function load_assets() {
		$atts = $this->get_atts();

		if ( isset( $atts['circle_button_link_behavior'] ) && 'open-popup' === $atts['circle_button_link_behavior'] ) {
			wp_enqueue_style( 'magnific-popup' );
			wp_enqueue_script( 'jquery-magnific-popup' );
		}
	}

	public function render( $options, $content = null ) {
		parent::render( $options );

		$atts = $this->get_atts();

		$atts['layout']            = 'gallery';
		$atts['slider_pagination'] = 'yes';
		$atts['slider_navigation'] = 'no';

		if ( 'slider' === $atts['behavior'] ) {
			$atts['columns'] = 1;
			$atts['columns_responsive'] = 'custom';
			$atts['columns_1440'] = 1;
			$atts['columns_1366'] = 1;
			$atts['columns_1280'] = 1;
			$atts['columns_1024'] = 1;
			$atts['columns_768'] = 1;
			$atts['columns_680'] = 1;
			$atts['columns_480'] = 1;
		}

		$atts['holder_classes']         = $this->get_holder_classes( $atts );
		$atts['slider_attr']            = $this->get_slider_data( $atts );
		$atts['item_classes']           = $this->get_item_classes( $atts );
		$atts['holder_wrapper_classes'] = $this->get_holder_wrapper_classes( $atts );
		$atts['title']                  = $this->get_modified_title( $atts );
		$atts['locations']              = $this->parse_repeater_items( $atts['locations'] );
		$atts['items']                  = $this->parse_repeater_items( $atts['children'] );

		$atts['this_shortcode'] = $this;

		return cyberdom_core_get_template_part( 'shortcodes/divided-showcase-section', 'templates/content', $atts['behavior'], $atts );
	}

	private function get_holder_classes( $atts ) {
		$holder_classes = $this->init_holder_classes();

		$holder_classes[] = 'qodef-divided-showcase-section';
		$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';

        $list_classes            = $this->get_list_classes( $atts );
		$hover_animation_classes = $this->get_hover_animation_classes( $atts );
		$holder_classes          = array_merge( $holder_classes, $list_classes, $hover_animation_classes );

		return implode( ' ', $holder_classes );
	}

	public function get_item_classes( $atts ) {
		$item_classes   = $this->init_item_classes();
		$item_classes[] = 'qodef-image-wrapper';

		$list_item_classes = $this->get_list_item_classes( $atts );

		$item_classes = array_merge( $item_classes, $list_item_classes );

		return implode( ' ', $item_classes );
	}

	private function get_holder_wrapper_classes( $atts ) {
		$holder_wrapper_classes[] = 'qodef-divided-showcase-section';
		$holder_wrapper_classes[] = ! empty( $atts['behavior'] ) ? 'qodef-behavior--' . $atts['behavior'] : '';
		$holder_wrapper_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';
		$holder_wrapper_classes[] = 'yes' === $atts['use_gradient_background'] ? 'qodef-use-gradient-bg--yes' : '';
        $holder_wrapper_classes[] = ! empty( $atts['enable_appear_animation'] ) ? 'qodef-appear-animation--' . $atts['enable_appear_animation'] : '';

		return implode( ' ', $holder_wrapper_classes );
	}

	public function get_title_styles( $atts ) {
		$styles = array();

		if ( ! empty( $atts['text_transform'] ) ) {
			$styles[] = 'text-transform: ' . $atts['text_transform'];
		}

		return $styles;
	}

	private function get_modified_title( $atts ) {
		$title              = $atts['title'];
		$show_question_mark = $atts['show_question_mark'];

		if ( ! empty( $title ) && ! empty( $atts['line_break_positions'] ) ) {
			$split_title          = explode( ' ', $title );
			$line_break_positions = explode( ',', str_replace( ' ', '', $atts['line_break_positions'] ) );

			$i = 1;
			foreach ( $line_break_positions as $position ) {

				// Question mark check
				if ( 1 === $i && 'yes' === $show_question_mark ) {
					$question_mark = '<sup>' . esc_html__( '?', 'cyberdom-core' ) . '</sup>';
				} else {
					$question_mark = '';
				}

				$position = intval( $position );
				if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
					$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . $question_mark . '<br />';
				}
			$i++;
			}

			$title = implode( ' ', $split_title );
		}

		return $title;
	}
}
