(function ( $ ) {
    'use strict';

    qodefCore.shortcodes.cyberdom_core_info_section = {};

    $( window ).on(
        'load',
        () => {
            qodefInfoSection.init();
        }
    );

    const qodefInfoSection = {
        init () {
            this.shortcode = $('.qodef-info-section');

            if ( this.shortcode.length ) {
                this.shortcode.each(
                    ( index, element ) => {
                        const $thisShortcode = $( element );

                        if ( $thisShortcode.hasClass('qodef-appear-animation--yes') ) {
                            qodefInfoSection.appearAnimation( $thisShortcode );
                        }
                    }
                );
            }
        },
        appearAnimation ( $holder ) {
            qodefCore.qodefIsInViewport.check(
                $holder,
                () => {
                    $holder.addClass('qodef--appeared');
                }
            );
        }
    };

    qodefCore.shortcodes.cyberdom_core_info_section.qodefInfoSection = qodefInfoSection;

})( jQuery );
