<?php

if ( ! function_exists( 'cyberdom_core_add_section_title_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_section_title_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Section_Title_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_section_title_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Section_Title_Shortcode extends CyberdomCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/section-title' );
			$this->set_base( 'cyberdom_core_section_title' );
			$this->set_name( esc_html__( 'Section Title', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds section title element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'subtitle',
					'title'         => esc_html__( 'Subtitle', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle_margin_bottom',
					'title'      => esc_html__( 'Subtitle Margin Bottom', 'cyberdom-core' ),
					'group'      => esc_html__( 'Subtitle Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'title_line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
					'group'       => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_title_break_words',
					'title'         => esc_html__( 'Disable Title Line Break', 'cyberdom-core' ),
					'description'   => esc_html__( 'Enabling this option will disable title line breaks for screen size 1024 and lower', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Title Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Title Custom Link', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
					'dependency'    => array(
						'show' => array(
							'image_action' => array(
								'values'        => 'custom-link',
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'description',
					'title'         => esc_html__( 'Text', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_bottom',
					'title'      => esc_html__( 'Text Margin Bottom', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_max_width',
					'title'      => esc_html__( 'Text Max Width', 'cyberdom-core' ),
					'group'      => esc_html__( 'Text Style', 'cyberdom-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'cyberdom-core' ),
					'options'    => array(
						''       => esc_html__( 'Default', 'cyberdom-core' ),
						'left'   => esc_html__( 'Left', 'cyberdom-core' ),
						'center' => esc_html__( 'Center', 'cyberdom-core' ),
						'right'  => esc_html__( 'Right', 'cyberdom-core' ),
					),
				)
			);
			$this->import_shortcode_options(
				array(
					'shortcode_base'    => 'cyberdom_core_button',
					'exclude'           => array( 'custom_class' ),
					'additional_params' => array(
						'nested_group' => esc_html__( 'Button', 'cyberdom-core' ),
					),
				)
			);
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'enable_appear_animation',
                    'title'         => esc_html__( 'Enable Appear Animation', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
                    'default_value' => 'no',
                    'group'         => esc_html__( 'Animation Options', 'cyberdom-core' )
                )
            );
            $this->set_option(
                array(
                    'field_type'    => 'select',
                    'name'          => 'wait_for_trigger',
                    'title'         => esc_html__( 'Wait For Trigger', 'cyberdom-core' ),
                    'description'   => esc_html__( 'Enabling this option will delay appear animation until external trigger is activated', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'yes_no', false ),
                    'default_value' => 'no',
                    'dependency'    => array(
                        'show' => array(
                            'enable_appear_animation' => array(
                                'values'        => 'yes',
                                'default_value' => 'no',
                            ),
                        ),
                    ),
                    'group'         => esc_html__( 'Animation Options', 'cyberdom-core' ),
                )
            );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']         = $this->get_holder_classes( $atts );
			$atts['title']                  = $this->get_modified_title( $atts );
			$atts['title_styles']           = $this->get_title_styles( $atts );
			$atts['button_params']          = $this->generate_button_params( $atts );
            $atts['subtitle_holder_styles'] = $this->get_subtitle_holder_styles( $atts );
            $atts['text_holder_styles']     = $this->get_text_holder_styles( $atts );
			$atts['subtitle_styles']        = $this->get_subtitle_styles( $atts );
			$atts['text_styles']            = $this->get_text_styles( $atts );

			return cyberdom_core_get_template_part( 'shortcodes/section-title', 'templates/section-title', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-section-title';
			$holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
			$holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';
            $holder_classes[] = ! empty( $atts['enable_appear_animation'] ) ? 'qodef-appear-animation--' . $atts['enable_appear_animation'] : '';
            $holder_classes[] = ! empty( $atts['wait_for_trigger'] ) && 'yes' === $atts['wait_for_trigger'] ? 'qodef-wait-for-trigger' : '';

			return implode( ' ', $holder_classes );
		}

		private function generate_button_params( $atts ) {
			$params = $this->populate_imported_shortcode_atts(
				array(
					'shortcode_base' => 'cyberdom_core_button',
					'exclude'        => array( 'custom_class' ),
					'atts'           => $atts,
				)
			);

			return $params;
		}

		private function get_modified_title( $atts ) {
			$title = $atts['title'];

			if ( ! empty( $title ) && ! empty( $atts['title_line_break_positions'] ) ) {
				$split_title          = explode( ' ', $title );
				$line_break_positions = explode( ',', str_replace( ' ', '', $atts['title_line_break_positions'] ) );

				foreach ( $line_break_positions as $position ) {
					$position = intval( $position );
					if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
						$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
					}
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			return $styles;
		}

        private function get_subtitle_holder_styles( $atts ) {
            $styles = array();

            if ( '' !== $atts['subtitle_margin_bottom'] ) {
                if ( qode_framework_string_ends_with_space_units( $atts['subtitle_margin_bottom'] ) ) {
                    $styles[] = 'margin-bottom: ' . $atts['subtitle_margin_bottom'];
                } else {
                    $styles[] = 'margin-bottom: ' . intval( $atts['subtitle_margin_bottom'] ) . 'px';
                }
            }

	        if ( ! empty( $atts['subtitle_color'] ) ) {
		        $styles[] = 'color: ' . $atts['subtitle_color'];
	        }

            return $styles;
        }

		private function get_subtitle_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['subtitle_color'] ) ) {
				$styles[] = 'color: ' . $atts['subtitle_color'];
			}

			return $styles;
		}

        private function get_text_holder_styles( $atts ) {
	        $styles = array();

	        if ( ! empty( $atts['text_color'] ) ) {
		        $styles[] = 'color: ' . $atts['text_color'];
	        }

	        if ( ! empty( $atts['text_max_width'] ) ) {
		        $styles[] = 'max-width: ' . $atts['text_max_width'];
	        }

	        if ( ! empty( $atts['text_margin_top'] ) ) {
		        $styles[] = 'margin-top: ' . $atts['text_margin_top'];
	        }

	        if ( ! empty( $atts['text_margin_bottom'] ) ) {
		        $styles[] = 'margin-bottom: ' . $atts['text_margin_bottom'];
	        }

	        return $styles;
        }

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}
	}
}
