<?php

if ( ! function_exists( 'cyberdom_core_add_team_single_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_team_single_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCoreTeamSingleShortcode';
		
		return $shortcodes;
	}
	
	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_team_single_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCoreTeamSingleShortcode extends CyberdomCore_Shortcode {
		
		public function __construct() {
			$this->set_layouts( apply_filters( 'cyberdom_core_filter_team_single_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'cyberdom_core_filter_team_single_extra_options', array() ) );
			
			parent::__construct();
		}
		
		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/team-single' );
			$this->set_base( 'cyberdom_core_team_single' );
			$this->set_name( esc_html__( 'Team Single', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds team single element', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
			) );
			
			$options_map = cyberdom_core_get_variations_options_map( $this->get_layouts() );
			
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'layout',
				'title'         => esc_html__( 'Layout', 'cyberdom-core' ),
				'options'		=> $this->get_layouts(),
				'default_value' => $options_map['default_value'],
				'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] )
			) );
			$this->set_option( array(
				'field_type' => 'image',
				'name'       => 'image',
				'title'      => esc_html__( 'Team Single Image', 'cyberdom-core' ),
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'image_size',
				'title'      => esc_html__( 'Image Size', 'cyberdom-core' ),
				'description'=> esc_html__( 'For predefined image sizes input thumbnail, medium, large or full. If you wish to set a custom image size, type in the desired image dimensions in pixels (e.g. 400x400).', 'cyberdom-core' ),
			) );
            $this->set_option( array(
                'field_type'    => 'select',
                'name'          => 'image_shadow',
                'title'         => esc_html__( 'Image Shadow', 'cyberdom-core' ),
                'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes' ),
                'default_value' => 'no',
            ) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'image_action',
				'title'         => esc_html__( 'Image Action', 'cyberdom-core' ),
				'options'       => array(
					''            => esc_html__( 'No Action', 'cyberdom-core' ),
					'open-popup'  => esc_html__( 'Open Popup', 'cyberdom-core' ),
					'custom-link' => esc_html__( 'Custom Link', 'cyberdom-core' )
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'link',
				'title'      => esc_html__( 'Custom Link', 'cyberdom-core' ),
				'dependency' => array(
					'show' => array(
						'image_action' => array(
							'values'        => 'custom-link',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'target',
				'title'         => esc_html__( 'Custom Link Target', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'link_target' ),
				'default_value' => '_self',
				'dependency' => array(
					'show' => array(
						'image_action' => array(
							'values'        => 'custom-link',
							'default_value' => ''
						)
					)
				)
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'title',
				'title'      => esc_html__( 'Name', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'title_tag',
				'title'         => esc_html__( 'Name Tag', 'cyberdom-core' ),
				'options'       => cyberdom_core_get_select_type_options_pool( 'title_tag' ),
				'default_value' => 'h4',
				'group'         => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'title_color',
				'title'      => esc_html__( 'Name Color', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'title_margin_top',
				'title'      => esc_html__( 'Name Margin Top', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'textarea',
				'name'       => 'text',
				'title'      => esc_html__( 'Text', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
            $this->set_option( array(
                'field_type'    => 'select',
                'name'          => 'text_tag',
                'title'         => esc_html__( 'Text Tag', 'cyberdom-core' ),
                'options'       => cyberdom_core_get_select_type_options_pool( 'title_tag', true, array('h1', 'h2', 'h3', 'h4', 'h5', 'h6'), array( 'span' => esc_attr__( 'SPAN', 'cyberdom-core' ) ) ),
                'default_value' => 'p',
                'group'         => esc_html__( 'Content', 'cyberdom-core' )
            ) );
			$this->set_option( array(
				'field_type' => 'color',
				'name'       => 'text_color',
				'title'      => esc_html__( 'Text Color', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'text_margin_top',
				'title'      => esc_html__( 'Text Margin Top', 'cyberdom-core' ),
				'group'      => esc_html__( 'Content', 'cyberdom-core' )
			) );
            $this->set_option( array(
                'field_type' => 'text',
                'name'       => 'link',
                'title'      => esc_html__( 'Link', 'cyberdom-core' ),
                'group'      => esc_html__( 'Content', 'cyberdom-core' )
            ) );
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Social Items', 'cyberdom-core' ),
					'items'      => array(
						array(
							'field_type' => 'text',
							'name'       => 'social_item_text',
							'title'      => esc_html__( 'Social Text', 'cyberdom-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'social_item_link',
							'title'      => esc_html__( 'Link', 'cyberdom-core' ),
						),
						array(
							'field_type' => 'select',
							'name'       => 'social_item_link_target',
							'title'      => esc_html__( 'Link Target', 'cyberdom-core' ),
							'options'    => cyberdom_core_get_select_type_options_pool( 'link_target', false ),
						),
					),
				)
			);
			$this->map_extra_options();
		}
		
		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'cyberdom_core_team_single', $params );
			$html = str_replace( "\n", '', $html );
			
			return $html;
		}
		
		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();
			
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
			$atts['image_params']   = $this->generate_image_params( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return cyberdom_core_get_template_part( 'shortcodes/team-single', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}
		
		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();
			
			$holder_classes[] = 'qodef-team-single';
			$holder_classes[] = ! empty ( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
            $holder_classes[] = $atts['image_shadow'] === 'yes' ? 'qodef-image-has-shadow' : '';
			
			return implode( ' ', $holder_classes );
		}
		
		private function get_title_styles( $atts ) {
			$styles = array();
			
			if ( $atts['title_margin_top'] !== '' ) {
				if ( qode_framework_string_ends_with_space_units( $atts['title_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['title_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['title_margin_top'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}
			
			return $styles;
		}
		
		private function get_text_styles( $atts ) {
			$styles = array();
			
			if ( $atts['text_margin_top'] !== '' ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}
			
			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}
			
			return $styles;
		}
		
		private function generate_image_params( $atts ) {
			$image = array();
			
			if ( ! empty( $atts['image'] ) ) {
				$id = $atts['image'];
				
				$image['image_id'] = intval( $id );
				$image_original    = wp_get_attachment_image_src( $id, 'full' );
				$image['url']      = $image_original[0];
				$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );
				
				$image_size = trim( $atts['image_size'] );
				preg_match_all( '/\d+/', $image_size, $matches ); /* check if numeral width and height are entered */
				if ( in_array( $image_size, array( 'thumbnail', 'thumb', 'medium', 'large', 'full' ) ) ) {
					$image['image_size'] = $image_size;
				} elseif ( ! empty( $matches[0] ) ) {
					$image['image_size'] = array(
						$matches[0][0],
						$matches[0][1]
					);
				} else {
					$image['image_size'] = 'full';
				}
			}
			
			return $image;
		}
	}
}
