<?php

if ( ! function_exists( 'cyberdom_core_add_vertical_split_slider_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function cyberdom_core_add_vertical_split_slider_shortcode( $shortcodes ) {
		$shortcodes[] = 'CyberdomCore_Vertical_Split_Slider_Shortcode';

		return $shortcodes;
	}

	add_filter( 'cyberdom_core_filter_register_shortcodes', 'cyberdom_core_add_vertical_split_slider_shortcode' );
}

if ( class_exists( 'CyberdomCore_Shortcode' ) ) {
	class CyberdomCore_Vertical_Split_Slider_Shortcode extends CyberdomCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( CYBERDOM_CORE_SHORTCODES_URL_PATH . '/vertical-split-slider' );
			$this->set_base( 'cyberdom_core_vertical_split_slider' );
			$this->set_name( esc_html__( 'Vertical Split Slider', 'cyberdom-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds vertical split slider holder', 'cyberdom-core' ) );
			$this->set_category( esc_html__( 'Cyberdom Core', 'cyberdom-core' ) );
			$this->set_scripts(
				array(
					'jquery-effects-core' => array(
						'registered'	=> true
					),
					'multiscroll' => array(
						'registered'	=> false,
						'url'			=> CYBERDOM_CORE_SHORTCODES_URL_PATH . '/vertical-split-slider/assets/js/plugins/jquery.multiscroll.min.js',
						'dependency'	=> array( 'jquery', 'jquery-effects-core' )
					),
					'jquery-magnific-popup' => array(
						'registered' => true,
					),
				)
			);

			$this->set_necessary_styles(
				array(
					'multiscroll' => array(
						'registered'	=> false,
						'url'			=> CYBERDOM_CORE_SHORTCODES_URL_PATH . '/vertical-split-slider/assets/css/plugins/jquery.multiscroll.css'
					),
					'magnific-popup' => array(
						'registered' => true,
					),
				)
			);

			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'cyberdom-core' ),
			) );
			$this->set_option( array(
				'field_type'    => 'select',
				'name'          => 'disable_breakpoint',
				'title'         => esc_html__( 'Disable on smaller screens', 'cyberdom-core' ),
				'options'       => array(
					'1024' => esc_html__( 'Below 1024px', 'cyberdom-core' ),
					'768'  => esc_html__( 'Below 768px', 'cyberdom-core' ),
				),
				'default_value' => '1024'
			) );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'use_gradient_bg_color',
					'title'         => esc_html__( 'Use Gradient Color', 'cyberdom-core' ),
					'description'   => esc_html__( 'Use Gradient Color for the background on video links', 'cyberdom-core' ),
					'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option( array(
				'field_type' => 'repeater',
				'name'       => 'children',
				'title'      => esc_html__( 'Slide Items', 'cyberdom-core' ),
				'items'      => array(
					array(
						'field_type' => 'select',
						'name'       => 'slide_header_style',
						'title'      => esc_html__( 'Header/Bullets Style', 'cyberdom-core' ),
						'options'    => array(
							''      => esc_html__( 'Default', 'cyberdom-core' ),
							'light' => esc_html__( 'Light', 'cyberdom-core' ),
							'dark'  => esc_html__( 'Dark', 'cyberdom-core' ),
						)
					),
					array(
						'field_type' => 'select',
						'name'       => 'slide_logo_style',
						'title'      => esc_html__( 'Logo Style', 'cyberdom-core' ),
						'options'    => array(
							''      => esc_html__( 'Default', 'cyberdom-core' ),
							'light' => esc_html__( 'Light', 'cyberdom-core' ),
							'dark'  => esc_html__( 'Dark', 'cyberdom-core' ),
						)
					),
					array(
						'field_type' => 'select',
						'name'       => 'slide_layout',
						'title'      => esc_html__( 'Slide Layout', 'cyberdom-core' ),
						'options'    => array(
							'image-left'  => esc_html__( 'Image On Left', 'cyberdom-core' ),
							'image-right' => esc_html__( 'Image On Right', 'cyberdom-core' )
						),
					),
					array(
						'field_type' => 'image',
						'name'       => 'slide_image',
						'title'      => esc_html__( 'Image', 'cyberdom-core' )
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_corner_subtitle',
						'title'      => esc_html__( 'Corner Subtitle', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_corner_title',
						'title'      => esc_html__( 'Corner Title', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_corner_text',
						'title'      => esc_html__( 'Corner Text', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_corner_text_link',
						'title'      => esc_html__( 'Corner Text Link', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_subtitle',
						'title'      => esc_html__( 'Subtitle', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_title',
						'title'      => esc_html__( 'Title', 'cyberdom-core' ),
					),
					array(
						'field_type'    => 'select',
						'name'          => 'slide_content_title_tag',
						'title'         => esc_html__( 'Title Tag', 'cyberdom-core' ),
						'options'       => cyberdom_core_get_select_type_options_pool( 'title_tag', false ),
						'default_value' => 'h1',
					),
					array(
						'field_type'  => 'text',
						'name'        => 'line_break_positions',
						'title'       => esc_html__( 'Positions of Line Break', 'cyberdom-core' ),
						'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'color',
						'name'       => 'slide_content_title_color',
						'title'      => esc_html__( 'Title Color', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'textarea',
						'name'       => 'slide_content_text',
						'title'      => esc_html__( 'Text', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_corner_video_link',
						'title'      => esc_html__( 'Content Corner Video Link', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_counter_one_end_digit',
						'title'      => esc_html__( 'Counter One End Digit', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_counter_one_text',
						'title'      => esc_html__( 'Counter One Text', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_counter_two_end_digit',
						'title'      => esc_html__( 'Counter Two End Digit', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_counter_two_text',
						'title'      => esc_html__( 'Counter Two Text', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'textarea_html',
						'name'       => 'slide_content_svg_icon_one',
						'title'      => esc_html__( 'SVG Icon One', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_svg_title_one',
						'title'      => esc_html__( 'SVG Title One', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'textarea_html',
						'name'       => 'slide_content_svg_icon_two',
						'title'      => esc_html__( 'SVG Icon Two', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_svg_title_two',
						'title'      => esc_html__( 'SVG Title Two', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'textarea_html',
						'name'       => 'slide_content_svg_icon_three',
						'title'      => esc_html__( 'SVG Icon Three', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_svg_title_three',
						'title'      => esc_html__( 'SVG Title Three', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_button_link',
						'title'      => esc_html__( 'Button Link', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'text',
						'name'       => 'slide_content_button_text',
						'title'      => esc_html__( 'Button Text', 'cyberdom-core' ),
					),
					array(
						'field_type' => 'select',
						'name'       => 'slide_content_button_target',
						'title'      => esc_html__( 'Button Target', 'cyberdom-core' ),
						'options'    => cyberdom_core_get_select_type_options_pool( 'link_target', false )
					),
				)
			) );
		}
		
		public function load_assets() {
			wp_enqueue_script( 'jquery-effects-core' );

			wp_enqueue_script( 'multiscroll');
			wp_enqueue_style( 'multiscroll' );

			/* popup style & script */
			wp_enqueue_style( 'magnific-popup' );
			wp_enqueue_script( 'jquery-magnific-popup' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts                   = $this->get_atts();
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['this_object']    = $this;
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return cyberdom_core_get_template_part( 'shortcodes/vertical-split-slider', 'templates/vertical-split-slider', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-vertical-split-slider qodef-m';
			$holder_classes[] = ! empty ( $atts['disable_breakpoint'] ) ? 'qodef-disable-below--' . $atts['disable_breakpoint'] : '';
			$holder_classes[] = 'yes' === $atts['use_gradient_bg_color'] ? 'qodef-use-gradient-bg--yes' : '';

			return implode( ' ', $holder_classes );
		}

		public function get_slide_image_styles( $slide_atts ) {
			$styles = array();

			$styles[] = ! empty( $slide_atts['slide_image'] ) ? 'background-image: url(' . wp_get_attachment_url( $slide_atts['slide_image'] ) . ')' : '';

			return $styles;
		}

		public function get_slide_title_styles( $slide_atts ) {
			$styles = array();

			$styles[] = ! empty( $slide_atts['slide_content_title_color'] ) ? 'color: ' . $slide_atts['slide_content_title_color'] : '';

			return $styles;
		}

		public function get_modified_title( $slide_atts ) {
			$title = $slide_atts['slide_content_title'];

			if ( ! empty( $title ) && ! empty( $slide_atts['line_break_positions'] ) ) {
				$split_title          = explode( ' ', $title );
				$line_break_positions = explode( ',', str_replace( ' ', '', $slide_atts['line_break_positions'] ) );

				foreach ( $line_break_positions as $position ) {
					$position = intval( $position );
					if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
						$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br />';
					}
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		public function get_slide_data( $slide_atts ) {
			$data = array();

			$data['data-header-skin'] = ! empty( $slide_atts['slide_header_style'] ) ? $slide_atts['slide_header_style'] : '';
			$data['data-logo-skin']   = ! empty( $slide_atts['slide_logo_style'] ) ? $slide_atts['slide_logo_style'] : '';

			return $data;
		}
	}
}
