(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.cyberdom_core_video_button = {};

	$( window ).on(
		'load',
		() => {
			qodefVideoButton.init();
		}
	);

	const qodefVideoButton = {
		init () {
			this.holder = $('.qodef-video-button');

			if ( this.holder.length ) {
				this.holder.each(
					( index, element ) => {
						const $thisHolder = $( element );

						if ( !$thisHolder.hasClass('qodef--has-img') ) {
							qodefVideoButton.setHeight( $thisHolder );
						}
					}
				);
			}
		},
		setHeight ( $holder ) {
			setTimeout(
				() => {
					const $parallaxHolder = $holder.closest('.qodef-parallax');

					if ( $parallaxHolder.length ) {
						$holder.height($parallaxHolder.height());
					}
				}, 100
			);
		}
	};

	qodefCore.shortcodes.cyberdom_core_video_button.qodefVideoButton   = qodefVideoButton;
	qodefCore.shortcodes.cyberdom_core_video_button.qodefMagnificPopup = qodef.qodefMagnificPopup;

})( jQuery );