(function ($) {
    "use strict";

    $( document ).ready(
        () => {
            qodefCyberdomSpinner.init();
        }
    );

    $( window ).on(
        'load',
        () => {
            qodefCyberdomSpinner.windowLoaded = true;
        }
    );

    $( window ).on(
        'elementor/frontend/init',
        () => {
            const isEditMode = Boolean( elementorFrontend.isEditMode() );

            if ( isEditMode ) {
                qodefCyberdomSpinner.init( isEditMode );
            }
        }
    );

    const qodefCyberdomSpinner = {
        init ( isEditMode ) {
            const $holder = $('#qodef-page-spinner.qodef-layout--cyberdom');

            if ( $holder.length ) {
                if ( isEditMode ) {
                    qodefCyberdomSpinner.fadeOutLoader( $holder );
                } else {
                    qodefCore.qodefScroll.disable();
                    qodefCyberdomSpinner.splitText( $holder );
                }
            }
        },
        splitText ( $holder ) {
            const $text = $holder.find('.qodef-m-text');

            if ( $text.length ) {
                const text       = $text.text(),
                      newtext    = $.trim(text);
                let   extraClass = '';

                $text.empty();

                newtext.split(/(?!$)/u).forEach( function ( c ) {
                    extraClass = (c === " " ? 'qodef-m-empty-char' : ' ');
                    $text.append('<div class="qodef-m-char-holder"><span class="qodef-m-char ' + extraClass + '">' + c + '</span></div>');
                });

                qodefCyberdomSpinner.animateSpinner( $holder, $text );
            }
        },
        animateSpinner ( $holder, $text ) {
            $holder.addClass('qodef--init');

            const wait = seconds => {
                return new Promise ( resolve => {
                    setTimeout( resolve, seconds * 1000 );
                });
            };

            const isWindowLoaded = () => {
                let qodefCyberdomSpinnerInterval = setInterval(
                    () => {
                        if ( qodefCyberdomSpinner.windowLoaded ) {
                            clearInterval(qodefCyberdomSpinnerInterval);
                            $holder.addClass('qodef--end');
                            qodefCyberdomSpinner.fadeOutLoader( $holder, 800, 400 );

                            setTimeout(
                                () => {
                                    qodefCore.qodefScroll.enable();
                                    qodef.body.addClass('qodef-spinner--end');
                                }, 400
                            );
                        }
                    }, 100
                );
            }

            const animateSpinner = function () {
                const $chars = $text.find('.qodef-m-char:not(.qodef-m-empty-char)');

                if ( $chars.length ) {
                    const promises = [];

                    $chars.each(
                        ( index, element ) => {
                            const $thisChar = $( element );

                            promises[index] = new Promise( function ( resolve ) {
                                setTimeout(
                                    () => {
                                        $thisChar.addClass('qodef--appeared');
                                        resolve();
                                    }, index * 120
                                );
                            });
                        }
                    );

                    Promise.all(promises).then(() => {
                        $holder.addClass('qodef--animate');
                    }).then(() => {
                        return wait(4);
                    }).then(() => {
                        isWindowLoaded();
                    });
                }
            };

            animateSpinner();
        },
        fadeOutLoader ( $holder, speed, delay, easing ) {
            speed = speed ? speed : 500;
            delay = delay ? delay : 0;
            easing = easing ? easing : 'swing';

            if ( $holder.length ) {
                $holder.delay(delay).fadeOut(speed, easing);

                $(window).on(
                    'bind', 'pageshow',
                    ( event ) => {
                        if ( event.originalEvent.persisted ) {
                            $holder.fadeOut(speed, easing);
                        }
                    }
                );
            }
        }
    };

})(jQuery);