(function ( $ ) {
    'use strict';

    $( window ).on(
        'load',
        () => {
            qodefStandardWithShape.init();
        }
    );

    const qodefStandardWithShape = {
        init () {
            this.holder = $('.qodef-page-title.qodef-title--standard-with-shape');

            if ( this.holder.length ) {
                this.holder.each(
                    ( index, element ) => {
                        const $thisHolder = $( element );

                        if ( $thisHolder.hasClass('qodef-page-title-area-appear-animation--yes') ) {
                            qodefStandardWithShape.appearAnimation( $thisHolder );
                        }
                    }
                );
            }
        },
        appearAnimation ( $holder ) {
            qodefCore.qodefIsInViewport.check(
                $holder,
                () => {
                    $holder.addClass('qodef--appeared');
                }
            );
        }
    };

})( jQuery );
