<?php

if ( ! function_exists( 'cyberdom_core_add_standard_with_shape_meta_box' ) ) {
	/**
	 * Function that add options for standard with shape title layout
	 *
	 * @param array $section
	 */
	function cyberdom_core_add_standard_with_shape_meta_box( $section ) {
		if ( $section ) {
			$section->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_standard_with_shape_icon_svg_path',
					'title'       => esc_html__( 'Shape Icon SVG Path', 'cyberdom-core' ),
					'description' => esc_html__( 'Enter your title area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'cyberdom-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_title_layout' => array(
								'values'        => array( 'standard-with-shape' ),
								'default_value' => '',
							),
						),
					),
				)
			);

            $section->add_field_element(
                array(
                    'field_type'    => 'select',
                    'name'          => 'qodef_standard_with_shape_appear_animation',
                    'title'         => esc_html__( 'Enable Appear Animation', 'cyberdom-core' ),
                    'description'   => esc_html__( 'Enabling this option will add animation when Title Area appears in the viewport', 'cyberdom-core' ),
                    'options'       => cyberdom_core_get_select_type_options_pool( 'no_yes' ),
                    'default_value' => 'no',
                    'dependency'    => array(
                        'show' => array(
                            'qodef_title_layout' => array(
                                'values'        => array( 'standard-with-shape' ),
                                'default_value' => '',
                            ),
                        ),
                    ),
                )
            );

			// Hook to include additional options after module options
			do_action( 'cyberdom_core_action_after_standard_with_shape_meta_box', $section );
		}
	}

	add_action( 'cyberdom_core_action_after_standard_title_layout_meta_box_map', 'cyberdom_core_add_standard_with_shape_meta_box', 3 );
}
