(function ( $ ) {
	'use strict';

	// This case is important when theme is not active
	if ( typeof qodef !== 'object' ) {
		window.qodef = {};
	}

	window.qodefCore                = {};
	qodefCore.shortcodes            = {};
	qodefCore.listShortcodesScripts = {
		qodefSwiper: qodef.qodefSwiper,
		qodefPagination: qodef.qodefPagination,
		qodefFilter: qodef.qodefFilter,
		qodefMasonryLayout: qodef.qodefMasonryLayout,
		qodefJustifiedGallery: qodef.qodefJustifiedGallery,
		qodefDragCursor: qodefCore.qodefDragCursor,
	};

	qodefCore.body         = $( 'body' );
	qodefCore.html         = $( 'html' );
	qodefCore.windowWidth  = $( window ).width();
	qodefCore.windowHeight = $( window ).height();
	qodefCore.scroll       = 0;

	$( document ).ready(
		function () {
			qodefCore.scroll = $( window ).scrollTop();
			qodefInlinePageStyle.init();
			qodefStickyColumn.init();
			qodefButtonArrow.init();
		}
	);

	$( window ).resize(
		function () {
			qodefCore.windowWidth  = $( window ).width();
			qodefCore.windowHeight = $( window ).height();
		}
	);

	$( window ).scroll(
		function () {
			qodefCore.scroll = $( window ).scrollTop();
		}
	);

	$( window ).load(
		function () {
			qodefParallaxItem.init();
		}
	);
	var qodefButtonArrow       = {
		init: function () {
			var $buttons = $( 'body' ).find( '.wpcf7-submit, #qodef-page-comments-list .qodef-comment-item .qodef-e-links > a, .form-submit button[type=submit], .wc-block-price-filter__button' );
			if ( $buttons.length ) {
				$buttons.each(
					function () {
						var $border = $( this ).find( '.qodef-m-button-arrow-holder' );
						if ( ! $border.length ) {
							$buttons.append( '<span class="qodef-m-button-arrow-holder"><svg class="qodef-svg--button-arrow" xmlns="http://www.w3.org/2000/svg" width="17.65" height="13.1" viewBox="0 0 17.65 13.1"><path d="m11.75 13.1-1.275-1.275L14.1 8.2l.85-.575-.1-.3-1.025.125H0V5.625h13.825l1.025.15.1-.3-.85-.575-3.625-3.625L11.75 0l5.9 5.9v1.3Z"/><path d="m11.75 13.1-1.275-1.275L14.1 8.2l.85-.575-.1-.3-1.025.125H0V5.625h13.825l1.025.15.1-.3-.85-.575-3.625-3.625L11.75 0l5.9 5.9v1.3Z"/></svg></span>' );
						}
					}
				);
			}
		}
	};
	qodefCore.qodefButtonArrow = qodefButtonArrow;

	/**
	 * Check element to be in the viewport
	 */
	var qodefIsInViewport = {
		check: function ( $element, callback, onlyOnce ) {
			if ( $element.length ) {
				var offset = typeof $element.data( 'viewport-offset' ) !== 'undefined' ? $element.data( 'viewport-offset' ) : 0.15; // When item is 15% in the viewport

				var observer = new IntersectionObserver(
					function ( entries ) {
						// isIntersecting is true when element and viewport are overlapping
						// isIntersecting is false when element and viewport don't overlap
						if ( entries[0].isIntersecting === true ) {
							callback.call( $element );

							// Stop watching the element when it's initialize
							if ( onlyOnce !== false ) {
								observer.disconnect();
							}
						}
					},
					{ threshold: [offset] }
				);

				observer.observe( $element[0] );
			}
		},
	};

	qodefCore.qodefIsInViewport = qodefIsInViewport;

	var qodefScroll = {
		disable: function () {
			if ( window.addEventListener ) {
				window.addEventListener(
					'wheel',
					qodefScroll.preventDefaultValue,
					{ passive: false }
				);
			}

			// window.onmousewheel = document.onmousewheel = qodefScroll.preventDefaultValue;
			document.onkeydown = qodefScroll.keyDown;
		},
		enable: function () {
			if ( window.removeEventListener ) {
				window.removeEventListener(
					'wheel',
					qodefScroll.preventDefaultValue,
					{ passive: false }
				);
			}
			window.onmousewheel = document.onmousewheel = document.onkeydown = null;
		},
		preventDefaultValue: function ( e ) {
			e = e || window.event;
			if ( e.preventDefault ) {
				e.preventDefault();
			}
			e.returnValue = false;
		},
		keyDown: function ( e ) {
			var keys = [37, 38, 39, 40];
			for ( var i = keys.length; i--; ) {
				if ( e.keyCode === keys[i] ) {
					qodefScroll.preventDefaultValue( e );
					return;
				}
			}
		}
	};

	qodefCore.qodefScroll = qodefScroll;

	var qodefPerfectScrollbar = {
		init: function ( $holder ) {
			if ( $holder.length ) {
				qodefPerfectScrollbar.qodefInitScroll( $holder );
			}
		},
		qodefInitScroll: function ( $holder ) {
			var $defaultParams = {
				wheelSpeed: 0.6,
				suppressScrollX: true
			};

			var $ps = new PerfectScrollbar(
				$holder[0],
				$defaultParams
			);

			$( window ).resize(
				function () {
					$ps.update();
				}
			);
		}
	};

	qodefCore.qodefPerfectScrollbar = qodefPerfectScrollbar;

	var qodefInlinePageStyle = {
		init: function () {
			this.holder = $( '#manufaktursolutions-core-page-inline-style' );

			if ( this.holder.length ) {
				var style = this.holder.data( 'style' );

				if ( style.length ) {
					$( 'head' ).append( '<style type="text/css">' + style + '</style>' );
				}
			}
		}
	};

	var qodefStickyColumn = {
		init: function () {
			var stickyColumnHolder = $( '.qodef-sticky-column-enable' );

			if ( stickyColumnHolder.length ) {
				stickyColumnHolder.each(
					function () {
						var thisSticky             = $( this );
						var columnInitialOffsetTop = $( this ).offset().top;
						var parentInitialOffsetTop = $( this ).parent().offset().top;

						qodefStickyColumn.setPosition(
							thisSticky,
							columnInitialOffsetTop,
							parentInitialOffsetTop
						);

						$( window ).scroll(
							function () {
								qodefStickyColumn.setPosition(
									thisSticky,
									columnInitialOffsetTop,
									parentInitialOffsetTop
								);
							}
						);

						$( window ).resize(
							function () {
								qodefStickyColumn.setPosition(
									thisSticky,
									columnInitialOffsetTop,
									parentInitialOffsetTop
								);
							}
						);
					}
				);
			}
		},
		setPosition: function ( thisSticky, columnInitialOffsetTop, parentInitialOffsetTop ) {
			var columnHeight = thisSticky.height();
			var parentHeight = thisSticky.parent().height();

			// if same height, then scrolling is doable
			if ( thisSticky.siblings().height() === thisSticky.parent().height() ) {

				var screenMiddle = qodefCore.scroll + (qodefGlobal.vars.adminBarHeight / 2) + (qodefCore.windowHeight / 2);
				var amount       = screenMiddle - columnInitialOffsetTop - (columnHeight / 2);
				var maxAmount    = parentHeight - columnHeight;

				if ( screenMiddle - (columnHeight / 2) >= columnInitialOffsetTop && screenMiddle - (columnHeight / 2) < parentInitialOffsetTop + parentHeight - columnHeight ) {
					thisSticky.css( { 'transform': 'translateY(' + parseInt( amount ) + 'px)' } );
				} else if ( screenMiddle - (columnHeight / 2) < columnInitialOffsetTop ) {
					thisSticky.css( { 'transform': 'translateY(' + 0 + 'px)' } );
				} else if ( screenMiddle - (columnHeight / 2) > parentInitialOffsetTop + parentHeight - columnHeight ) {
					thisSticky.css( { 'transform': 'translateY(' + parseInt( maxAmount ) + 'px)' } );
				}
			} else {
				thisSticky.css( { 'transform': 'translateY(' + 0 + 'px)' } );
			}
		}
	};

	qodefCore.qodefStickyColumn = qodefStickyColumn;

	/**
	 * Init parallax item
	 */
	var qodefParallaxItem = {
		init: function () {
			var $items = $( '.qodef-parallax-item' );

			if ( $items.length ) {
				$items.each(
					function () {
						var $currentItem = $( this ),
							$y           = Math.floor( Math.random() * (-100 - (-25)) + (-25) );

						if ( $currentItem.hasClass( 'qodef-grid-item' ) ) {
							$currentItem.children( '.qodef-e-inner' ).attr(
								'data-parallax',
								'{"y": ' + $y + ', "smoothness": ' + '30' + '}'
							);
						} else {
							$currentItem.attr(
								'data-parallax',
								'{"y": ' + $y + ', "smoothness": ' + '30' + '}'
							);
						}
					}
				);
			}

			qodefParallaxItem.initParallax();
		},
		initParallax: function () {
			var parallaxInstances = $( '[data-parallax]' );

			if ( parallaxInstances.length && ! qodefCore.html.hasClass( 'touchevents' ) && typeof ParallaxScroll === 'object' ) {
				ParallaxScroll.init(); //initialization removed from plugin js file to have it run only on non-touch devices
			}
		},
	};

	qodefCore.qodefParallaxItem = qodefParallaxItem;

})( jQuery );
