<?php

if ( ! function_exists( 'manufaktursolutions_core_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function manufaktursolutions_core_add_general_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_main_color',
					'title'       => esc_html__( 'Main Color', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Choose the most dominant theme color', 'manufaktursolutions-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_background_color',
					'title'       => esc_html__( 'Page Background Color', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set background color', 'manufaktursolutions-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_page_background_image',
					'title'       => esc_html__( 'Page Background Image', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set background image', 'manufaktursolutions-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_repeat',
					'title'       => esc_html__( 'Page Background Image Repeat', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set background image repeat', 'manufaktursolutions-core' ),
					'options'     => array(
						''          => esc_html__( 'Default', 'manufaktursolutions-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'manufaktursolutions-core' ),
						'repeat'    => esc_html__( 'Repeat', 'manufaktursolutions-core' ),
						'repeat-x'  => esc_html__( 'Repeat-x', 'manufaktursolutions-core' ),
						'repeat-y'  => esc_html__( 'Repeat-y', 'manufaktursolutions-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_size',
					'title'       => esc_html__( 'Page Background Image Size', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set background image size', 'manufaktursolutions-core' ),
					'options'     => array(
						''        => esc_html__( 'Default', 'manufaktursolutions-core' ),
						'contain' => esc_html__( 'Contain', 'manufaktursolutions-core' ),
						'cover'   => esc_html__( 'Cover', 'manufaktursolutions-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_attachment',
					'title'       => esc_html__( 'Page Background Image Attachment', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set background image attachment', 'manufaktursolutions-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'manufaktursolutions-core' ),
						'fixed'  => esc_html__( 'Fixed', 'manufaktursolutions-core' ),
						'scroll' => esc_html__( 'Scroll', 'manufaktursolutions-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding',
					'title'       => esc_html__( 'Page Content Padding', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'manufaktursolutions-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding_mobile',
					'title'       => esc_html__( 'Page Content Padding Mobile', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'manufaktursolutions-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed',
					'title'         => esc_html__( 'Boxed Layout', 'manufaktursolutions-core' ),
					'description'   => esc_html__( 'Set boxed layout', 'manufaktursolutions-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section = $page->add_section_element(
				array(
					'name'       => 'qodef_boxed_section',
					'title'      => esc_html__( 'Boxed Layout Section', 'manufaktursolutions-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_boxed' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_boxed_background_color',
					'title'       => esc_html__( 'Boxed Background Color', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set boxed background color', 'manufaktursolutions-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_boxed_background_pattern',
					'title'       => esc_html__( 'Boxed Background Pattern', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set boxed background pattern', 'manufaktursolutions-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_boxed_background_pattern_behavior',
					'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set boxed background pattern behavior', 'manufaktursolutions-core' ),
					'options'     => array(
						'fixed'  => esc_html__( 'Fixed', 'manufaktursolutions-core' ),
						'scroll' => esc_html__( 'Scroll', 'manufaktursolutions-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_passepartout',
					'title'         => esc_html__( 'Passepartout', 'manufaktursolutions-core' ),
					'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'manufaktursolutions-core' ),
					'default_value' => 'no',
				)
			);

			$passepartout_section = $page->add_section_element(
				array(
					'name'       => 'qodef_passepartout_section',
					'title'      => esc_html__( 'Passepartout Section', 'manufaktursolutions-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_passepartout' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_passepartout_color',
					'title'       => esc_html__( 'Passepartout Color', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Choose background color for passepartout', 'manufaktursolutions-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_passepartout_image',
					'title'       => esc_html__( 'Passepartout Background Image', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Set background image for passepartout', 'manufaktursolutions-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size',
					'title'       => esc_html__( 'Passepartout Size', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout', 'manufaktursolutions-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'manufaktursolutions-core' ),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size_responsive',
					'title'       => esc_html__( 'Passepartout Responsive Size', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'manufaktursolutions-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'manufaktursolutions-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_content_width',
					'title'         => esc_html__( 'Initial Width of Content', 'manufaktursolutions-core' ),
					'description'   => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'content_width', false ),
					'default_value' => '1100',
				)
			);

			// Hook to include additional options after module options
			do_action( 'manufaktursolutions_core_action_after_general_options_map', $page );

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_custom_js',
					'title'       => esc_html__( 'Custom JS', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Enter your custom JavaScript here', 'manufaktursolutions-core' ),
				)
			);
		}
	}

	add_action( 'manufaktursolutions_core_action_default_options_init', 'manufaktursolutions_core_add_general_options', manufaktursolutions_core_get_admin_options_map_position( 'general' ) );
}
