<?php

if ( ! function_exists( 'manufaktursolutions_core_add_ionicons_to_collection' ) ) {
	/**
	 * Function that add icon font pack into the global list
	 *
	 * @param array $icons
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_ionicons_to_collection( $icons ) {
		$icons[] = 'ManufakturSolutionsCore_IonIcons_Pack';

		return $icons;
	}

	add_filter( 'qode_framework_filter_add_icon', 'manufaktursolutions_core_add_ionicons_to_collection' );
}

if ( class_exists( 'QodeFrameworkIconPack' ) ) {
	class ManufakturSolutionsCore_IonIcons_Pack extends QodeFrameworkIconPack {

		public function __construct() {
			parent::__construct();
		}

		public function add_icon_pack() {
			$this->set_base( 'ionicons' );
			$this->set_name( 'Ionicons' );
			$this->set_icons( $this->icons_array() );
			$this->set_specific_icons( $this->specific_icons() );
		}

		public function get_style_url() {
			return MANUFAKTURSOLUTIONS_CORE_INC_URL_PATH . '/icons/' . $this->get_base() . '/assets/css/' . $this->get_base() . '.min.css';
		}

		public function icons_array() {
			return array(
				''                                   => '',
				'ion-ios-add'                        => 'ion-ios-add',
				'ion-ios-add-circle'                 => 'ion-ios-add-circle',
				'ion-ios-add-circle-outline'         => 'ion-ios-add-circle-outline',
				'ion-ios-airplane'                   => 'ion-ios-airplane',
				'ion-ios-alarm'                      => 'ion-ios-alarm',
				'ion-ios-albums'                     => 'ion-ios-albums',
				'ion-ios-alert'                      => 'ion-ios-alert',
				'ion-ios-american-football'          => 'ion-ios-american-football',
				'ion-ios-analytics'                  => 'ion-ios-analytics',
				'ion-ios-aperture'                   => 'ion-ios-aperture',
				'ion-ios-apps'                       => 'ion-ios-apps',
				'ion-ios-appstore'                   => 'ion-ios-appstore',
				'ion-ios-archive'                    => 'ion-ios-archive',
				'ion-ios-arrow-back'                 => 'ion-ios-arrow-back',
				'ion-ios-arrow-down'                 => 'ion-ios-arrow-down',
				'ion-ios-arrow-dropdown'             => 'ion-ios-arrow-dropdown',
				'ion-ios-arrow-dropdown-circle'      => 'ion-ios-arrow-dropdown-circle',
				'ion-ios-arrow-dropleft'             => 'ion-ios-arrow-dropleft',
				'ion-ios-arrow-dropleft-circle'      => 'ion-ios-arrow-dropleft-circle',
				'ion-ios-arrow-dropright'            => 'ion-ios-arrow-dropright',
				'ion-ios-arrow-dropright-circle'     => 'ion-ios-arrow-dropright-circle',
				'ion-ios-arrow-dropup'               => 'ion-ios-arrow-dropup',
				'ion-ios-arrow-dropup-circle'        => 'ion-ios-arrow-dropup-circle',
				'ion-ios-arrow-forward'              => 'ion-ios-arrow-forward',
				'ion-ios-arrow-round-back'           => 'ion-ios-arrow-round-back',
				'ion-ios-arrow-round-down'           => 'ion-ios-arrow-round-down',
				'ion-ios-arrow-round-forward'        => 'ion-ios-arrow-round-forward',
				'ion-ios-arrow-round-up'             => 'ion-ios-arrow-round-up',
				'ion-ios-arrow-up'                   => 'ion-ios-arrow-up',
				'ion-ios-at'                         => 'ion-ios-at',
				'ion-ios-attach'                     => 'ion-ios-attach',
				'ion-ios-backspace'                  => 'ion-ios-backspace',
				'ion-ios-barcode'                    => 'ion-ios-barcode',
				'ion-ios-baseball'                   => 'ion-ios-baseball',
				'ion-ios-basket'                     => 'ion-ios-basket',
				'ion-ios-basketball'                 => 'ion-ios-basketball',
				'ion-ios-battery-charging'           => 'ion-ios-battery-charging',
				'ion-ios-battery-dead'               => 'ion-ios-battery-dead',
				'ion-ios-battery-full'               => 'ion-ios-battery-full',
				'ion-ios-beaker'                     => 'ion-ios-beaker',
				'ion-ios-bed'                        => 'ion-ios-bed',
				'ion-ios-beer'                       => 'ion-ios-beer',
				'ion-ios-bicycle'                    => 'ion-ios-bicycle',
				'ion-ios-bluetooth'                  => 'ion-ios-bluetooth',
				'ion-ios-boat'                       => 'ion-ios-boat',
				'ion-ios-body'                       => 'ion-ios-body',
				'ion-ios-bonfire'                    => 'ion-ios-bonfire',
				'ion-ios-book'                       => 'ion-ios-book',
				'ion-ios-bookmark'                   => 'ion-ios-bookmark',
				'ion-ios-bookmarks'                  => 'ion-ios-bookmarks',
				'ion-ios-bowtie'                     => 'ion-ios-bowtie',
				'ion-ios-briefcase'                  => 'ion-ios-briefcase',
				'ion-ios-browsers'                   => 'ion-ios-browsers',
				'ion-ios-brush'                      => 'ion-ios-brush',
				'ion-ios-bug'                        => 'ion-ios-bug',
				'ion-ios-build'                      => 'ion-ios-build',
				'ion-ios-bulb'                       => 'ion-ios-bulb',
				'ion-ios-bus'                        => 'ion-ios-bus',
				'ion-ios-business'                   => 'ion-ios-business',
				'ion-ios-cafe'                       => 'ion-ios-cafe',
				'ion-ios-calculator'                 => 'ion-ios-calculator',
				'ion-ios-calendar'                   => 'ion-ios-calendar',
				'ion-ios-call'                       => 'ion-ios-call',
				'ion-ios-camera'                     => 'ion-ios-camera',
				'ion-ios-car'                        => 'ion-ios-car',
				'ion-ios-card'                       => 'ion-ios-card',
				'ion-ios-cart'                       => 'ion-ios-cart',
				'ion-ios-cash'                       => 'ion-ios-cash',
				'ion-ios-cellular'                   => 'ion-ios-cellular',
				'ion-ios-chatboxes'                  => 'ion-ios-chatboxes',
				'ion-ios-chatbubbles'                => 'ion-ios-chatbubbles',
				'ion-ios-checkbox'                   => 'ion-ios-checkbox',
				'ion-ios-checkbox-outline'           => 'ion-ios-checkbox-outline',
				'ion-ios-checkmark'                  => 'ion-ios-checkmark',
				'ion-ios-checkmark-circle'           => 'ion-ios-checkmark-circle',
				'ion-ios-checkmark-circle-outline'   => 'ion-ios-checkmark-circle-outline',
				'ion-ios-clipboard'                  => 'ion-ios-clipboard',
				'ion-ios-clock'                      => 'ion-ios-clock',
				'ion-ios-close'                      => 'ion-ios-close',
				'ion-ios-close-circle'               => 'ion-ios-close-circle',
				'ion-ios-close-circle-outline'       => 'ion-ios-close-circle-outline',
				'ion-ios-cloud'                      => 'ion-ios-cloud',
				'ion-ios-cloud-circle'               => 'ion-ios-cloud-circle',
				'ion-ios-cloud-done'                 => 'ion-ios-cloud-done',
				'ion-ios-cloud-download'             => 'ion-ios-cloud-download',
				'ion-ios-cloud-outline'              => 'ion-ios-cloud-outline',
				'ion-ios-cloud-upload'               => 'ion-ios-cloud-upload',
				'ion-ios-cloudy'                     => 'ion-ios-cloudy',
				'ion-ios-cloudy-night'               => 'ion-ios-cloudy-night',
				'ion-ios-code'                       => 'ion-ios-code',
				'ion-ios-code-download'              => 'ion-ios-code-download',
				'ion-ios-code-working'               => 'ion-ios-code-working',
				'ion-ios-cog'                        => 'ion-ios-cog',
				'ion-ios-color-fill'                 => 'ion-ios-color-fill',
				'ion-ios-color-filter'               => 'ion-ios-color-filter',
				'ion-ios-color-palette'              => 'ion-ios-color-palette',
				'ion-ios-color-wand'                 => 'ion-ios-color-wand',
				'ion-ios-compass'                    => 'ion-ios-compass',
				'ion-ios-construct'                  => 'ion-ios-construct',
				'ion-ios-contact'                    => 'ion-ios-contact',
				'ion-ios-contacts'                   => 'ion-ios-contacts',
				'ion-ios-contract'                   => 'ion-ios-contract',
				'ion-ios-contrast'                   => 'ion-ios-contrast',
				'ion-ios-copy'                       => 'ion-ios-copy',
				'ion-ios-create'                     => 'ion-ios-create',
				'ion-ios-crop'                       => 'ion-ios-crop',
				'ion-ios-cube'                       => 'ion-ios-cube',
				'ion-ios-cut'                        => 'ion-ios-cut',
				'ion-ios-desktop'                    => 'ion-ios-desktop',
				'ion-ios-disc'                       => 'ion-ios-disc',
				'ion-ios-document'                   => 'ion-ios-document',
				'ion-ios-done-all'                   => 'ion-ios-done-all',
				'ion-ios-download'                   => 'ion-ios-download',
				'ion-ios-easel'                      => 'ion-ios-easel',
				'ion-ios-egg'                        => 'ion-ios-egg',
				'ion-ios-exit'                       => 'ion-ios-exit',
				'ion-ios-expand'                     => 'ion-ios-expand',
				'ion-ios-eye'                        => 'ion-ios-eye',
				'ion-ios-eye-off'                    => 'ion-ios-eye-off',
				'ion-ios-fastforward'                => 'ion-ios-fastforward',
				'ion-ios-female'                     => 'ion-ios-female',
				'ion-ios-filing'                     => 'ion-ios-filing',
				'ion-ios-film'                       => 'ion-ios-film',
				'ion-ios-finger-print'               => 'ion-ios-finger-print',
				'ion-ios-fitness'                    => 'ion-ios-fitness',
				'ion-ios-flag'                       => 'ion-ios-flag',
				'ion-ios-flame'                      => 'ion-ios-flame',
				'ion-ios-flash'                      => 'ion-ios-flash',
				'ion-ios-flash-off'                  => 'ion-ios-flash-off',
				'ion-ios-flashlight'                 => 'ion-ios-flashlight',
				'ion-ios-flask'                      => 'ion-ios-flask',
				'ion-ios-flower'                     => 'ion-ios-flower',
				'ion-ios-folder'                     => 'ion-ios-folder',
				'ion-ios-folder-open'                => 'ion-ios-folder-open',
				'ion-ios-football'                   => 'ion-ios-football',
				'ion-ios-funnel'                     => 'ion-ios-funnel',
				'ion-ios-gift'                       => 'ion-ios-gift',
				'ion-ios-git-branch'                 => 'ion-ios-git-branch',
				'ion-ios-git-commit'                 => 'ion-ios-git-commit',
				'ion-ios-git-compare'                => 'ion-ios-git-compare',
				'ion-ios-git-merge'                  => 'ion-ios-git-merge',
				'ion-ios-git-network'                => 'ion-ios-git-network',
				'ion-ios-git-pull-request'           => 'ion-ios-git-pull-request',
				'ion-ios-glasses'                    => 'ion-ios-glasses',
				'ion-ios-globe'                      => 'ion-ios-globe',
				'ion-ios-grid'                       => 'ion-ios-grid',
				'ion-ios-hammer'                     => 'ion-ios-hammer',
				'ion-ios-hand'                       => 'ion-ios-hand',
				'ion-ios-happy'                      => 'ion-ios-happy',
				'ion-ios-headset'                    => 'ion-ios-headset',
				'ion-ios-heart'                      => 'ion-ios-heart',
				'ion-ios-heart-dislike'              => 'ion-ios-heart-dislike',
				'ion-ios-heart-empty'                => 'ion-ios-heart-empty',
				'ion-ios-heart-half'                 => 'ion-ios-heart-half',
				'ion-ios-help'                       => 'ion-ios-help',
				'ion-ios-help-buoy'                  => 'ion-ios-help-buoy',
				'ion-ios-help-circle'                => 'ion-ios-help-circle',
				'ion-ios-help-circle-outline'        => 'ion-ios-help-circle-outline',
				'ion-ios-home'                       => 'ion-ios-home',
				'ion-ios-hourglass'                  => 'ion-ios-hourglass',
				'ion-ios-ice-cream'                  => 'ion-ios-ice-cream',
				'ion-ios-image'                      => 'ion-ios-image',
				'ion-ios-images'                     => 'ion-ios-images',
				'ion-ios-infinite'                   => 'ion-ios-infinite',
				'ion-ios-information'                => 'ion-ios-information',
				'ion-ios-information-circle'         => 'ion-ios-information-circle',
				'ion-ios-information-circle-outline' => 'ion-ios-information-circle-outline',
				'ion-ios-jet'                        => 'ion-ios-jet',
				'ion-ios-journal'                    => 'ion-ios-journal',
				'ion-ios-key'                        => 'ion-ios-key',
				'ion-ios-keypad'                     => 'ion-ios-keypad',
				'ion-ios-laptop'                     => 'ion-ios-laptop',
				'ion-ios-leaf'                       => 'ion-ios-leaf',
				'ion-ios-link'                       => 'ion-ios-link',
				'ion-ios-list'                       => 'ion-ios-list',
				'ion-ios-list-box'                   => 'ion-ios-list-box',
				'ion-ios-locate'                     => 'ion-ios-locate',
				'ion-ios-lock'                       => 'ion-ios-lock',
				'ion-ios-log-in'                     => 'ion-ios-log-in',
				'ion-ios-log-out'                    => 'ion-ios-log-out',
				'ion-ios-magnet'                     => 'ion-ios-magnet',
				'ion-ios-mail'                       => 'ion-ios-mail',
				'ion-ios-mail-open'                  => 'ion-ios-mail-open',
				'ion-ios-mail-unread'                => 'ion-ios-mail-unread',
				'ion-ios-male'                       => 'ion-ios-male',
				'ion-ios-man'                        => 'ion-ios-man',
				'ion-ios-map'                        => 'ion-ios-map',
				'ion-ios-medal'                      => 'ion-ios-medal',
				'ion-ios-medical'                    => 'ion-ios-medical',
				'ion-ios-medkit'                     => 'ion-ios-medkit',
				'ion-ios-megaphone'                  => 'ion-ios-megaphone',
				'ion-ios-menu'                       => 'ion-ios-menu',
				'ion-ios-mic'                        => 'ion-ios-mic',
				'ion-ios-mic-off'                    => 'ion-ios-mic-off',
				'ion-ios-microphone'                 => 'ion-ios-microphone',
				'ion-ios-moon'                       => 'ion-ios-moon',
				'ion-ios-more'                       => 'ion-ios-more',
				'ion-ios-move'                       => 'ion-ios-move',
				'ion-ios-musical-note'               => 'ion-ios-musical-note',
				'ion-ios-musical-notes'              => 'ion-ios-musical-notes',
				'ion-ios-navigate'                   => 'ion-ios-navigate',
				'ion-ios-notifications'              => 'ion-ios-notifications',
				'ion-ios-notifications-off'          => 'ion-ios-notifications-off',
				'ion-ios-notifications-outline'      => 'ion-ios-notifications-outline',
				'ion-ios-nuclear'                    => 'ion-ios-nuclear',
				'ion-ios-nutrition'                  => 'ion-ios-nutrition',
				'ion-ios-open'                       => 'ion-ios-open',
				'ion-ios-options'                    => 'ion-ios-options',
				'ion-ios-outlet'                     => 'ion-ios-outlet',
				'ion-ios-paper'                      => 'ion-ios-paper',
				'ion-ios-paper-plane'                => 'ion-ios-paper-plane',
				'ion-ios-partly-sunny'               => 'ion-ios-partly-sunny',
				'ion-ios-pause'                      => 'ion-ios-pause',
				'ion-ios-paw'                        => 'ion-ios-paw',
				'ion-ios-people'                     => 'ion-ios-people',
				'ion-ios-person'                     => 'ion-ios-person',
				'ion-ios-person-add'                 => 'ion-ios-person-add',
				'ion-ios-phone-landscape'            => 'ion-ios-phone-landscape',
				'ion-ios-phone-portrait'             => 'ion-ios-phone-portrait',
				'ion-ios-photos'                     => 'ion-ios-photos',
				'ion-ios-pie'                        => 'ion-ios-pie',
				'ion-ios-pin'                        => 'ion-ios-pin',
				'ion-ios-pint'                       => 'ion-ios-pint',
				'ion-ios-pizza'                      => 'ion-ios-pizza',
				'ion-ios-planet'                     => 'ion-ios-planet',
				'ion-ios-play'                       => 'ion-ios-play',
				'ion-ios-play-circle'                => 'ion-ios-play-circle',
				'ion-ios-podium'                     => 'ion-ios-podium',
				'ion-ios-power'                      => 'ion-ios-power',
				'ion-ios-pricetag'                   => 'ion-ios-pricetag',
				'ion-ios-pricetags'                  => 'ion-ios-pricetags',
				'ion-ios-print'                      => 'ion-ios-print',
				'ion-ios-pulse'                      => 'ion-ios-pulse',
				'ion-ios-qr-scanner'                 => 'ion-ios-qr-scanner',
				'ion-ios-quote'                      => 'ion-ios-quote',
				'ion-ios-radio'                      => 'ion-ios-radio',
				'ion-ios-radio-button-off'           => 'ion-ios-radio-button-off',
				'ion-ios-radio-button-on'            => 'ion-ios-radio-button-on',
				'ion-ios-rainy'                      => 'ion-ios-rainy',
				'ion-ios-recording'                  => 'ion-ios-recording',
				'ion-ios-redo'                       => 'ion-ios-redo',
				'ion-ios-refresh'                    => 'ion-ios-refresh',
				'ion-ios-refresh-circle'             => 'ion-ios-refresh-circle',
				'ion-ios-remove'                     => 'ion-ios-remove',
				'ion-ios-remove-circle'              => 'ion-ios-remove-circle',
				'ion-ios-remove-circle-outline'      => 'ion-ios-remove-circle-outline',
				'ion-ios-reorder'                    => 'ion-ios-reorder',
				'ion-ios-repeat'                     => 'ion-ios-repeat',
				'ion-ios-resize'                     => 'ion-ios-resize',
				'ion-ios-restaurant'                 => 'ion-ios-restaurant',
				'ion-ios-return-left'                => 'ion-ios-return-left',
				'ion-ios-return-right'               => 'ion-ios-return-right',
				'ion-ios-reverse-camera'             => 'ion-ios-reverse-camera',
				'ion-ios-rewind'                     => 'ion-ios-rewind',
				'ion-ios-ribbon'                     => 'ion-ios-ribbon',
				'ion-ios-rocket'                     => 'ion-ios-rocket',
				'ion-ios-rose'                       => 'ion-ios-rose',
				'ion-ios-sad'                        => 'ion-ios-sad',
				'ion-ios-save'                       => 'ion-ios-save',
				'ion-ios-school'                     => 'ion-ios-school',
				'ion-ios-search'                     => 'ion-ios-search',
				'ion-ios-send'                       => 'ion-ios-send',
				'ion-ios-settings'                   => 'ion-ios-settings',
				'ion-ios-share'                      => 'ion-ios-share',
				'ion-ios-share-alt'                  => 'ion-ios-share-alt',
				'ion-ios-shirt'                      => 'ion-ios-shirt',
				'ion-ios-shuffle'                    => 'ion-ios-shuffle',
				'ion-ios-skip-backward'              => 'ion-ios-skip-backward',
				'ion-ios-skip-forward'               => 'ion-ios-skip-forward',
				'ion-ios-snow'                       => 'ion-ios-snow',
				'ion-ios-speedometer'                => 'ion-ios-speedometer',
				'ion-ios-square'                     => 'ion-ios-square',
				'ion-ios-square-outline'             => 'ion-ios-square-outline',
				'ion-ios-star'                       => 'ion-ios-star',
				'ion-ios-star-half'                  => 'ion-ios-star-half',
				'ion-ios-star-outline'               => 'ion-ios-star-outline',
				'ion-ios-stats'                      => 'ion-ios-stats',
				'ion-ios-stopwatch'                  => 'ion-ios-stopwatch',
				'ion-ios-subway'                     => 'ion-ios-subway',
				'ion-ios-sunny'                      => 'ion-ios-sunny',
				'ion-ios-swap'                       => 'ion-ios-swap',
				'ion-ios-switch'                     => 'ion-ios-switch',
				'ion-ios-sync'                       => 'ion-ios-sync',
				'ion-ios-tablet-landscape'           => 'ion-ios-tablet-landscape',
				'ion-ios-tablet-portrait'            => 'ion-ios-tablet-portrait',
				'ion-ios-tennisball'                 => 'ion-ios-tennisball',
				'ion-ios-text'                       => 'ion-ios-text',
				'ion-ios-thermometer'                => 'ion-ios-thermometer',
				'ion-ios-thumbs-down'                => 'ion-ios-thumbs-down',
				'ion-ios-thumbs-up'                  => 'ion-ios-thumbs-up',
				'ion-ios-thunderstorm'               => 'ion-ios-thunderstorm',
				'ion-ios-time'                       => 'ion-ios-time',
				'ion-ios-timer'                      => 'ion-ios-timer',
				'ion-ios-today'                      => 'ion-ios-today',
				'ion-ios-train'                      => 'ion-ios-train',
				'ion-ios-transgender'                => 'ion-ios-transgender',
				'ion-ios-trash'                      => 'ion-ios-trash',
				'ion-ios-trending-down'              => 'ion-ios-trending-down',
				'ion-ios-trending-up'                => 'ion-ios-trending-up',
				'ion-ios-trophy'                     => 'ion-ios-trophy',
				'ion-ios-tv'                         => 'ion-ios-tv',
				'ion-ios-umbrella'                   => 'ion-ios-umbrella',
				'ion-ios-undo'                       => 'ion-ios-undo',
				'ion-ios-unlock'                     => 'ion-ios-unlock',
				'ion-ios-videocam'                   => 'ion-ios-videocam',
				'ion-ios-volume-high'                => 'ion-ios-volume-high',
				'ion-ios-volume-low'                 => 'ion-ios-volume-low',
				'ion-ios-volume-mute'                => 'ion-ios-volume-mute',
				'ion-ios-volume-off'                 => 'ion-ios-volume-off',
				'ion-ios-walk'                       => 'ion-ios-walk',
				'ion-ios-wallet'                     => 'ion-ios-wallet',
				'ion-ios-warning'                    => 'ion-ios-warning',
				'ion-ios-watch'                      => 'ion-ios-watch',
				'ion-ios-water'                      => 'ion-ios-water',
				'ion-ios-wifi'                       => 'ion-ios-wifi',
				'ion-ios-wine'                       => 'ion-ios-wine',
				'ion-ios-woman'                      => 'ion-ios-woman',
				'ion-logo-android'                   => 'ion-logo-android',
				'ion-logo-angular'                   => 'ion-logo-angular',
				'ion-logo-apple'                     => 'ion-logo-apple',
				'ion-logo-bitbucket'                 => 'ion-logo-bitbucket',
				'ion-logo-bitcoin'                   => 'ion-logo-bitcoin',
				'ion-logo-buffer'                    => 'ion-logo-buffer',
				'ion-logo-chrome'                    => 'ion-logo-chrome',
				'ion-logo-closed-captioning'         => 'ion-logo-closed-captioning',
				'ion-logo-codepen'                   => 'ion-logo-codepen',
				'ion-logo-css3'                      => 'ion-logo-css3',
				'ion-logo-designernews'              => 'ion-logo-designernews',
				'ion-logo-dribbble'                  => 'ion-logo-dribbble',
				'ion-logo-dropbox'                   => 'ion-logo-dropbox',
				'ion-logo-euro'                      => 'ion-logo-euro',
				'ion-logo-facebook'                  => 'ion-logo-facebook',
				'ion-logo-flickr'                    => 'ion-logo-flickr',
				'ion-logo-foursquare'                => 'ion-logo-foursquare',
				'ion-logo-freebsd-devil'             => 'ion-logo-freebsd-devil',
				'ion-logo-game-controller-a'         => 'ion-logo-game-controller-a',
				'ion-logo-game-controller-b'         => 'ion-logo-game-controller-b',
				'ion-logo-github'                    => 'ion-logo-github',
				'ion-logo-google'                    => 'ion-logo-google',
				'ion-logo-googleplus'                => 'ion-logo-googleplus',
				'ion-logo-hackernews'                => 'ion-logo-hackernews',
				'ion-logo-html5'                     => 'ion-logo-html5',
				'ion-logo-instagram'                 => 'ion-logo-instagram',
				'ion-logo-ionic'                     => 'ion-logo-ionic',
				'ion-logo-ionitron'                  => 'ion-logo-ionitron',
				'ion-logo-javascript'                => 'ion-logo-javascript',
				'ion-logo-linkedin'                  => 'ion-logo-linkedin',
				'ion-logo-markdown'                  => 'ion-logo-markdown',
				'ion-logo-model-s'                   => 'ion-logo-model-s',
				'ion-logo-no-smoking'                => 'ion-logo-no-smoking',
				'ion-logo-nodejs'                    => 'ion-logo-nodejs',
				'ion-logo-npm'                       => 'ion-logo-npm',
				'ion-logo-octocat'                   => 'ion-logo-octocat',
				'ion-logo-pinterest'                 => 'ion-logo-pinterest',
				'ion-logo-playstation'               => 'ion-logo-playstation',
				'ion-logo-polymer'                   => 'ion-logo-polymer',
				'ion-logo-python'                    => 'ion-logo-python',
				'ion-logo-reddit'                    => 'ion-logo-reddit',
				'ion-logo-rss'                       => 'ion-logo-rss',
				'ion-logo-sass'                      => 'ion-logo-sass',
				'ion-logo-skype'                     => 'ion-logo-skype',
				'ion-logo-slack'                     => 'ion-logo-slack',
				'ion-logo-snapchat'                  => 'ion-logo-snapchat',
				'ion-logo-steam'                     => 'ion-logo-steam',
				'ion-logo-tumblr'                    => 'ion-logo-tumblr',
				'ion-logo-tux'                       => 'ion-logo-tux',
				'ion-logo-twitch'                    => 'ion-logo-twitch',
				'ion-logo-twitter'                   => 'ion-logo-twitter',
				'ion-logo-usd'                       => 'ion-logo-usd',
				'ion-logo-vimeo'                     => 'ion-logo-vimeo',
				'ion-logo-vk'                        => 'ion-logo-vk',
				'ion-logo-whatsapp'                  => 'ion-logo-whatsapp',
				'ion-logo-windows'                   => 'ion-logo-windows',
				'ion-logo-wordpress'                 => 'ion-logo-wordpress',
				'ion-logo-xbox'                      => 'ion-logo-xbox',
				'ion-logo-xing'                      => 'ion-logo-xing',
				'ion-logo-yahoo'                     => 'ion-logo-yahoo',
				'ion-logo-yen'                       => 'ion-logo-yen',
				'ion-logo-youtube'                   => 'ion-logo-youtube',
				'ion-md-add'                         => 'ion-md-add',
				'ion-md-add-circle'                  => 'ion-md-add-circle',
				'ion-md-add-circle-outline'          => 'ion-md-add-circle-outline',
				'ion-md-airplane'                    => 'ion-md-airplane',
				'ion-md-alarm'                       => 'ion-md-alarm',
				'ion-md-albums'                      => 'ion-md-albums',
				'ion-md-alert'                       => 'ion-md-alert',
				'ion-md-american-football'           => 'ion-md-american-football',
				'ion-md-analytics'                   => 'ion-md-analytics',
				'ion-md-aperture'                    => 'ion-md-aperture',
				'ion-md-apps'                        => 'ion-md-apps',
				'ion-md-appstore'                    => 'ion-md-appstore',
				'ion-md-archive'                     => 'ion-md-archive',
				'ion-md-arrow-back'                  => 'ion-md-arrow-back',
				'ion-md-arrow-down'                  => 'ion-md-arrow-down',
				'ion-md-arrow-dropdown'              => 'ion-md-arrow-dropdown',
				'ion-md-arrow-dropdown-circle'       => 'ion-md-arrow-dropdown-circle',
				'ion-md-arrow-dropleft'              => 'ion-md-arrow-dropleft',
				'ion-md-arrow-dropleft-circle'       => 'ion-md-arrow-dropleft-circle',
				'ion-md-arrow-dropright'             => 'ion-md-arrow-dropright',
				'ion-md-arrow-dropright-circle'      => 'ion-md-arrow-dropright-circle',
				'ion-md-arrow-dropup'                => 'ion-md-arrow-dropup',
				'ion-md-arrow-dropup-circle'         => 'ion-md-arrow-dropup-circle',
				'ion-md-arrow-forward'               => 'ion-md-arrow-forward',
				'ion-md-arrow-round-back'            => 'ion-md-arrow-round-back',
				'ion-md-arrow-round-down'            => 'ion-md-arrow-round-down',
				'ion-md-arrow-round-forward'         => 'ion-md-arrow-round-forward',
				'ion-md-arrow-round-up'              => 'ion-md-arrow-round-up',
				'ion-md-arrow-up'                    => 'ion-md-arrow-up',
				'ion-md-at'                          => 'ion-md-at',
				'ion-md-attach'                      => 'ion-md-attach',
				'ion-md-backspace'                   => 'ion-md-backspace',
				'ion-md-barcode'                     => 'ion-md-barcode',
				'ion-md-baseball'                    => 'ion-md-baseball',
				'ion-md-basket'                      => 'ion-md-basket',
				'ion-md-basketball'                  => 'ion-md-basketball',
				'ion-md-battery-charging'            => 'ion-md-battery-charging',
				'ion-md-battery-dead'                => 'ion-md-battery-dead',
				'ion-md-battery-full'                => 'ion-md-battery-full',
				'ion-md-beaker'                      => 'ion-md-beaker',
				'ion-md-bed'                         => 'ion-md-bed',
				'ion-md-beer'                        => 'ion-md-beer',
				'ion-md-bicycle'                     => 'ion-md-bicycle',
				'ion-md-bluetooth'                   => 'ion-md-bluetooth',
				'ion-md-boat'                        => 'ion-md-boat',
				'ion-md-body'                        => 'ion-md-body',
				'ion-md-bonfire'                     => 'ion-md-bonfire',
				'ion-md-book'                        => 'ion-md-book',
				'ion-md-bookmark'                    => 'ion-md-bookmark',
				'ion-md-bookmarks'                   => 'ion-md-bookmarks',
				'ion-md-bowtie'                      => 'ion-md-bowtie',
				'ion-md-briefcase'                   => 'ion-md-briefcase',
				'ion-md-browsers'                    => 'ion-md-browsers',
				'ion-md-brush'                       => 'ion-md-brush',
				'ion-md-bug'                         => 'ion-md-bug',
				'ion-md-build'                       => 'ion-md-build',
				'ion-md-bulb'                        => 'ion-md-bulb',
				'ion-md-bus'                         => 'ion-md-bus',
				'ion-md-business'                    => 'ion-md-business',
				'ion-md-cafe'                        => 'ion-md-cafe',
				'ion-md-calculator'                  => 'ion-md-calculator',
				'ion-md-calendar'                    => 'ion-md-calendar',
				'ion-md-call'                        => 'ion-md-call',
				'ion-md-camera'                      => 'ion-md-camera',
				'ion-md-car'                         => 'ion-md-car',
				'ion-md-card'                        => 'ion-md-card',
				'ion-md-cart'                        => 'ion-md-cart',
				'ion-md-cash'                        => 'ion-md-cash',
				'ion-md-cellular'                    => 'ion-md-cellular',
				'ion-md-chatboxes'                   => 'ion-md-chatboxes',
				'ion-md-chatbubbles'                 => 'ion-md-chatbubbles',
				'ion-md-checkbox'                    => 'ion-md-checkbox',
				'ion-md-checkbox-outline'            => 'ion-md-checkbox-outline',
				'ion-md-checkmark'                   => 'ion-md-checkmark',
				'ion-md-checkmark-circle'            => 'ion-md-checkmark-circle',
				'ion-md-checkmark-circle-outline'    => 'ion-md-checkmark-circle-outline',
				'ion-md-clipboard'                   => 'ion-md-clipboard',
				'ion-md-clock'                       => 'ion-md-clock',
				'ion-md-close'                       => 'ion-md-close',
				'ion-md-close-circle'                => 'ion-md-close-circle',
				'ion-md-close-circle-outline'        => 'ion-md-close-circle-outline',
				'ion-md-cloud'                       => 'ion-md-cloud',
				'ion-md-cloud-circle'                => 'ion-md-cloud-circle',
				'ion-md-cloud-done'                  => 'ion-md-cloud-done',
				'ion-md-cloud-download'              => 'ion-md-cloud-download',
				'ion-md-cloud-outline'               => 'ion-md-cloud-outline',
				'ion-md-cloud-upload'                => 'ion-md-cloud-upload',
				'ion-md-cloudy'                      => 'ion-md-cloudy',
				'ion-md-cloudy-night'                => 'ion-md-cloudy-night',
				'ion-md-code'                        => 'ion-md-code',
				'ion-md-code-download'               => 'ion-md-code-download',
				'ion-md-code-working'                => 'ion-md-code-working',
				'ion-md-cog'                         => 'ion-md-cog',
				'ion-md-color-fill'                  => 'ion-md-color-fill',
				'ion-md-color-filter'                => 'ion-md-color-filter',
				'ion-md-color-palette'               => 'ion-md-color-palette',
				'ion-md-color-wand'                  => 'ion-md-color-wand',
				'ion-md-compass'                     => 'ion-md-compass',
				'ion-md-construct'                   => 'ion-md-construct',
				'ion-md-contact'                     => 'ion-md-contact',
				'ion-md-contacts'                    => 'ion-md-contacts',
				'ion-md-contract'                    => 'ion-md-contract',
				'ion-md-contrast'                    => 'ion-md-contrast',
				'ion-md-copy'                        => 'ion-md-copy',
				'ion-md-create'                      => 'ion-md-create',
				'ion-md-crop'                        => 'ion-md-crop',
				'ion-md-cube'                        => 'ion-md-cube',
				'ion-md-cut'                         => 'ion-md-cut',
				'ion-md-desktop'                     => 'ion-md-desktop',
				'ion-md-disc'                        => 'ion-md-disc',
				'ion-md-document'                    => 'ion-md-document',
				'ion-md-done-all'                    => 'ion-md-done-all',
				'ion-md-download'                    => 'ion-md-download',
				'ion-md-easel'                       => 'ion-md-easel',
				'ion-md-egg'                         => 'ion-md-egg',
				'ion-md-exit'                        => 'ion-md-exit',
				'ion-md-expand'                      => 'ion-md-expand',
				'ion-md-eye'                         => 'ion-md-eye',
				'ion-md-eye-off'                     => 'ion-md-eye-off',
				'ion-md-fastforward'                 => 'ion-md-fastforward',
				'ion-md-female'                      => 'ion-md-female',
				'ion-md-filing'                      => 'ion-md-filing',
				'ion-md-film'                        => 'ion-md-film',
				'ion-md-finger-print'                => 'ion-md-finger-print',
				'ion-md-fitness'                     => 'ion-md-fitness',
				'ion-md-flag'                        => 'ion-md-flag',
				'ion-md-flame'                       => 'ion-md-flame',
				'ion-md-flash'                       => 'ion-md-flash',
				'ion-md-flash-off'                   => 'ion-md-flash-off',
				'ion-md-flashlight'                  => 'ion-md-flashlight',
				'ion-md-flask'                       => 'ion-md-flask',
				'ion-md-flower'                      => 'ion-md-flower',
				'ion-md-folder'                      => 'ion-md-folder',
				'ion-md-folder-open'                 => 'ion-md-folder-open',
				'ion-md-football'                    => 'ion-md-football',
				'ion-md-funnel'                      => 'ion-md-funnel',
				'ion-md-gift'                        => 'ion-md-gift',
				'ion-md-git-branch'                  => 'ion-md-git-branch',
				'ion-md-git-commit'                  => 'ion-md-git-commit',
				'ion-md-git-compare'                 => 'ion-md-git-compare',
				'ion-md-git-merge'                   => 'ion-md-git-merge',
				'ion-md-git-network'                 => 'ion-md-git-network',
				'ion-md-git-pull-request'            => 'ion-md-git-pull-request',
				'ion-md-glasses'                     => 'ion-md-glasses',
				'ion-md-globe'                       => 'ion-md-globe',
				'ion-md-grid'                        => 'ion-md-grid',
				'ion-md-hammer'                      => 'ion-md-hammer',
				'ion-md-hand'                        => 'ion-md-hand',
				'ion-md-happy'                       => 'ion-md-happy',
				'ion-md-headset'                     => 'ion-md-headset',
				'ion-md-heart'                       => 'ion-md-heart',
				'ion-md-heart-dislike'               => 'ion-md-heart-dislike',
				'ion-md-heart-empty'                 => 'ion-md-heart-empty',
				'ion-md-heart-half'                  => 'ion-md-heart-half',
				'ion-md-help'                        => 'ion-md-help',
				'ion-md-help-buoy'                   => 'ion-md-help-buoy',
				'ion-md-help-circle'                 => 'ion-md-help-circle',
				'ion-md-help-circle-outline'         => 'ion-md-help-circle-outline',
				'ion-md-home'                        => 'ion-md-home',
				'ion-md-hourglass'                   => 'ion-md-hourglass',
				'ion-md-ice-cream'                   => 'ion-md-ice-cream',
				'ion-md-image'                       => 'ion-md-image',
				'ion-md-images'                      => 'ion-md-images',
				'ion-md-infinite'                    => 'ion-md-infinite',
				'ion-md-information'                 => 'ion-md-information',
				'ion-md-information-circle'          => 'ion-md-information-circle',
				'ion-md-information-circle-outline'  => 'ion-md-information-circle-outline',
				'ion-md-jet'                         => 'ion-md-jet',
				'ion-md-journal'                     => 'ion-md-journal',
				'ion-md-key'                         => 'ion-md-key',
				'ion-md-keypad'                      => 'ion-md-keypad',
				'ion-md-laptop'                      => 'ion-md-laptop',
				'ion-md-leaf'                        => 'ion-md-leaf',
				'ion-md-link'                        => 'ion-md-link',
				'ion-md-list'                        => 'ion-md-list',
				'ion-md-list-box'                    => 'ion-md-list-box',
				'ion-md-locate'                      => 'ion-md-locate',
				'ion-md-lock'                        => 'ion-md-lock',
				'ion-md-log-in'                      => 'ion-md-log-in',
				'ion-md-log-out'                     => 'ion-md-log-out',
				'ion-md-magnet'                      => 'ion-md-magnet',
				'ion-md-mail'                        => 'ion-md-mail',
				'ion-md-mail-open'                   => 'ion-md-mail-open',
				'ion-md-mail-unread'                 => 'ion-md-mail-unread',
				'ion-md-male'                        => 'ion-md-male',
				'ion-md-man'                         => 'ion-md-man',
				'ion-md-map'                         => 'ion-md-map',
				'ion-md-medal'                       => 'ion-md-medal',
				'ion-md-medical'                     => 'ion-md-medical',
				'ion-md-medkit'                      => 'ion-md-medkit',
				'ion-md-megaphone'                   => 'ion-md-megaphone',
				'ion-md-menu'                        => 'ion-md-menu',
				'ion-md-mic'                         => 'ion-md-mic',
				'ion-md-mic-off'                     => 'ion-md-mic-off',
				'ion-md-microphone'                  => 'ion-md-microphone',
				'ion-md-moon'                        => 'ion-md-moon',
				'ion-md-more'                        => 'ion-md-more',
				'ion-md-move'                        => 'ion-md-move',
				'ion-md-musical-note'                => 'ion-md-musical-note',
				'ion-md-musical-notes'               => 'ion-md-musical-notes',
				'ion-md-navigate'                    => 'ion-md-navigate',
				'ion-md-notifications'               => 'ion-md-notifications',
				'ion-md-notifications-off'           => 'ion-md-notifications-off',
				'ion-md-notifications-outline'       => 'ion-md-notifications-outline',
				'ion-md-nuclear'                     => 'ion-md-nuclear',
				'ion-md-nutrition'                   => 'ion-md-nutrition',
				'ion-md-open'                        => 'ion-md-open',
				'ion-md-options'                     => 'ion-md-options',
				'ion-md-outlet'                      => 'ion-md-outlet',
				'ion-md-paper'                       => 'ion-md-paper',
				'ion-md-paper-plane'                 => 'ion-md-paper-plane',
				'ion-md-partly-sunny'                => 'ion-md-partly-sunny',
				'ion-md-pause'                       => 'ion-md-pause',
				'ion-md-paw'                         => 'ion-md-paw',
				'ion-md-people'                      => 'ion-md-people',
				'ion-md-person'                      => 'ion-md-person',
				'ion-md-person-add'                  => 'ion-md-person-add',
				'ion-md-phone-landscape'             => 'ion-md-phone-landscape',
				'ion-md-phone-portrait'              => 'ion-md-phone-portrait',
				'ion-md-photos'                      => 'ion-md-photos',
				'ion-md-pie'                         => 'ion-md-pie',
				'ion-md-pin'                         => 'ion-md-pin',
				'ion-md-pint'                        => 'ion-md-pint',
				'ion-md-pizza'                       => 'ion-md-pizza',
				'ion-md-planet'                      => 'ion-md-planet',
				'ion-md-play'                        => 'ion-md-play',
				'ion-md-play-circle'                 => 'ion-md-play-circle',
				'ion-md-podium'                      => 'ion-md-podium',
				'ion-md-power'                       => 'ion-md-power',
				'ion-md-pricetag'                    => 'ion-md-pricetag',
				'ion-md-pricetags'                   => 'ion-md-pricetags',
				'ion-md-print'                       => 'ion-md-print',
				'ion-md-pulse'                       => 'ion-md-pulse',
				'ion-md-qr-scanner'                  => 'ion-md-qr-scanner',
				'ion-md-quote'                       => 'ion-md-quote',
				'ion-md-radio'                       => 'ion-md-radio',
				'ion-md-radio-button-off'            => 'ion-md-radio-button-off',
				'ion-md-radio-button-on'             => 'ion-md-radio-button-on',
				'ion-md-rainy'                       => 'ion-md-rainy',
				'ion-md-recording'                   => 'ion-md-recording',
				'ion-md-redo'                        => 'ion-md-redo',
				'ion-md-refresh'                     => 'ion-md-refresh',
				'ion-md-refresh-circle'              => 'ion-md-refresh-circle',
				'ion-md-remove'                      => 'ion-md-remove',
				'ion-md-remove-circle'               => 'ion-md-remove-circle',
				'ion-md-remove-circle-outline'       => 'ion-md-remove-circle-outline',
				'ion-md-reorder'                     => 'ion-md-reorder',
				'ion-md-repeat'                      => 'ion-md-repeat',
				'ion-md-resize'                      => 'ion-md-resize',
				'ion-md-restaurant'                  => 'ion-md-restaurant',
				'ion-md-return-left'                 => 'ion-md-return-left',
				'ion-md-return-right'                => 'ion-md-return-right',
				'ion-md-reverse-camera'              => 'ion-md-reverse-camera',
				'ion-md-rewind'                      => 'ion-md-rewind',
				'ion-md-ribbon'                      => 'ion-md-ribbon',
				'ion-md-rocket'                      => 'ion-md-rocket',
				'ion-md-rose'                        => 'ion-md-rose',
				'ion-md-sad'                         => 'ion-md-sad',
				'ion-md-save'                        => 'ion-md-save',
				'ion-md-school'                      => 'ion-md-school',
				'ion-md-search'                      => 'ion-md-search',
				'ion-md-send'                        => 'ion-md-send',
				'ion-md-settings'                    => 'ion-md-settings',
				'ion-md-share'                       => 'ion-md-share',
				'ion-md-share-alt'                   => 'ion-md-share-alt',
				'ion-md-shirt'                       => 'ion-md-shirt',
				'ion-md-shuffle'                     => 'ion-md-shuffle',
				'ion-md-skip-backward'               => 'ion-md-skip-backward',
				'ion-md-skip-forward'                => 'ion-md-skip-forward',
				'ion-md-snow'                        => 'ion-md-snow',
				'ion-md-speedometer'                 => 'ion-md-speedometer',
				'ion-md-square'                      => 'ion-md-square',
				'ion-md-square-outline'              => 'ion-md-square-outline',
				'ion-md-star'                        => 'ion-md-star',
				'ion-md-star-half'                   => 'ion-md-star-half',
				'ion-md-star-outline'                => 'ion-md-star-outline',
				'ion-md-stats'                       => 'ion-md-stats',
				'ion-md-stopwatch'                   => 'ion-md-stopwatch',
				'ion-md-subway'                      => 'ion-md-subway',
				'ion-md-sunny'                       => 'ion-md-sunny',
				'ion-md-swap'                        => 'ion-md-swap',
				'ion-md-switch'                      => 'ion-md-switch',
				'ion-md-sync'                        => 'ion-md-sync',
				'ion-md-tablet-landscape'            => 'ion-md-tablet-landscape',
				'ion-md-tablet-portrait'             => 'ion-md-tablet-portrait',
				'ion-md-tennisball'                  => 'ion-md-tennisball',
				'ion-md-text'                        => 'ion-md-text',
				'ion-md-thermometer'                 => 'ion-md-thermometer',
				'ion-md-thumbs-down'                 => 'ion-md-thumbs-down',
				'ion-md-thumbs-up'                   => 'ion-md-thumbs-up',
				'ion-md-thunderstorm'                => 'ion-md-thunderstorm',
				'ion-md-time'                        => 'ion-md-time',
				'ion-md-timer'                       => 'ion-md-timer',
				'ion-md-today'                       => 'ion-md-today',
				'ion-md-train'                       => 'ion-md-train',
				'ion-md-transgender'                 => 'ion-md-transgender',
				'ion-md-trash'                       => 'ion-md-trash',
				'ion-md-trending-down'               => 'ion-md-trending-down',
				'ion-md-trending-up'                 => 'ion-md-trending-up',
				'ion-md-trophy'                      => 'ion-md-trophy',
				'ion-md-tv'                          => 'ion-md-tv',
				'ion-md-umbrella'                    => 'ion-md-umbrella',
				'ion-md-undo'                        => 'ion-md-undo',
				'ion-md-unlock'                      => 'ion-md-unlock',
				'ion-md-videocam'                    => 'ion-md-videocam',
				'ion-md-volume-high'                 => 'ion-md-volume-high',
				'ion-md-volume-low'                  => 'ion-md-volume-low',
				'ion-md-volume-mute'                 => 'ion-md-volume-mute',
				'ion-md-volume-off'                  => 'ion-md-volume-off',
				'ion-md-walk'                        => 'ion-md-walk',
				'ion-md-wallet'                      => 'ion-md-wallet',
				'ion-md-warning'                     => 'ion-md-warning',
				'ion-md-watch'                       => 'ion-md-watch',
				'ion-md-water'                       => 'ion-md-water',
				'ion-md-wifi'                        => 'ion-md-wifi',
				'ion-md-wine'                        => 'ion-md-wine',
				'ion-md-woman'                       => 'ion-md-woman',
			);
		}

		function specific_icons() {
			return apply_filters(
				'manufaktursolutions_core_filter_ion_specific_icons',
				array(
					'search'        => 'ion-ios-search',
					'dropdown-cart' => 'ion-android-cart',
					'menu'          => 'ion-ios-menu',
					'close'         => 'ion-ios-close',
					'back-to-top'   => 'ion-chevron-up',
					'mobile-menu'   => 'ion-navicon',
					'quote'         => 'ion-quote',
					'facebook'      => 'ion-logo-facebook',
					'twitter'       => 'ion-logo-twitter',
					'linkedin'      => 'ion-logo-linkedin',
					'pinterest'     => 'ion-logo-pinterest',
					'tumblr'        => 'ion-logo-tumblr',
					'vk'            => 'ion-logo-vk',
				)
			);
		}
	}
}
