(function ( $ ) {
	'use strict';

	var shortcode = 'manufaktursolutions_core_portfolio_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	$( document ).ready(
		function () {
			qodefPortfolioList.init();
		}
	);

	var qodefPortfolioList = {
		init: function () {
			this.holder = $( '.qodef-portfolio-list.qodef-has-appear' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefPortfolioList.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentList ) {

			var $items = $currentList.find( '.qodef-e' );

			if ( $items.length ) {
				$items.each(
					function () {
						var $item = $( this );

						qodef.qodefWaitForImages.check(
							$item,
							function () {
								qodefCore.qodefIsInViewport.check(
									$item,
									function () {
										$item.addClass( 'qodef--appeared' );
									}
								);
							}
						);
					}
				);
			}
		},
	};

	qodefCore.shortcodes[shortcode].qodefPortfolioList = qodefPortfolioList;

})( jQuery );
