<?php
$portfolio_list_image = get_post_meta( get_the_ID(), 'qodef_portfolio_list_image', true );
$has_image            = ! empty( $portfolio_list_image ) || has_post_thumbnail();

if ( $has_image ) {
	$image_dimension = isset( $image_dimension ) && ! empty( $image_dimension ) && 'custom' !== $image_dimension ? esc_attr( $image_dimension['size'] ) : 'full';
	$image_url       = manufaktursolutions_core_get_list_shortcode_item_image_url( $image_dimension, $portfolio_list_image );
	$style           = ! empty( $image_url ) ? 'background-image: url( ' . esc_url( $image_url ) . ')' : '';
	?>
	<div class="qodef-e-media-image qodef--background" <?php qode_framework_inline_style( $style ); ?>>
		<?php echo manufaktursolutions_core_get_list_shortcode_item_image( $image_dimension, $portfolio_list_image ); ?>
		<?php if ( 'yes' === $image_hover_animation ) { ?>
			<span class="qodef-e-gradient-holder">
				<span class="qodef-e-gradient">
					<span class="qodef-e-gradient-dot-1"></span>
					<span class="qodef-e-gradient-dot-2"></span>
				</span>
			</span>
		<?php } ?>
	</div>
<?php } ?>
