<?php

if ( ! function_exists( 'manufaktursolutions_core_add_portfolio_single_variation_masonry_small' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_portfolio_single_variation_masonry_small( $variations ) {
		$variations['masonry-small'] = esc_html__( 'Masonry - Small', 'manufaktursolutions-core' );

		return $variations;
	}

	add_filter( 'manufaktursolutions_core_filter_portfolio_single_layout_options', 'manufaktursolutions_core_add_portfolio_single_variation_masonry_small' );
}

if ( ! function_exists( 'manufaktursolutions_core_include_masonry_for_portfolio_single_variation_masonry_small' ) ) {
	/**
	 * Function that include masonry scripts for current module layout
	 *
	 * @param string $post_type
	 *
	 * @return string
	 */
	function manufaktursolutions_core_include_masonry_for_portfolio_single_variation_masonry_small( $post_type ) {
		$portfolio_template = manufaktursolutions_core_get_post_value_through_levels( 'qodef_portfolio_single_layout' );

		if ( 'masonry-small' === $portfolio_template ) {
			$post_type = 'portfolio-item';
		}

		return $post_type;
	}

	add_filter( 'manufaktursolutions_filter_allowed_post_type_to_enqueue_masonry_scripts', 'manufaktursolutions_core_include_masonry_for_portfolio_single_variation_masonry_small' );
}
