<?php

if ( ! function_exists( 'manufaktursolutions_core_add_textual_rows_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_textual_rows_shortcode( $shortcodes ) {
		$shortcodes[] = 'ManufakturSolutionsCore_TextualRows_Shortcode';

		return $shortcodes;
	}

	add_filter( 'manufaktursolutions_core_filter_register_shortcodes', 'manufaktursolutions_core_add_textual_rows_shortcode' );
}

if ( class_exists( 'ManufakturSolutionsCore_Shortcode' ) ) {
	class ManufakturSolutionsCore_TextualRows_Shortcode extends ManufakturSolutionsCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'manufaktursolutions_core_filter_textual_rows_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'manufaktursolutions_core_filter_textual_rows_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( MANUFAKTURSOLUTIONS_CORE_SHORTCODES_URL_PATH . '/textual-rows' );
			$this->set_base( 'manufaktursolutions_core_textual_rows' );
			$this->set_name( esc_html__( 'Textual Rows', 'manufaktursolutions-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds textual rows element', 'manufaktursolutions-core' ) );
			$this->set_category( esc_html__( 'ManufakturSolutions Core', 'manufaktursolutions-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'manufaktursolutions-core' ),
				)
			);

			$options_map = manufaktursolutions_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'manufaktursolutions-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] )
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h5',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'link_target',
					'title'         => esc_html__( 'Link Target', 'manufaktursolutions-core' ),
					'options'       => manufaktursolutions_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self'
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'manufaktursolutions-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'manufaktursolutions-core' ),
						'light' => esc_html__( 'Light', 'manufaktursolutions-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Child elements', 'manufaktursolutions-core' ),
					'items'      => array(
						array(
							'field_type' => 'text',
							'name'       => 'text',
							'title'      => esc_html__( 'Text', 'manufaktursolutions-core' )
						),
						array(
							'field_type' => 'text',
							'name'       => 'title',
							'title'      => esc_html__( 'Title', 'manufaktursolutions-core' )
						),
							array(
							'field_type' => 'text',
							'name'       => 'number',
							'title'      => esc_html__( 'Number', 'manufaktursolutions-core' )
						),
						array(
							'field_type'    => 'text',
							'name'          => 'link',
							'title'         => esc_html__( 'Link', 'manufaktursolutions-core' ),
							'default_value' => ''
						),

					)
				)
			);
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'manufaktursolutions_core_textual_rows', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['this_shortcode'] = $this;

			return manufaktursolutions_core_get_template_part( 'shortcodes/textual-rows', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-textual-rows qodef-grid qodef-layout--columns qodef-gutter--no';
			$holder_classes[] = isset( $atts['layout'] ) && ! empty ( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = isset( $atts['skin'] ) && ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';

			return implode( ' ', $holder_classes );
		}
	}
}
