<?php

if ( ! function_exists( 'manufaktursolutions_core_add_social_share_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_social_share_widget( $widgets ) {
		$widgets[] = 'ManufakturSolutionsCore_Social_Share_Widget';

		return $widgets;
	}

	add_filter( 'manufaktursolutions_core_filter_register_widgets', 'manufaktursolutions_core_add_social_share_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class ManufakturSolutionsCore_Social_Share_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'manufaktursolutions_core_social_share',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'manufaktursolutions_core_social_share' );
				$this->set_name( esc_html__( 'ManufakturSolutions Social Share', 'manufaktursolutions-core' ) );
				$this->set_description( esc_html__( 'Add a social share element into widget areas', 'manufaktursolutions-core' ) );
			}
		}

		public function render( $atts ) {
			echo ManufakturSolutionsCore_Social_Share_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
