<?php

if ( ! function_exists( 'manufaktursolutions_core_add_custom_font_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_custom_font_widget( $widgets ) {
		$widgets[] = 'ManufakturSolutionsCore_Custom_Font_Widget';

		return $widgets;
	}

	add_filter( 'manufaktursolutions_core_filter_register_widgets', 'manufaktursolutions_core_add_custom_font_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class ManufakturSolutionsCore_Custom_Font_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'manufaktursolutions_core_custom_font',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'manufaktursolutions_core_custom_font' );
				$this->set_name( esc_html__( 'ManufakturSolutions Custom Font', 'manufaktursolutions-core' ) );
				$this->set_description( esc_html__( 'Add a custom font element into widget areas', 'manufaktursolutions-core' ) );
			}
		}

		public function render( $atts ) {
			echo ManufakturSolutionsCore_Custom_Font_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
