<?php

if (!function_exists('manufaktursolutions_core_add_info_section_shortcode')) {
    /**
     * Function that add shortcode into shortcodes list for registration
     *
     * @param array $shortcodes
     *
     * @return array
     */
    function manufaktursolutions_core_add_info_section_shortcode($shortcodes)
    {
        $shortcodes[] = 'ManufakturSolutionsCore_Info_Section_Shortcode';

        return $shortcodes;
    }

    add_filter('manufaktursolutions_core_filter_register_shortcodes', 'manufaktursolutions_core_add_info_section_shortcode');
}

if (class_exists('ManufakturSolutionsCore_Shortcode')) {
    class ManufakturSolutionsCore_Info_Section_Shortcode extends ManufakturSolutionsCore_Shortcode
    {

        public function __construct()
        {
            $this->set_layouts(apply_filters('manufaktursolutions_core_filter_info_section_layouts', array()));

            $options_map = manufaktursolutions_core_get_variations_options_map($this->get_layouts());
            $default_value = $options_map['default_value'];

            $this->set_extra_options(apply_filters('manufaktursolutions_core_filter_info_section_extra_options', array(), $default_value));

            parent::__construct();
        }

        public function map_shortcode()
        {
            $this->set_shortcode_path(MANUFAKTURSOLUTIONS_CORE_SHORTCODES_URL_PATH . '/info-section');
            $this->set_base('manufaktursolutions_core_info_section');
            $this->set_name(esc_html__('Info Section', 'manufaktursolutions-core'));
            $this->set_description(esc_html__('Shortcode that adds info section element', 'manufaktursolutions-core'));
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'custom_class',
                    'title' => esc_html__('Custom Class', 'manufaktursolutions-core'),
                )
            );

            $options_map = manufaktursolutions_core_get_variations_options_map($this->get_layouts());

            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'layout',
                    'title' => esc_html__('Layout', 'manufaktursolutions-core'),
                    'options' => $this->get_layouts(),
                    'default_value' => $options_map['default_value'],
                    'visibility' => array(
                        'map_for_page_builder' => $options_map['visibility'],
                    ),
                )
            );
             $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'skin',
                    'title' => esc_html__('Skin', 'manufaktursolutions-core'),
                    'options' => array(
                        '' => esc_html__('Default', 'manufaktursolutions-core'),
                        'dark' => esc_html__('Dark', 'manufaktursolutions-core'),
                    ),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'image',
                    'name' => 'image',
                    'title' => esc_html__('Image', 'manufaktursolutions-core'),
                )
            );

            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'title',
                    'title' => esc_html__('Title', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Title Text', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'title_tag',
                    'title' => esc_html__('Title Tag', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('title_tag'),
                    'default_value' => 'h5',
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'line_break_positions',
                    'title' => esc_html__('Positions of Line Break', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'manufaktursolutions-core'),
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'disable_title_break_words',
                    'title' => esc_html__('Disable Title Line Break', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enabling this option will disable title line breaks for screen size 1024 and lower', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('no_yes', false),
                    'default_value' => 'no',
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'title_color',
                    'title' => esc_html__('Title Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Title Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'subtitle',
                    'title' => esc_html__('Subtitle', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Subtitle Text', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'subtitle_color',
                    'title' => esc_html__('Subtitle Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Subtitle Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'subtitle_line_break_positions',
                    'title' => esc_html__('Positions of Line Break', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'manufaktursolutions-core'),
                    'group' => esc_html__('Subtitle Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'select',
                    'name' => 'subtitle_disable_title_break_words',
                    'title' => esc_html__('Disable Title Line Break', 'manufaktursolutions-core'),
                    'description' => esc_html__('Enabling this option will disable subtitle line breaks for screen size 1024 and lower', 'manufaktursolutions-core'),
                    'options' => manufaktursolutions_core_get_select_type_options_pool('no_yes', false),
                    'default_value' => 'no',
                    'group' => esc_html__('Subtitle Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'text',
                    'name' => 'number',
                    'title' => esc_html__('Number', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('100', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'number_color',
                    'title' => esc_html__('Number Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Number Style', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'textarea',
                    'name' => 'info_text',
                    'title' => esc_html__('Text', 'manufaktursolutions-core'),
                    'default_value' => esc_html__('Contrary to popular belief, Lorem Ipsum is not simply random text.', 'manufaktursolutions-core'),
                )
            );
            $this->set_option(
                array(
                    'field_type' => 'color',
                    'name' => 'info_text_color',
                    'title' => esc_html__('Text Color', 'manufaktursolutions-core'),
                    'group' => esc_html__('Text Style', 'manufaktursolutions-core'),
                )
            );

            $this->map_extra_options();
        }

        public function render($options, $content = null)
        {
            parent::render($options);
            $atts = $this->get_atts();

            $atts['holder_classes'] = $this->get_holder_classes($atts);
            $atts['title'] = $this->get_modified_title($atts);
            $atts['subtitle'] = $this->get_modified_subtitle($atts);
            $atts['title_styles'] = $this->get_title_styles($atts);
            $atts['subtitle_styles'] = $this->get_subtitle_styles($atts);
            $atts['number_styles'] = $this->get_number_styles($atts);
            $atts['text_styles'] = $this->get_text_styles($atts);

            $atts = apply_filters('manufaktursolutions_core_filter_info_section_variation_atts', $atts);

            return manufaktursolutions_core_get_template_part('shortcodes/info-section', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts);
        }

        private function get_holder_classes($atts)
        {
            $holder_classes = $this->init_holder_classes();

            $holder_classes[] = 'qodef-info-section';
            $holder_classes[] = !empty($atts['layout']) ? 'qodef-layout--' . $atts['layout'] : '';
            $holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';
            $holder_classes[] = isset($atts['skin']) && !empty($atts['skin']) ? 'qodef-skin--' . $atts['skin'] : '';
            $holder_classes = apply_filters('manufaktursolutions_core_filter_info_section_variation_classes', $holder_classes, $atts);

            return implode(' ', $holder_classes);
        }


        private function get_modified_title($atts)
        {
            $title = $atts['title'];

            if (!empty($title) && !empty($atts['line_break_positions'])) {
                $split_title = explode(' ', $title);
                $line_break_positions = explode(',', str_replace(' ', '', $atts['line_break_positions']));

                foreach ($line_break_positions as $position) {
                    $position = intval($position);
                    if (isset($split_title[$position - 1]) && !empty($split_title[$position - 1])) {
                        $split_title[$position - 1] = $split_title[$position - 1] . '<br />';
                    }
                }

                $title = implode(' ', $split_title);
            }

            return $title;
        }

        private function get_modified_subtitle($atts)
        {
            $subtitle = $atts['subtitle'];

            if (!empty($subtitle) && !empty($atts['subtitle_line_break_positions'])) {
                $split_subtitle = explode(' ', $subtitle);
                $subtitle_line_break_positions = explode(',', str_replace(' ', '', $atts['subtitle_line_break_positions']));

                foreach ($subtitle_line_break_positions as $position) {
                    $position = intval($position);
                    if (isset($split_subtitle[$position - 1]) && !empty($split_subtitle[$position - 1])) {
                        $split_subtitle[$position - 1] = $split_subtitle[$position - 1] . '<br />';
                    }
                }

                $subtitle = implode(' ', $split_subtitle);
            }

            return $subtitle;
        }

        private function get_title_styles($atts)
        {
            $styles = array();

            if (!empty($atts['title_color'])) {
                $styles[] = 'color: ' . $atts['title_color'];
            }

            return $styles;
        }

        private function get_subtitle_styles($atts)
        {
            $styles = array();

            if (!empty($atts['subtitle_color'])) {
                $styles[] = 'color: ' . $atts['subtitle_color'];
            }

            return $styles;
        }

        private function get_number_styles($atts)
        {
            $styles = array();

            if (!empty($atts['number_color'])) {
                $styles[] = 'color: ' . $atts['number_color'];
            }

            return $styles;
        }

        private function get_text_styles($atts)
        {
            $styles = array();

            if (!empty($atts['info_text_color'])) {
                $styles[] = 'color: ' . $atts['info_text_color'];
            }

            return $styles;
        }

    }
}
