<?php

if ( ! function_exists( 'manufaktursolutions_core_add_side_area_opener_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_side_area_opener_widget( $widgets ) {
		$widgets[] = 'ManufakturSolutionsCore_Side_Area_Opener_Widget';

		return $widgets;
	}

	add_filter( 'manufaktursolutions_core_filter_register_widgets', 'manufaktursolutions_core_add_side_area_opener_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class ManufakturSolutionsCore_Side_Area_Opener_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'manufaktursolutions_core_side_area_opener' );
			$this->set_name( esc_html__( 'ManufakturSolutions Side Area Opener', 'manufaktursolutions-core' ) );
			$this->set_description( esc_html__( 'Display a "hamburger" icon that opens the side area', 'manufaktursolutions-core' ) );
			$this->set_widget_option(
				array(
					'field_type'  => 'text',
					'name'        => 'sidea_area_opener_margin',
					'title'       => esc_html__( 'Opener Margin', 'manufaktursolutions-core' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left', 'manufaktursolutions-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'color',
					'name'       => 'side_area_opener_color',
					'title'      => esc_html__( 'Opener Color', 'manufaktursolutions-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'color',
					'name'       => 'side_area_opener_hover_color',
					'title'      => esc_html__( 'Opener Hover Color', 'manufaktursolutions-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'color',
					'name'       => 'side_area_opener_background_color',
					'title'      => esc_html__( 'Opener Background Color', 'manufaktursolutions-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'color',
					'name'       => 'side_area_opener_background_hover_color',
					'title'      => esc_html__( 'Opener Background Hover Color', 'manufaktursolutions-core' ),
				)
			);
			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'side_area_opener_width',
					'title'      => esc_html__( 'Opener Width', 'manufaktursolutions-core' ),
				)
			);
		}

		public function render( $atts ) {
			$styles = array();

			if ( ! empty( $atts['side_area_opener_color'] ) ) {
				$styles[] = 'color: ' . $atts['side_area_opener_color'] . ';';
			}

			if ( ! empty( $atts['side_area_opener_background_color'] ) ) {
				$styles[] = 'background-color: ' . $atts['side_area_opener_background_color'] . ';';
			}

			if ( ! empty( $atts['side_area_opener_background_hover_color'] ) ) {
				$styles[] = '--sidearea-hover-background: ' . $atts['side_area_opener_background_hover_color'] . ';';
			}

			if ( ! empty( $atts['sidea_area_opener_margin'] ) ) {
				$styles[] = 'margin: ' . $atts['sidea_area_opener_margin'];
			}


			if ( ! empty( $atts['side_area_opener_width'] ) ) {
				if ( qode_framework_string_ends_with_space_units( $atts['side_area_opener_width'] ) ) {
					$styles[] = 'width: ' . $atts['side_area_opener_width'];
				} else {
					$styles[] = 'width: ' . intval( $atts['side_area_opener_width'] ) . 'px';
				}
			}

			manufaktursolutions_core_get_opener_icon_html(
				array(
					'option_name'  => 'side_area',
					'custom_class' => 'qodef-side-area-opener',
					'inline_style' => $styles,
					'inline_attr'  => qode_framework_get_inline_attr( $atts['side_area_opener_hover_color'], 'data-hover-color' ),
				)
			);
		}
	}
}
