<?php

if ( ! function_exists( 'manufaktursolutions_core_add_sticky_sidebar_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function manufaktursolutions_core_add_sticky_sidebar_widget( $widgets ) {
		$widgets[] = 'ManufakturSolutionsCore_Sticky_Sidebar_Widget';

		return $widgets;
	}

	add_filter( 'manufaktursolutions_core_filter_register_widgets', 'manufaktursolutions_core_add_sticky_sidebar_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class ManufakturSolutionsCore_Sticky_Sidebar_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'manufaktursolutions_core_sticky_sidebar' );
			$this->set_name( esc_html__( 'ManufakturSolutions Sticky Sidebar', 'manufaktursolutions-core' ) );
			$this->set_description( esc_html__( 'Use this widget to make the sidebar sticky. Drag it into the sidebar above the widget which you want to be the first element in the sticky sidebar', 'manufaktursolutions-core' ) );
		}

		public function load_assets() {
			wp_enqueue_script( 'gsap' );
		}

		public function render( $atts ) {
		}
	}
}
