<?php include 'header.php'; ?>

<!-- Popup Structure -->
<div class="popup-overlay" id="popupOverlay">
    <div class="custom-popup text-center">
      <button class="btn-close btn-close-white float-end" id="closePopup"></button>
      <h2>Stay Tuned: Something Big is Coming</h2>
      <p>We’re gearing up for an exciting event that’s just around the corner!</p>
      <img src="img/popup/coming-soon.jpg" alt="App Features">
      <div class="mt-3">
        <button class="btn btn-light">Book Event Tickets</button>

      </div>
    </div>
  </div>

<div class="alert-box p-3" id="alertBox">
    <h6>
       Join us at the "Oru Tea Sapdalama?" - Event on Jan 26, 2025 🎉
    </h6>
    <button class="close-btn" onclick="closeAlert()">
        <svg xmlns="http://www.w3.org/2000/svg" class="pb-1" viewBox="0 0 24 24" width="20" height="20" fill="white">
            <path
                d="M6.225 4.811L4.811 6.225 10.586 12l-5.775 5.775 1.414 1.414L12 13.414l5.775 5.775 1.414-1.414L13.414 12l5.775-5.775-1.414-1.414L12 10.586 6.225 4.811z" />
        </svg>
    </button>
</div>



<!-- Sider  -->



<div class="custom-carousel-container" id="slider">
    <div class="custom-carousel-track">
        <div class="custom-carousel-item"><img
            src="img/banners/1.jpg"
            alt="Banner 1"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/2.jpg"
            alt="Banner 2"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/3.jpg"
            alt="Banner 3"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/4.jpg"
            alt="Banner 4"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/5.jpg"
            alt="Banner 5"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/6.jpg"
            alt="Banner 6"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/7.jpg"
            alt="Banner 7"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/8.jpg"
            alt="Banner 8"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/9.jpg"
            alt="Banner 9"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/10.jpg"
            alt="Banner 10"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/11.jpg"
            alt="Banner 11"></div>
        <div class="custom-carousel-item"><img
            src="img/banners/12.jpg"
            alt="Banner 12"></div>
        
      
    </div>
    <div class="custom-carousel-controls">
        <button class="custom-control custom-prev">
            &lt;
            <!-- <svg width="12" height="14" viewBox="0 0 12 22" fill="white" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M10.8995 2.51707C11.29 2.12655 11.29 1.49338 10.8995 1.10286C10.509 0.712334 9.8758 0.712334 9.48528 1.10286L0.292888 10.2952C-0.0976366 10.6858 -0.0976363 11.3189 0.292888 11.7095L9.48528 20.9018C9.8758 21.2924 10.509 21.2924 10.8995 20.9018C11.29 20.5113 11.29 19.8782 10.8995 19.4876L2.41421 11.0024L10.8995 2.51707Z"
                    fill="white"></path>
            </svg> -->
        </button>
        <button class="custom-control custom-next">&gt;</button>
    </div>
</div>


<div class="container-fluid my-3">
    <!-- Section Heading -->
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card mb-4" style="background-image: url('20885277.jpg'); background-size: cover; background-position: center; border: none; border-radius: 12px;">
                <div class="card-body text-white" style="padding: 2rem 2rem; background-color: rgba(0, 0, 0, 0.6); border-radius: 12px;">
                    <div class="row align-items-center">
                        <!-- Text Column (70%) -->
                        <div class="col-8">
                            <h2 class="fw-bold">Checkout Our Previous Event</h2>
                            <p class="text-light">See the highlights of our recent events.</p>
                        </div>
                        <!-- Button Column (30%) -->
                        <div class="col-4 text-end">
                            <a class="btn btn-primary btn-lg" href="#" style="color: white;">View More</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- section -->


 <section class="container py-5">
    <div class="row align-items-center">
      <!-- Images Section -->
      <div class="col-md-6 d-flex">
        <div class="row g-3">
          <div class="col-6">
            <img src="https://via.placeholder.com/300" class="img-fluid rounded" alt="Live Event">
          </div>
          <div class="col-6">
            <img src="https://via.placeholder.com/300" class="img-fluid rounded" alt="Audience Enjoying">
          </div>
        </div>
      </div>

      <!-- Text Section -->
      <div class="col-md-6 text-md-start text-center mt-4 mt-md-0">
        <p class="section-title text-muted mb-2">Discover OTS</p>
        <h2 class="fw-bold mb-3">We Bring Experiences to Life, On The Spot</h2>
        <p class="text-muted about-content mb-4">
          OTS specializes in creating unforgettable moments, whether it's live music, premium drinks, or an electrifying ambiance. We're here to ensure every moment is memorable.
        </p>
        <p class="opening-hours text-muted">
          <strong>Operating Hours:</strong><br>
          <strong>Mon-Thu:</strong> 4 PM  12 AM<br>
          <strong>Fri-Sun:</strong> 2 PM  2 AM
        </p>
        <a href="#about-ots" class="btn about-us-btn px-4 py-2 mt-3">Learn More</a>
      </div>
    </div>
  </section>




<div class="container mt-3">
    <a href="#" style="text-decoration: none;">
        <div style="border-radius: 32px;" class="card card-section img-fluid text-white overflow-hidden">
            <img style="border-radius: 32px;" class="card-img-top"
                src="img/events/TN-Story-Banner-1713784128283.avif"
                alt="Card image" style="width:100%">
        </div>
    </a>
</div>




<!-- drag box -->
<div class="container mt-5 drag-box">
    <div class="p-4">
        <h4 class="ps-1 dragbox-title">
            <svg width="32" height="33" viewBox="0 0 32 33" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M11.7286 25.9778C10.9759 24.9941 10.6667 23.73 10.6667 22.466C10.6667 20.015 11.8063 16.4449 16.1674 15.8441C16.8969 15.7436 17.4752 16.3635 17.5947 17.0947C17.8323 18.548 18.4819 19.113 19.2169 19.7522C19.7818 20.2435 20.3972 20.7788 20.9146 21.795C21.5848 23.1114 21.4266 24.5891 20.6109 25.7532C22.6874 24.2984 24 21.8285 24 18.8549C24 15.5306 22.6534 13.0302 20.7299 10.6784C20.7075 10.6989 20.6837 10.726 20.662 10.7602C20.6222 10.8231 20.5958 10.9 20.5934 10.9895C20.5682 11.9561 20.3642 13.1489 19.4591 13.9428C19.0825 14.2732 18.5959 14.4669 18.0639 14.4331C17.5618 14.4012 17.1579 14.1763 16.8753 13.934C16.3314 13.4676 16.0046 12.7514 15.9629 12.0424C15.7839 8.99874 14.9905 7.23474 14.2801 6.23989C13.6421 8.3642 12.2869 10.3195 11.0813 12.0588L11.0811 12.0592C10.8885 12.3371 10.6997 12.6095 10.5183 12.8761C9.05593 15.0256 7.99999 16.8786 7.99999 18.8549C7.99999 21.9875 9.45669 24.5611 11.7286 25.9778ZM25.3333 18.8549C25.3333 24.3664 21.3333 28.5 16 28.5C10.6667 28.5 6.66666 24.3664 6.66666 18.8549C6.66666 16.0991 8.33332 13.6879 9.99999 11.2766C11.2754 9.4313 12.5509 7.58601 13.0794 5.58635C13.3192 4.6791 14.1953 4.12292 14.8256 4.80129C15.8489 5.90257 17.0621 8.02122 17.294 11.9641C17.3386 12.7237 18.0185 13.4329 18.5799 12.9405C19.0491 12.5289 19.2377 11.8275 19.2605 10.9546C19.2962 9.59187 20.8413 8.71678 21.6966 9.75463C23.7612 12.2596 25.3333 15.0698 25.3333 18.8549ZM16.1323 26.5C14.4113 26.5 13.4463 25.9472 12.8875 25.2913C12.2962 24.5973 12 23.599 12 22.466C12 21.4199 12.2475 20.1887 12.8988 19.1891C13.5055 18.2579 14.5094 17.4476 16.2355 17.1815L16.2395 17.1891C16.2572 17.2232 16.2715 17.2649 16.2788 17.3098C16.409 18.1059 16.6506 18.7473 16.9945 19.2944C17.3322 19.8314 17.7324 20.218 18.0776 20.5263C18.1729 20.6115 18.2647 20.6917 18.3531 20.7691L18.3532 20.7691C18.9053 21.252 19.3319 21.6252 19.7264 22.4C20.1672 23.2657 20.0663 24.2395 19.4859 25.0342C18.9075 25.8264 17.7921 26.5 16.1323 26.5Z"
                    fill="#0c172f"></path>
            </svg>
            Step Into Our Eventful History
        </h4>
    </div>
    <div class="carousel-wrap">
        <div class="owl-carousel">
            <div class="item">
                <div class="item-overlay">
                    <h6>Past Events</h6>
                </div>
                <div class="card bg-white" data-event-type="past">
                    <img src="img/events/Event-01.jpg"
                        class="card-img-top" alt="buddy">
                    <div class="card-body">
                        <h5 class="card-title fw-bold">A Stranger Turned Close Friend</h5>
                        <h6 class="card-text">
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 5.5L6.5 5.5V5C6.5 4.17157 7.17157 3.5 8 3.5C8.82843 3.5 9.5 4.17157 9.5 5V5.5L12.5 5.5V5C12.5 4.17157 13.1716 3.5 14 3.5C14.8284 3.5 15.5 4.17157 15.5 5V5.5H16.5C17.8807 5.5 19 6.61929 19 8V10.6429C19 10.919 18.7761 11.1429 18.5 11.1429C18.2239 11.1429 18 10.919 18 10.6429V10.5H4L4 17C4 17.8284 4.67157 18.5 5.5 18.5L9.5 18.5C9.77614 18.5 10 18.7239 10 19C10 19.2761 9.77614 19.5 9.5 19.5H5.5C4.11929 19.5 3 18.3807 3 17V8C3 6.61929 4.11929 5.5 5.5 5.5ZM7.5 5V7C7.5 7.27614 7.72386 7.5 8 7.5C8.27614 7.5 8.5 7.27614 8.5 7V5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5ZM14.5 5C14.5 4.72386 14.2761 4.5 14 4.5C13.7239 4.5 13.5 4.72386 13.5 5V7C13.5 7.27614 13.7239 7.5 14 7.5C14.2761 7.5 14.5 7.27614 14.5 7V5ZM12.5 6.5V7C12.5 7.82843 13.1716 8.5 14 8.5C14.8284 8.5 15.5 7.82843 15.5 7V6.5L16.5 6.5C17.3284 6.5 18 7.17157 18 8V9.5H4L4 8C4 7.17157 4.67157 6.5 5.5 6.5H6.5V7C6.5 7.82843 7.17157 8.5 8 8.5C8.82843 8.5 9.5 7.82843 9.5 7V6.5L12.5 6.5Z" fill="#45474D"></path><path d="M16 17C15.7239 17 15.5 16.7761 15.5 16.5V14C15.5 13.7239 15.7239 13.5 16 13.5C16.2761 13.5 16.5 13.7239 16.5 14V16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H16Z" fill="#45474D"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 21.5C18.7614 21.5 21 19.2614 21 16.5C21 13.7386 18.7614 11.5 16 11.5C13.2386 11.5 11 13.7386 11 16.5C11 19.2614 13.2386 21.5 16 21.5ZM16 20.5C18.2091 20.5 20 18.7091 20 16.5C20 14.2909 18.2091 12.5 16 12.5C13.7909 12.5 12 14.2909 12 16.5C12 18.7091 13.7909 20.5 16 20.5Z" fill="#45474D"></path></svg>
                            September 15th  2024 | 4:30 PM
                        </h6>
                        <h6 class="card-text">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="css-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 10.0714C5.5 6.2881 8.96304 4 12 4C15.037 4 18.5 6.2881 18.5 10.0714C18.5 12.4463 17.3299 14.5887 15.8656 16.3303C14.4439 18.0211 12.8224 19.2405 12 19.8053C11.1776 19.2405 9.55612 18.0211 8.13442 16.3303C6.67006 14.5887 5.5 12.4463 5.5 10.0714ZM4.5 10.0714C4.5 5.57143 8.59091 3 12 3C15.4091 3 19.5 5.57143 19.5 10.0714C19.5 15.4847 14.1819 19.5305 12.5021 20.6734C12.1968 20.8812 11.8032 20.8812 11.4979 20.6734C9.81808 19.5305 4.5 15.4847 4.5 10.0714ZM10 10.5C10 9.39543 10.8954 8.5 12 8.5C13.1046 8.5 14 9.39543 14 10.5C14 11.6046 13.1046 12.5 12 12.5C10.8954 12.5 10 11.6046 10 10.5ZM12 7.5C10.3431 7.5 9 8.84315 9 10.5C9 12.1569 10.3431 13.5 12 13.5C13.6569 13.5 15 12.1569 15 10.5C15 8.84315 13.6569 7.5 12 7.5Z" fill="#45474D"></path></svg>
                            Location Not Disclosed
                        </h6>
                    </div>
                    <div class="footer-card d-flex justify-content-between">
                        <p class="card-footer-content">Event Finished</p>
                        <p class="card-footer-content">
  <a href="#" class="btn btn-danger">View Gallery</a>
</p>

                    </div>
                </div>
            </div>
            <div class="item">
                <div class="item-overlay">
                    <h6>Past Events</h6>
                </div>
                <div class="card bg-white" data-event-type="past">
                    <img src="img/events/Event-02.jpg""
                        class="card-img-top" alt="buddy">
                    <div class="card-body">
                        <h5 class="card-title fw-bold">Happy Childhood Moments</h5>
                        <h6 class="card-text">
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 5.5L6.5 5.5V5C6.5 4.17157 7.17157 3.5 8 3.5C8.82843 3.5 9.5 4.17157 9.5 5V5.5L12.5 5.5V5C12.5 4.17157 13.1716 3.5 14 3.5C14.8284 3.5 15.5 4.17157 15.5 5V5.5H16.5C17.8807 5.5 19 6.61929 19 8V10.6429C19 10.919 18.7761 11.1429 18.5 11.1429C18.2239 11.1429 18 10.919 18 10.6429V10.5H4L4 17C4 17.8284 4.67157 18.5 5.5 18.5L9.5 18.5C9.77614 18.5 10 18.7239 10 19C10 19.2761 9.77614 19.5 9.5 19.5H5.5C4.11929 19.5 3 18.3807 3 17V8C3 6.61929 4.11929 5.5 5.5 5.5ZM7.5 5V7C7.5 7.27614 7.72386 7.5 8 7.5C8.27614 7.5 8.5 7.27614 8.5 7V5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5ZM14.5 5C14.5 4.72386 14.2761 4.5 14 4.5C13.7239 4.5 13.5 4.72386 13.5 5V7C13.5 7.27614 13.7239 7.5 14 7.5C14.2761 7.5 14.5 7.27614 14.5 7V5ZM12.5 6.5V7C12.5 7.82843 13.1716 8.5 14 8.5C14.8284 8.5 15.5 7.82843 15.5 7V6.5L16.5 6.5C17.3284 6.5 18 7.17157 18 8V9.5H4L4 8C4 7.17157 4.67157 6.5 5.5 6.5H6.5V7C6.5 7.82843 7.17157 8.5 8 8.5C8.82843 8.5 9.5 7.82843 9.5 7V6.5L12.5 6.5Z" fill="#45474D"></path><path d="M16 17C15.7239 17 15.5 16.7761 15.5 16.5V14C15.5 13.7239 15.7239 13.5 16 13.5C16.2761 13.5 16.5 13.7239 16.5 14V16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H16Z" fill="#45474D"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 21.5C18.7614 21.5 21 19.2614 21 16.5C21 13.7386 18.7614 11.5 16 11.5C13.2386 11.5 11 13.7386 11 16.5C11 19.2614 13.2386 21.5 16 21.5ZM16 20.5C18.2091 20.5 20 18.7091 20 16.5C20 14.2909 18.2091 12.5 16 12.5C13.7909 12.5 12 14.2909 12 16.5C12 18.7091 13.7909 20.5 16 20.5Z" fill="#45474D"></path></svg>
                        November 10th  2024  | 4:30 PM
                        </h6>
                        <h6 class="card-text">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="css-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 10.0714C5.5 6.2881 8.96304 4 12 4C15.037 4 18.5 6.2881 18.5 10.0714C18.5 12.4463 17.3299 14.5887 15.8656 16.3303C14.4439 18.0211 12.8224 19.2405 12 19.8053C11.1776 19.2405 9.55612 18.0211 8.13442 16.3303C6.67006 14.5887 5.5 12.4463 5.5 10.0714ZM4.5 10.0714C4.5 5.57143 8.59091 3 12 3C15.4091 3 19.5 5.57143 19.5 10.0714C19.5 15.4847 14.1819 19.5305 12.5021 20.6734C12.1968 20.8812 11.8032 20.8812 11.4979 20.6734C9.81808 19.5305 4.5 15.4847 4.5 10.0714ZM10 10.5C10 9.39543 10.8954 8.5 12 8.5C13.1046 8.5 14 9.39543 14 10.5C14 11.6046 13.1046 12.5 12 12.5C10.8954 12.5 10 11.6046 10 10.5ZM12 7.5C10.3431 7.5 9 8.84315 9 10.5C9 12.1569 10.3431 13.5 12 13.5C13.6569 13.5 15 12.1569 15 10.5C15 8.84315 13.6569 7.5 12 7.5Z" fill="#45474D"></path></svg>
    Location Not Disclosed
                        </h6>
                    </div>
                    <div class="footer-card d-flex justify-content-between">
                        <p class="card-footer-content">Event Finished</p>
                       <p class="card-footer-content">
  <a href="#" class="btn btn-danger">View Gallery</a>
</p>

                    </div>
                </div>
            </div>
            <div class="item">
                <div class="item-overlay">
                    <h6>Past Events</h6>
                </div>
                <div class="card bg-white" data-event-type="past">
                    <img src="img/events/Event-03.jpg""
                        class="card-img-top" alt="buddy">
                    <div class="card-body">
                        <h5 class="card-title fw-bold">Joyful Rain Memories</h5>
                        <h6 class="card-text">
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 5.5L6.5 5.5V5C6.5 4.17157 7.17157 3.5 8 3.5C8.82843 3.5 9.5 4.17157 9.5 5V5.5L12.5 5.5V5C12.5 4.17157 13.1716 3.5 14 3.5C14.8284 3.5 15.5 4.17157 15.5 5V5.5H16.5C17.8807 5.5 19 6.61929 19 8V10.6429C19 10.919 18.7761 11.1429 18.5 11.1429C18.2239 11.1429 18 10.919 18 10.6429V10.5H4L4 17C4 17.8284 4.67157 18.5 5.5 18.5L9.5 18.5C9.77614 18.5 10 18.7239 10 19C10 19.2761 9.77614 19.5 9.5 19.5H5.5C4.11929 19.5 3 18.3807 3 17V8C3 6.61929 4.11929 5.5 5.5 5.5ZM7.5 5V7C7.5 7.27614 7.72386 7.5 8 7.5C8.27614 7.5 8.5 7.27614 8.5 7V5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5ZM14.5 5C14.5 4.72386 14.2761 4.5 14 4.5C13.7239 4.5 13.5 4.72386 13.5 5V7C13.5 7.27614 13.7239 7.5 14 7.5C14.2761 7.5 14.5 7.27614 14.5 7V5ZM12.5 6.5V7C12.5 7.82843 13.1716 8.5 14 8.5C14.8284 8.5 15.5 7.82843 15.5 7V6.5L16.5 6.5C17.3284 6.5 18 7.17157 18 8V9.5H4L4 8C4 7.17157 4.67157 6.5 5.5 6.5H6.5V7C6.5 7.82843 7.17157 8.5 8 8.5C8.82843 8.5 9.5 7.82843 9.5 7V6.5L12.5 6.5Z" fill="#45474D"></path><path d="M16 17C15.7239 17 15.5 16.7761 15.5 16.5V14C15.5 13.7239 15.7239 13.5 16 13.5C16.2761 13.5 16.5 13.7239 16.5 14V16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H16Z" fill="#45474D"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 21.5C18.7614 21.5 21 19.2614 21 16.5C21 13.7386 18.7614 11.5 16 11.5C13.2386 11.5 11 13.7386 11 16.5C11 19.2614 13.2386 21.5 16 21.5ZM16 20.5C18.2091 20.5 20 18.7091 20 16.5C20 14.2909 18.2091 12.5 16 12.5C13.7909 12.5 12 14.2909 12 16.5C12 18.7091 13.7909 20.5 16 20.5Z" fill="#45474D"></path></svg>
                            December 7th  2024 | 4:30 PM
                        </h6>
                        <h6 class="card-text">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="css-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 10.0714C5.5 6.2881 8.96304 4 12 4C15.037 4 18.5 6.2881 18.5 10.0714C18.5 12.4463 17.3299 14.5887 15.8656 16.3303C14.4439 18.0211 12.8224 19.2405 12 19.8053C11.1776 19.2405 9.55612 18.0211 8.13442 16.3303C6.67006 14.5887 5.5 12.4463 5.5 10.0714ZM4.5 10.0714C4.5 5.57143 8.59091 3 12 3C15.4091 3 19.5 5.57143 19.5 10.0714C19.5 15.4847 14.1819 19.5305 12.5021 20.6734C12.1968 20.8812 11.8032 20.8812 11.4979 20.6734C9.81808 19.5305 4.5 15.4847 4.5 10.0714ZM10 10.5C10 9.39543 10.8954 8.5 12 8.5C13.1046 8.5 14 9.39543 14 10.5C14 11.6046 13.1046 12.5 12 12.5C10.8954 12.5 10 11.6046 10 10.5ZM12 7.5C10.3431 7.5 9 8.84315 9 10.5C9 12.1569 10.3431 13.5 12 13.5C13.6569 13.5 15 12.1569 15 10.5C15 8.84315 13.6569 7.5 12 7.5Z" fill="#45474D"></path></svg>
    Location Not Disclosed
                        </h6>
                    </div>
                    <div class="footer-card d-flex justify-content-between">
                        <p class="card-footer-content">Event Finished</p>
                        <p class="card-footer-content">
  <a href="#" class="btn btn-danger">View Gallery</a>
</p>

                    </div>
                </div>
            </div>
            <div class="item">
                <div class="item-overlay">
                    <h6>Recent Events</h6>
                </div>
                <div class="card bg-white" data-event-type="recent">
                    <img src="img/events/Event-04.jpg" class="card-img-top" alt="buddy">
                    <div class="card-body">
                        <h5 class="card-title fw-bold">Your Most Relatable Meme/Reel Of 2024</h5>
                        <h6 class="card-text">
    <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 5.5L6.5 5.5V5C6.5 4.17157 7.17157 3.5 8 3.5C8.82843 3.5 9.5 4.17157 9.5 5V5.5L12.5 5.5V5C12.5 4.17157 13.1716 3.5 14 3.5C14.8284 3.5 15.5 4.17157 15.5 5V5.5H16.5C17.8807 5.5 19 6.61929 19 8V10.6429C19 10.919 18.7761 11.1429 18.5 11.1429C18.2239 11.1429 18 10.919 18 10.6429V10.5H4L4 17C4 17.8284 4.67157 18.5 5.5 18.5L9.5 18.5C9.77614 18.5 10 18.7239 10 19C10 19.2761 9.77614 19.5 9.5 19.5H5.5C4.11929 19.5 3 18.3807 3 17V8C3 6.61929 4.11929 5.5 5.5 5.5ZM7.5 5V7C7.5 7.27614 7.72386 7.5 8 7.5C8.27614 7.5 8.5 7.27614 8.5 7V5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5ZM14.5 5C14.5 4.72386 14.2761 4.5 14 4.5C13.7239 4.5 13.5 4.72386 13.5 5V7C13.5 7.27614 13.7239 7.5 14 7.5C14.2761 7.5 14.5 7.27614 14.5 7V5ZM12.5 6.5V7C12.5 7.82843 13.1716 8.5 14 8.5C14.8284 8.5 15.5 7.82843 15.5 7V6.5L16.5 6.5C17.3284 6.5 18 7.17157 18 8V9.5H4L4 8C4 7.17157 4.67157 6.5 5.5 6.5H6.5V7C6.5 7.82843 7.17157 8.5 8 8.5C8.82843 8.5 9.5 7.82843 9.5 7V6.5L12.5 6.5Z" fill="#45474D"></path><path d="M16 17C15.7239 17 15.5 16.7761 15.5 16.5V14C15.5 13.7239 15.7239 13.5 16 13.5C16.2761 13.5 16.5 13.7239 16.5 14V16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H16Z" fill="#45474D"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 21.5C18.7614 21.5 21 19.2614 21 16.5C21 13.7386 18.7614 11.5 16 11.5C13.2386 11.5 11 13.7386 11 16.5C11 19.2614 13.2386 21.5 16 21.5ZM16 20.5C18.2091 20.5 20 18.7091 20 16.5C20 14.2909 18.2091 12.5 16 12.5C13.7909 12.5 12 14.2909 12 16.5C12 18.7091 13.7909 20.5 16 20.5Z" fill="#45474D"></path></svg>
                            January 04th  2025 | 4:30 PM
                        </h6>
                        <h6 class="card-text">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="css-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 10.0714C5.5 6.2881 8.96304 4 12 4C15.037 4 18.5 6.2881 18.5 10.0714C18.5 12.4463 17.3299 14.5887 15.8656 16.3303C14.4439 18.0211 12.8224 19.2405 12 19.8053C11.1776 19.2405 9.55612 18.0211 8.13442 16.3303C6.67006 14.5887 5.5 12.4463 5.5 10.0714ZM4.5 10.0714C4.5 5.57143 8.59091 3 12 3C15.4091 3 19.5 5.57143 19.5 10.0714C19.5 15.4847 14.1819 19.5305 12.5021 20.6734C12.1968 20.8812 11.8032 20.8812 11.4979 20.6734C9.81808 19.5305 4.5 15.4847 4.5 10.0714ZM10 10.5C10 9.39543 10.8954 8.5 12 8.5C13.1046 8.5 14 9.39543 14 10.5C14 11.6046 13.1046 12.5 12 12.5C10.8954 12.5 10 11.6046 10 10.5ZM12 7.5C10.3431 7.5 9 8.84315 9 10.5C9 12.1569 10.3431 13.5 12 13.5C13.6569 13.5 15 12.1569 15 10.5C15 8.84315 13.6569 7.5 12 7.5Z" fill="#45474D"></path></svg>
    Location Not Disclosed
                        </h6>
                    </div>
                    <div class="footer-card d-flex justify-content-between">
                        <p class="card-footer-content">Event Finished</p>
                       <p class="card-footer-content">
  <a href="#" class="btn btn-danger">View Gallery</a>
</p>

                    </div>
                </div>
            </div>
            <div class="item">
                    <div class="item-overlay">
                        <h6>Upcoming Events</h6>
                    </div>
                    <div class="card bg-white" data-event-type="upcoming" >
                        <img src="img/events/Event-05.jpg""
                            class="card-img-top" alt="buddy">
                        <div class="card-body">
                            <h5 class="card-title fw-bold">Event: Stay Tuned</h5>
                            <h6 class="card-text">
        <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 5.5L6.5 5.5V5C6.5 4.17157 7.17157 3.5 8 3.5C8.82843 3.5 9.5 4.17157 9.5 5V5.5L12.5 5.5V5C12.5 4.17157 13.1716 3.5 14 3.5C14.8284 3.5 15.5 4.17157 15.5 5V5.5H16.5C17.8807 5.5 19 6.61929 19 8V10.6429C19 10.919 18.7761 11.1429 18.5 11.1429C18.2239 11.1429 18 10.919 18 10.6429V10.5H4L4 17C4 17.8284 4.67157 18.5 5.5 18.5L9.5 18.5C9.77614 18.5 10 18.7239 10 19C10 19.2761 9.77614 19.5 9.5 19.5H5.5C4.11929 19.5 3 18.3807 3 17V8C3 6.61929 4.11929 5.5 5.5 5.5ZM7.5 5V7C7.5 7.27614 7.72386 7.5 8 7.5C8.27614 7.5 8.5 7.27614 8.5 7V5C8.5 4.72386 8.27614 4.5 8 4.5C7.72386 4.5 7.5 4.72386 7.5 5ZM14.5 5C14.5 4.72386 14.2761 4.5 14 4.5C13.7239 4.5 13.5 4.72386 13.5 5V7C13.5 7.27614 13.7239 7.5 14 7.5C14.2761 7.5 14.5 7.27614 14.5 7V5ZM12.5 6.5V7C12.5 7.82843 13.1716 8.5 14 8.5C14.8284 8.5 15.5 7.82843 15.5 7V6.5L16.5 6.5C17.3284 6.5 18 7.17157 18 8V9.5H4L4 8C4 7.17157 4.67157 6.5 5.5 6.5H6.5V7C6.5 7.82843 7.17157 8.5 8 8.5C8.82843 8.5 9.5 7.82843 9.5 7V6.5L12.5 6.5Z" fill="#45474D"></path><path d="M16 17C15.7239 17 15.5 16.7761 15.5 16.5V14C15.5 13.7239 15.7239 13.5 16 13.5C16.2761 13.5 16.5 13.7239 16.5 14V16H17.5C17.7761 16 18 16.2239 18 16.5C18 16.7761 17.7761 17 17.5 17H16Z" fill="#45474D"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 21.5C18.7614 21.5 21 19.2614 21 16.5C21 13.7386 18.7614 11.5 16 11.5C13.2386 11.5 11 13.7386 11 16.5C11 19.2614 13.2386 21.5 16 21.5ZM16 20.5C18.2091 20.5 20 18.7091 20 16.5C20 14.2909 18.2091 12.5 16 12.5C13.7909 12.5 12 14.2909 12 16.5C12 18.7091 13.7909 20.5 16 20.5Z" fill="#45474D"></path></svg>
                                January 26th  2025 | 5:30PM
                            </h6>
                            <h6 class="card-text">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="css-0"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 10.0714C5.5 6.2881 8.96304 4 12 4C15.037 4 18.5 6.2881 18.5 10.0714C18.5 12.4463 17.3299 14.5887 15.8656 16.3303C14.4439 18.0211 12.8224 19.2405 12 19.8053C11.1776 19.2405 9.55612 18.0211 8.13442 16.3303C6.67006 14.5887 5.5 12.4463 5.5 10.0714ZM4.5 10.0714C4.5 5.57143 8.59091 3 12 3C15.4091 3 19.5 5.57143 19.5 10.0714C19.5 15.4847 14.1819 19.5305 12.5021 20.6734C12.1968 20.8812 11.8032 20.8812 11.4979 20.6734C9.81808 19.5305 4.5 15.4847 4.5 10.0714ZM10 10.5C10 9.39543 10.8954 8.5 12 8.5C13.1046 8.5 14 9.39543 14 10.5C14 11.6046 13.1046 12.5 12 12.5C10.8954 12.5 10 11.6046 10 10.5ZM12 7.5C10.3431 7.5 9 8.84315 9 10.5C9 12.1569 10.3431 13.5 12 13.5C13.6569 13.5 15 12.1569 15 10.5C15 8.84315 13.6569 7.5 12 7.5Z" fill="#45474D"></path></svg>
        Location Not Disclosed
                            </h6>
                        </div>
                        <div class="footer-card d-flex justify-content-between">
                            <p class="card-footer-content">₹250 onwards</p>
                            <p class="card-footer-content">
  <a href="details.html" class="btn btn-danger">Buy Now</a>
</p>

                        </div>
                    </div>
               
            </div>
       
        </div>
    </div>
</div>

<div class="gallery-container">
    <h1>Captured Moments</h1>
    <div class="filters">
      <button class="filter-btn active" data-category="all">All</button>
      <button class="filter-btn" data-category="event-1">A Stranger Turned Close Friend</button>
      <button class="filter-btn" data-category="event-2">Happy Childhood Moments</button>
      <button class="filter-btn" data-category="event-3">Joyful Rain Memories</button>
      <button class="filter-btn" data-category="event-4">Your Most Relatable Meme/Reel Of 2024</button>
    </div>
    <div class="gallery">
      <div class="gallery-item event-1">
        <img src="img/banners/1.jpg" alt="Mountains">
      </div>
      <div class="gallery-item event-2">
        <img src="img/banners/2.jpg" alt="Sea">
      </div>
      <div class="gallery-item event-3">
        <img src="img/banners/3.jpg" alt="Sunset">
      </div>
      <div class="gallery-item event-4">
        <img src="img/banners/4.jpg" alt="Mountains">
      </div>
      <div class="gallery-item event-1">
        <img src="img/banners/5.jpg" alt="Forest">
      </div>
      <div class="gallery-item event-3">
        <img src="img/banners/6.jpg" alt="Sea">
      </div>

      <div class="gallery-item event-1">
        <img src="img/banners/7.jpg" alt="Mountains">
      </div>
      <div class="gallery-item event-2">
        <img src="img/banners/8.jpg" alt="Sea">
      </div>
      <div class="gallery-item event-3">
        <img src="img/banners/9.jpg" alt="Sunset">
      </div>
      <div class="gallery-item event-4">
        <img src="img/banners/10.jpg" alt="Mountains">
      </div>
      <div class="gallery-item event-2">
        <img src="img/banners/11.jpg" alt="Forest">
      </div>
      <div class="gallery-item event-4">
        <img src="img/banners/12.jpg" alt="Sea">
      </div>
    </div>
   <!-- View More Button -->
   <div class="view-more-container">
    <button id="view-more-btn">View More</button>
  </div>
  </div>

  <section class="reels-section">
    <h1>Our Latest Reels</h1>
    <a href="https://www.instagram.com/reel/DCo2dxtSPFD/" target="_blank">
      <img src="reel-thumbnail1.jpg" alt="Watch Reel 1">
    </a>
    <a href="https://www.instagram.com/reel/DBllWehy0F3/" target="_blank">
      <img src="reel-thumbnail2.jpg" alt="Watch Reel 2">
    </a>
  </section>
  
  
<?php include 'footer.php'; ?>