const track = document.querySelector(".custom-carousel-track");
const items = Array.from(track.children);
const prevButton = document.querySelector(".custom-control.custom-prev");
const nextButton = document.querySelector(".custom-control.custom-next");

let currentIndex = 2; // Center item index initially (3rd image)
let autoSlideInterval = 5000; // 5 seconds
let autoSlideTimer;

// Function to update item classes
function updateItems() {
  items.forEach((item, index) => {
    item.classList.remove("custom-active");
    if (index === currentIndex) {
      item.classList.add("custom-active");
    }
  });
}

// Function to move the carousel
function moveCarousel() {
  const offset = -((currentIndex - 1) * (100 / 3)); // Center the active item
  track.style.transform = `translateX(${offset}%)`;
}

// Function to auto-slide the carousel
function autoSlide() {
  autoSlideTimer = setInterval(() => {
    currentIndex = (currentIndex + 1) % items.length; // Loop back to start
    updateItems();
    moveCarousel();
  }, autoSlideInterval);
}

// Function to reset the auto-slide timer
function resetAutoSlide() {
  clearInterval(autoSlideTimer);
  autoSlide();
}

// Event listeners for buttons
prevButton.addEventListener("click", () => {
  currentIndex = (currentIndex - 1 + items.length) % items.length; // Loop back to end
  updateItems();
  moveCarousel();
  resetAutoSlide();
});

nextButton.addEventListener("click", () => {
  currentIndex = (currentIndex + 1) % items.length; // Loop back to start
  updateItems();
  moveCarousel();
  resetAutoSlide();
});

// Initialize
updateItems();
moveCarousel();
autoSlide(); // Start auto-slide
