<div class="front_page_section front_page_section_contacts<?php
	$foodie_scheme = foodie_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $foodie_scheme ) && ! foodie_is_inherit( $foodie_scheme ) ) {
		echo ' scheme_' . esc_attr( $foodie_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( foodie_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( foodie_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$foodie_css      = '';
		$foodie_bg_image = foodie_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $foodie_bg_image ) ) {
			$foodie_css .= 'background-image: url(' . esc_url( foodie_get_attachment_url( $foodie_bg_image ) ) . ');';
		}
		if ( ! empty( $foodie_css ) ) {
			echo ' style="' . esc_attr( $foodie_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$foodie_anchor_icon = foodie_get_theme_option( 'front_page_contacts_anchor_icon' );
	$foodie_anchor_text = foodie_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $foodie_anchor_icon ) || ! empty( $foodie_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $foodie_anchor_icon ) ? ' icon="' . esc_attr( $foodie_anchor_icon ) . '"' : '' )
									. ( ! empty( $foodie_anchor_text ) ? ' title="' . esc_attr( $foodie_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( foodie_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' foodie-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$foodie_css      = '';
			$foodie_bg_mask  = foodie_get_theme_option( 'front_page_contacts_bg_mask' );
			$foodie_bg_color_type = foodie_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $foodie_bg_color_type ) {
				$foodie_bg_color = foodie_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $foodie_bg_color_type ) {
				$foodie_bg_color = foodie_get_scheme_color( 'bg_color', $foodie_scheme );
			} else {
				$foodie_bg_color = '';
			}
			if ( ! empty( $foodie_bg_color ) && $foodie_bg_mask > 0 ) {
				$foodie_css .= 'background-color: ' . esc_attr(
					1 == $foodie_bg_mask ? $foodie_bg_color : foodie_hex2rgba( $foodie_bg_color, $foodie_bg_mask )
				) . ';';
			}
			if ( ! empty( $foodie_css ) ) {
				echo ' style="' . esc_attr( $foodie_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$foodie_caption     = foodie_get_theme_option( 'front_page_contacts_caption' );
			$foodie_description = foodie_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $foodie_caption ) || ! empty( $foodie_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $foodie_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $foodie_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $foodie_caption, 'foodie_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $foodie_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $foodie_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $foodie_description ), 'foodie_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$foodie_content = foodie_get_theme_option( 'front_page_contacts_content' );
			$foodie_layout  = foodie_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $foodie_layout && ( ! empty( $foodie_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $foodie_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $foodie_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $foodie_content, 'foodie_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $foodie_layout && ( ! empty( $foodie_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$foodie_sc = foodie_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $foodie_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $foodie_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					foodie_show_layout( do_shortcode( $foodie_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $foodie_layout && ( ! empty( $foodie_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
