<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

$foodie_template = apply_filters( 'foodie_filter_get_template_part', foodie_blog_archive_get_template() );

if ( ! empty( $foodie_template ) && 'index' != $foodie_template ) {

	get_template_part( $foodie_template );

} else {

	foodie_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$foodie_stickies   = is_home()
								|| ( in_array( foodie_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) foodie_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$foodie_post_type  = foodie_get_theme_option( 'post_type' );
		$foodie_args       = array(
								'blog_style'     => foodie_get_theme_option( 'blog_style' ),
								'post_type'      => $foodie_post_type,
								'taxonomy'       => foodie_get_post_type_taxonomy( $foodie_post_type ),
								'parent_cat'     => foodie_get_theme_option( 'parent_cat' ),
								'posts_per_page' => foodie_get_theme_option( 'posts_per_page' ),
								'sticky'         => foodie_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $foodie_stickies )
															&& count( $foodie_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		foodie_blog_archive_start();

		do_action( 'foodie_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'foodie_action_before_page_author' );
			get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'foodie_action_after_page_author' );
		}

		if ( foodie_get_theme_option( 'show_filters' ) ) {
			do_action( 'foodie_action_before_page_filters' );
			foodie_show_filters( $foodie_args );
			do_action( 'foodie_action_after_page_filters' );
		} else {
			do_action( 'foodie_action_before_page_posts' );
			foodie_show_posts( array_merge( $foodie_args, array( 'cat' => $foodie_args['parent_cat'] ) ) );
			do_action( 'foodie_action_after_page_posts' );
		}

		do_action( 'foodie_action_blog_archive_end' );

		foodie_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
