<?php
/**
 * The template to display single post
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

// Full post loading
$full_post_loading          = foodie_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = foodie_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = foodie_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$foodie_related_position   = foodie_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$foodie_posts_navigation   = foodie_get_theme_option( 'posts_navigation' );
$foodie_prev_post          = false;
$foodie_prev_post_same_cat = foodie_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( foodie_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	foodie_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'foodie_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $foodie_posts_navigation ) {
		$foodie_prev_post = get_previous_post( $foodie_prev_post_same_cat );  // Get post from same category
		if ( ! $foodie_prev_post && $foodie_prev_post_same_cat ) {
			$foodie_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $foodie_prev_post ) {
			$foodie_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $foodie_prev_post ) ) {
		foodie_sc_layouts_showed( 'featured', false );
		foodie_sc_layouts_showed( 'title', false );
		foodie_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $foodie_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/content', 'single-' . foodie_get_theme_option( 'single_style' ) ), 'single-' . foodie_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $foodie_related_position, 'inside' ) === 0 ) {
		$foodie_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'foodie_action_related_posts' );
		$foodie_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $foodie_related_content ) ) {
			$foodie_related_position_inside = max( 0, min( 9, foodie_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $foodie_related_position_inside ) {
				$foodie_related_position_inside = mt_rand( 1, 9 );
			}

			$foodie_p_number         = 0;
			$foodie_related_inserted = false;
			$foodie_in_block         = false;
			$foodie_content_start    = strpos( $foodie_content, '<div class="post_content' );
			$foodie_content_end      = strrpos( $foodie_content, '</div>' );

			for ( $i = max( 0, $foodie_content_start ); $i < min( strlen( $foodie_content ) - 3, $foodie_content_end ); $i++ ) {
				if ( $foodie_content[ $i ] != '<' ) {
					continue;
				}
				if ( $foodie_in_block ) {
					if ( strtolower( substr( $foodie_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$foodie_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $foodie_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $foodie_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$foodie_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $foodie_content[ $i + 1 ] && in_array( $foodie_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$foodie_p_number++;
					if ( $foodie_related_position_inside == $foodie_p_number ) {
						$foodie_related_inserted = true;
						$foodie_content = ( $i > 0 ? substr( $foodie_content, 0, $i ) : '' )
											. $foodie_related_content
											. substr( $foodie_content, $i );
					}
				}
			}
			if ( ! $foodie_related_inserted ) {
				if ( $foodie_content_end > 0 ) {
					$foodie_content = substr( $foodie_content, 0, $foodie_content_end ) . $foodie_related_content . substr( $foodie_content, $foodie_content_end );
				} else {
					$foodie_content .= $foodie_related_content;
				}
			}
		}

		foodie_show_layout( $foodie_content );
	}

	// Comments
	do_action( 'foodie_action_before_comments' );
	comments_template();
	do_action( 'foodie_action_after_comments' );

	// Related posts
	if ( 'below_content' == $foodie_related_position
		&& ( 'scroll' != $foodie_posts_navigation || foodie_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || foodie_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'foodie_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $foodie_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $foodie_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $foodie_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $foodie_prev_post ) ); ?>"
			<?php do_action( 'foodie_action_nav_links_single_scroll_data', $foodie_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
