<?php
/**
 * The template to display the site logo in the footer
 *
 * @package FOODIE
 * @since FOODIE 1.0.10
 */

// Logo
if ( foodie_is_on( foodie_get_theme_option( 'logo_in_footer' ) ) ) {
	$foodie_logo_image = foodie_get_logo_image( 'footer' );
	$foodie_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $foodie_logo_image['logo'] ) || ! empty( $foodie_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $foodie_logo_image['logo'] ) ) {
					$foodie_attr = foodie_getimagesize( $foodie_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $foodie_logo_image['logo'] ) . '"'
								. ( ! empty( $foodie_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $foodie_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'foodie' ) . '"'
								. ( ! empty( $foodie_attr[3] ) ? ' ' . wp_kses_data( $foodie_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $foodie_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $foodie_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
